<?php
session_start();
include_once 'security/connection_sql.php'; 
// NEW: read stname to know the opener
$stname = isset($_GET['stname']) ? $_GET['stname'] : ''; 
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
    <title>Search Item</title> 
    <!-- Bootstrap CSS (from CDN) -->
    
    
    <!-- DataTables CSS (from CDN) -->
    <link href="https://cdn.datatables.net/1.10.21/css/jquery.dataTables.min.css" rel="stylesheet" type="text/css"> 
    
    <script src="vendor/new/multi/jquery-3.5.1.js"></script> 
    <style>
        tfoot input {
            width: 100%;
            padding: 3px;
            box-sizing: border-box;
        }
    </style>
</head>
<body style="margin:20px;">
 

<table id="example" class="display" style="width:100% ;  ">
    <thead>
        <tr>
            <th align="center">Code</th>
            <th align="center">Name</th>
            <th align="center">Address</th>
            <th align="center">Tel</th>
            <th align="center">Sub Cus Code</th>
        </tr>
    </thead>
    <tbody>
        <?php
        $sql = "SELECT * from view_vendor order by CODE ASC"; 
        foreach ($conn->query($sql) as $row) {
            //$cuscode = $row["c_code"];
            // ...existing code...
            echo "<tr>
                     <td align='center' onclick='custno(this, \"$stname\");'>" . $row['CODE'] . "</td>
                    <td align='left'   onclick='custno(this, \"$stname\");'>" . $row['c_name'] . "</td>
                    <td align='left'   onclick='custno(this, \"$stname\");'>" . $row['c_add'] . "</td>
                    <td align='left'   onclick='custno(this, \"$stname\");'>" . $row['c_tele'] . "</td>
                    <td align='center' onclick='custno(this, \"$stname\");'>" . $row['c_code'] . "</td>
                  </tr>";
        }
        ?>
    </tbody>
    <tfoot>
        <tr>
            <th>Customer Code</th>
            <th>Customer Name</th>
            <th>Address</th>
            <th>Tel</th>
            <th>Sub Cus Code</th>
        </tr>
    </tfoot>
</table>
<script src="https://code.jquery.com/jquery-3.5.1.min.js"></script>
<script src="https://cdn.datatables.net/1.10.21/js/jquery.dataTables.min.js"></script>

<script type="text/javascript">
// Return selected customer to opener
function custno(cell, stname) {
    try {
        var $row = $(cell).closest('tr');
        var tds = $row.find('td');
        var data = {
            code:    (tds.eq(0).text() || '').trim(), // CODE
            name:    (tds.eq(1).text() || '').trim(), // Name
            address: (tds.eq(2).text() || '').trim(),
            tel:     (tds.eq(3).text() || '').trim(),
            subcode: (tds.eq(4).text() || '').trim(), // c_code
            stname:  stname || ''
        };

        if (window.opener && !window.opener.closed) {
            if (typeof window.opener.setCustomerFromSearch === 'function') {
                window.opener.setCustomerFromSearch(data);
            } else {
                // Fallback: try common fields if receiver not defined
                var doc = window.opener.document;
                setValue(doc, ['#cuscode','[name="cuscode"]'], data.code);
                setValue(doc, ['#cusname','[name="cusname"]'], data.name);
                setValue(doc, ['#c_subcode','[name="c_subcode"]'], data.subcode);
            }
            try { window.opener.focus(); } catch(e) {}
            window.close();
        } else {
            alert('Parent window not found.');
        }
    } catch (e) {
        console.error(e);
        alert('Unable to return the selected customer.');
    }
}

function setValue(doc, selectors, value) {
    for (var i = 0; i < selectors.length; i++) {
        var el = doc.querySelector(selectors[i]);
        if (el) { el.value = value; return; }
    }
}

$(document).ready(function() {
    var table = $('#example').DataTable({
        lengthChange: true,
        fixedHeader: true,
        responsive: true,
        deferRender: true,
        order: [[0, 'desc']],
        lengthMenu: [[10, 25, 50, 100, -1], ['10 rows', '25 rows', '50 rows', '100 rows', 'Show all']],
        initComplete: function () {
            this.api().columns().every(function () {
                var that = this;
                $('input', this.footer()).on('keyup change clear', function () {
                    if (that.search() !== this.value) {
                        that.search(this.value).draw();
                    }
                });
            });
        }
    });
});
</script>

</body>
</html>
