<?php
include('security.php');
require_once("connectioni.php");

// Check if form was submitted with save command
if (isset($_POST['cmd_save']) && $_POST['cmd_save'] == '1') {
    
    // Get main order details
    $customer_code = mysqli_real_escape_string($GLOBALS['dbinv'], $_POST['firstname_hidden'] ?? '');
    $customer_name = mysqli_real_escape_string($GLOBALS['dbinv'], $_POST['firstname'] ?? '');
    $order_date = mysqli_real_escape_string($GLOBALS['dbinv'], $_POST['invdate'] ?? date('Y-m-d'));
    $schedule_date = mysqli_real_escape_string($GLOBALS['dbinv'], $_POST['sinvdate'] ?? '');
    $delivery_marking_date = mysqli_real_escape_string($GLOBALS['dbinv'], $_POST['delivery_marking_date'] ?? '');
    $delivery_type = mysqli_real_escape_string($GLOBALS['dbinv'], $_POST['delitype'] ?? '');
    $department = mysqli_real_escape_string($GLOBALS['dbinv'], $_POST['department'] ?? '');
    $brand = mysqli_real_escape_string($GLOBALS['dbinv'], $_POST['brand'] ?? '');
    $sales_rep = mysqli_real_escape_string($GLOBALS['dbinv'], $_POST['salesrep'] ?? '');
    $payment_method = mysqli_real_escape_string($GLOBALS['dbinv'], $_POST['paymethod'] ?? '');
    $vat_type = mysqli_real_escape_string($GLOBALS['dbinv'], $_POST['vatgroup'] ?? '');
    $discount1 = floatval($_POST['discount_org1'] ?? 0);
    $discount2 = floatval($_POST['discount_org2'] ?? 0);
    $subtotal = floatval($_POST['order_subtotal'] ?? 0);
    $total_discount = floatval($_POST['totdiscount'] ?? 0);
    $tax_amount = floatval($_POST['tax'] ?? 0);
    $invoice_total = floatval($_POST['invtot'] ?? 0);
    $credit_period = mysqli_real_escape_string($GLOBALS['dbinv'], $_POST['credper'] ?? '');
    $delivery_name = mysqli_real_escape_string($GLOBALS['dbinv'], $_POST['deli_name'] ?? '');
    $delivery_address = mysqli_real_escape_string($GLOBALS['dbinv'], $_POST['deli_address'] ?? '');
    
    // Generate new order number
    $sql = "SELECT MAX(CAST(SUBSTRING(ord_no, 3) AS UNSIGNED)) as max_id FROM s_cusord";
    $result = mysqli_query($GLOBALS['dbinv'], $sql);
    $row = mysqli_fetch_assoc($result);
    $next_id = ($row['max_id'] ?? 0) + 1;
    $order_no = "SO" . str_pad($next_id, 7, '0', STR_PAD_LEFT);
    
    // Begin transaction
    mysqli_autocommit($GLOBALS['dbinv'], FALSE);
    $success = true;
    
    // 1. Insert into main order table
    $sql = "INSERT INTO s_cusord (
        ord_no, ord_date, cus_code, cus_name, schedule_date, delivery_marking_date,
        delivery_type, department, brand, salesman_code, payment_method, vat_type,
        discount1, discount2, subtotal, tot_discount, tax_amount, grand_total,
        credit_period, delivery_name, delivery_address, user_id, entry_date
    ) VALUES (
        '$order_no', '$order_date', '$customer_code', '$customer_name', '$schedule_date', '$delivery_marking_date',
        '$delivery_type', '$department', '$brand', '$sales_rep', '$payment_method', '$vat_type',
        $discount1, $discount2, $subtotal, $total_discount, $tax_amount, $invoice_total,
        '$credit_period', '$delivery_name', '$delivery_address', '{$_SESSION['CURRENT_USER']}', NOW()
    )";
    
    if (!mysqli_query($GLOBALS['dbinv'], $sql)) {
        $success = false;
        error_log("Error saving order header: " . mysqli_error($GLOBALS['dbinv']));
    }
    
    // 2. Insert order details
    $item_count = intval($_POST['item_count'] ?? 0);
    
    for ($i = 1; $i <= $item_count; $i++) {
        if (isset($_POST["item_code_$i"])) {
            $item_code = mysqli_real_escape_string($GLOBALS['dbinv'], $_POST["item_code_$i"]);
            $rate = floatval($_POST["item_rate_$i"] ?? 0);
            $qty = floatval($_POST["item_qty_$i"] ?? 0);
            $discount = floatval($_POST["item_discount_$i"] ?? 0);
            $subtotal = floatval($_POST["subtotal_$i"] ?? 0);
            
            // Get item description from database
            $sql = "SELECT DESCRIPTION FROM s_mas WHERE STK_NO = '$item_code'";
            $result = mysqli_query($GLOBALS['dbinv'], $sql);
            $description = '';
            
            if ($result && mysqli_num_rows($result) > 0) {
                $row = mysqli_fetch_assoc($result);
                $description = mysqli_real_escape_string($GLOBALS['dbinv'], $row['DESCRIPTION']);
            }
            
            // Insert into order details table
            $sql = "INSERT INTO s_cusordtrn (
                ord_no, item_code, item_desc, rate, qty, discount, subtotal
            ) VALUES (
                '$order_no', '$item_code', '$description', $rate, $qty, $discount, $subtotal
            )";
            
            if (!mysqli_query($GLOBALS['dbinv'], $sql)) {
                $success = false;
                error_log("Error saving order detail: " . mysqli_error($GLOBALS['dbinv']));
            }
        }
    }
    
    // Commit or rollback transaction
    if ($success) {
        mysqli_commit($GLOBALS['dbinv']);
        // Set session variable to indicate successful save
        $_SESSION['save_sales_ord'] = 1;
        $_SESSION['last_order_no'] = $order_no;
        
        // Redirect back to order form
        header("Location: sales_ord_new_one.php?msg=success&ord_no=" . $order_no);
        exit;
    } else {
        mysqli_rollback($GLOBALS['dbinv']);
        header("Location: sales_ord_new_one.php?msg=error");
        exit;
    }
} else {
    // If not a save action, redirect back to order form
    header("Location: sales_ord_new_one.php");
    exit;
}
?>
