<?php
session_start();
date_default_timezone_set('Asia/Colombo');

// Always return JSON
header('Content-Type: application/json; charset=utf-8');

// Check if user is logged in
if (!isset($_SESSION["CURRENT_USER"]) || $_SESSION["CURRENT_USER"] == "") {
    echo json_encode(["status" => "error", "message" => "Please log in again. Session is invalid."]);
    exit();
}

require_once("connectioni.php");

// Normalize DB connection variable - connectioni.php usually sets $dbinv
$conn = null;
if (isset($GLOBALS['dbinv']) && $GLOBALS['dbinv']) {
    $conn = $GLOBALS['dbinv'];
} elseif (isset($dbinv) && $dbinv) {
    $conn = $dbinv;
}

if (!$conn) {
    echo json_encode(["status" => "error", "message" => "Database connection not available"]);
    exit();
}

// Get current user and employee_id from session
$user = $_SESSION["CURRENT_USER"];
$today = date("Y-m-d H:i:s");

try {
    // Validate required fields
    // Basic required fields validation
    if (empty($_POST['cuscode']) || empty($_POST['cheqnum']) || !isset($_POST['amount']) || trim($_POST['amount']) === '') {
        echo json_encode(["status" => "error", "message" => "Required fields are missing"]);
        exit();
    }
    
    // Clean and prepare data
    // Trim inputs
    $_POST = array_map(function($v){ return is_string($v) ? trim($v) : $v; }, $_POST);

    $cuscode = mysqli_real_escape_string($conn, $_POST['cuscode']);
    $cusname = isset($_POST['cusname']) ? mysqli_real_escape_string($conn, $_POST['cusname']) : '';
    $c_subcode = isset($_POST['c_subcode']) ? mysqli_real_escape_string($conn, $_POST['c_subcode']) : '';
    $refno = empty($_POST['refno']) ? generate_reference_number($conn) : mysqli_real_escape_string($conn, $_POST['refno']);
    $date = isset($_POST['date']) ? mysqli_real_escape_string($conn, $_POST['date']) : date('Y-m-d');
    $invnum = isset($_POST['invnum']) ? mysqli_real_escape_string($conn, $_POST['invnum']) : '';
    $invamount = empty($_POST['invamount']) ? 0 : floatval($_POST['invamount']);
    $cheqnum = mysqli_real_escape_string($conn, $_POST['cheqnum']);
    $cheqdate = (isset($_POST['cheqdate']) && $_POST['cheqdate'] !== '') ? mysqli_real_escape_string($conn, $_POST['cheqdate']) : null;
    $amount = floatval($_POST['amount']);
    $bank = isset($_POST['bank']) ? mysqli_real_escape_string($conn, $_POST['bank']) : '';

    // Location fields
    $street = isset($_POST['street']) ? mysqli_real_escape_string($conn, $_POST['street']) : '';
    $latitude = isset($_POST['latitude']) && $_POST['latitude'] !== '' ? floatval($_POST['latitude']) : null;
    $longitude = isset($_POST['longitude']) && $_POST['longitude'] !== '' ? floatval($_POST['longitude']) : null;

    // Insert or update record based on reference number
    if (empty($_POST['refno'])) {
        // Insert new record
        $sql = "INSERT INTO cheque_collection (
                    ref_no, cus_code, cus_name, c_subcode, date, inv_no, inv_amount,
                    cheque_no, cheque_date, amount, bank, street, latitude, longitude,
                    created_by, created_at
                ) VALUES (
                    '$refno', '$cuscode', '$cusname', '$c_subcode', '$date', '$invnum', $invamount,
                    '$cheqnum', " . ($cheqdate === null ? "NULL" : "'$cheqdate'") . ", $amount, '$bank', '$street',
                    " . ($latitude === null ? "NULL" : $latitude) . ",
                    " . ($longitude === null ? "NULL" : $longitude) . ",
                    '$user', '$today'
                )";
        
        if (mysqli_query($conn, $sql)) {
            echo json_encode([
                "status" => "success", 
                "message" => "Cheque collection saved successfully",
                "refno" => $refno
            ]);
        } else {
            echo json_encode([
                "status" => "error", 
                "message" => "Error saving record: " . mysqli_error($conn)
            ]);
        }
    } else {
        // Update existing record
        $sql = "UPDATE cheque_collection SET
                    cus_code = '$cuscode',
                    cus_name = '$cusname',
                    c_subcode = '$c_subcode',
                    date = '$date',
                    inv_no = '$invnum',
                    inv_amount = $invamount,
                    cheque_no = '$cheqnum',
                    cheque_date = " . ($cheqdate === null ? "NULL" : "'$cheqdate'") . ",
                    amount = $amount,
                    bank = '$bank',
                    street = '$street',
                    latitude = " . ($latitude === null ? "NULL" : $latitude) . ",
                    longitude = " . ($longitude === null ? "NULL" : $longitude) . ",
                    updated_by = '$user',
                    updated_at = '$today'
                WHERE ref_no = '$refno'";
        
        if (mysqli_query($conn, $sql)) {
            echo json_encode([
                "status" => "success", 
                "message" => "Cheque collection updated successfully",
                "refno" => $refno
            ]);
        } else {
            echo json_encode([
                "status" => "error", 
                "message" => "Error updating record: " . mysqli_error($conn)
            ]);
        }
    }
} catch (Exception $e) {
    echo json_encode([
        "status" => "error", 
        "message" => "An error occurred: " . $e->getMessage()
    ]);
}

// Function to generate a unique reference number
function generate_reference_number($conn) {
    $prefix = 'CHQ' . date('Ymd');
    
    // Get the last reference number with this prefix
    $sql = "SELECT ref_no FROM cheque_collection 
            WHERE ref_no LIKE '$prefix%' 
            ORDER BY ref_no DESC LIMIT 1";
    
    $result = mysqli_query($conn, $sql);
    
    if (mysqli_num_rows($result) > 0) {
        $row = mysqli_fetch_assoc($result);
        $last_ref = $row['ref_no'];
        $last_num = intval(substr($last_ref, -4));
        $new_num = $last_num + 1;
    } else {
        $new_num = 1;
    }
    
    // Format with leading zeros
    return $prefix . str_pad($new_num, 4, '0', STR_PAD_LEFT);
}


