<?php
session_start();
header('Content-Type: application/json');

// Basic session check
if (!isset($_SESSION["CURRENT_USER"]) || $_SESSION["CURRENT_USER"] == "") {
    http_response_code(401);
    echo json_encode(['error' => 'Unauthorized access']);
    exit();
}

// Database connection
require_once("security/connection_sql.php");

// Ensure PDO throws exceptions
if (isset($conn) && $conn instanceof PDO) {
    $conn->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
} else {
    http_response_code(500);
    echo json_encode(['error' => 'Database connection not available']);
    exit();
}

try {
    // Get parameters
    $date = isset($_GET['date']) ? $_GET['date'] : date('Y-m-d');
    $sal_ex = isset($_GET['sal_ex']) ? $_GET['sal_ex'] : '';
    
    // Build query
    $sql = "SELECT 
                v.sdate1 AS timestamp,
                v.cus_name,
                v.ref_no,
                v.collect,
                v.flag,
                v.llatitude AS latitude,
                v.llongitude AS longitude,
                v.c_code AS customer_code,
                v.ref_no1 AS sales_exec,
                TIME(v.sdate1) as visit_time
            FROM vendor_visit v
            WHERE DATE(v.sdate1) = :selected_date
            AND v.llatitude IS NOT NULL 
            AND v.llongitude IS NOT NULL";

    $params = [':selected_date' => $date];
    
    if (!empty($sal_ex)) {
        $sql .= " AND v.ref_no1 = :sal_ex";
        $params[':sal_ex'] = $sal_ex;
    }
    
    $sql .= " ORDER BY v.sdate1 ASC";
    
    // Execute query
    $stmt = $conn->prepare($sql);
    $stmt->execute($params);
    $route_data = $stmt->fetchAll(PDO::FETCH_ASSOC);
    
    // Calculate some stats
    $stats = [
        'total_visits' => count($route_data),
        'total_amount' => 0,
        'start_time' => !empty($route_data) ? $route_data[0]['visit_time'] : null,
        'end_time' => !empty($route_data) ? end($route_data)['visit_time'] : null
    ];
    
    foreach ($route_data as $visit) {
        //$stats['total_amount'] += floatval($visit['collect']);
        // Only add to total if collect is numeric
        if (is_numeric($visit['collect'])) {
            $stats['total_amount'] += floatval($visit['collect']);
        }
    }
    
    // Return the data
    echo json_encode([
        'status' => 'success',
        'data' => $route_data,
        'stats' => $stats
    ]);
    
} catch (Throwable $e) {
    http_response_code(500);
    echo json_encode(['error' => $e->getMessage()]);
}
?>
