<?php 
  ini_set('session.gc_maxlifetime', 30 * 60 * 60 * 60);
  session_start();
  date_default_timezone_set('Asia/Colombo');
  require_once("connectioni.php");
  ?>  

  <!-- CSS Files -->
  <link rel="stylesheet" href="css/table.css" type="text/css"/> 
  <link rel="stylesheet" type="text/css" media="all" href="css/jsDatePick_ltr.min.css" />

  <!-- JavaScript Files -->
  <script src="js/pur_ord.js"></script>
  <script src="js/jsDatePick.min.1.3.js"></script>
  <script src="js/get_cat_description.js"></script>
  <script src="js/datepickr.js"></script>
  <script src="cal2.js"></script>
  <script src="cal_conf2.js"></script>

  <!-- Popup New Window Function -->
  <script type="text/javascript">
  var win = null;
  function NewWindow(mypage, myname, w, h, scroll, pos) {
    if (pos == "random") {
      LeftPosition = (screen.width) ? Math.floor(Math.random() * (screen.width - w)) : 100;
      TopPosition = (screen.height) ? Math.floor(Math.random() * ((screen.height - h) - 75)) : 100;
    }
    if (pos == "center") {
      LeftPosition = (screen.width) ? (screen.width - w) / 2 : 100;
      TopPosition = (screen.height) ? (screen.height - h) / 2 : 100;
    } else if (pos != "center" && pos != "random" || pos == null) {
      LeftPosition = 0;
      TopPosition = 20;
    }
    settings = 'width=' + w + ',height=' + h + ',top=' + TopPosition + ',left=' + LeftPosition + ',scrollbars=' + scroll + ',location=no,directories=no,status=no,menubar=no,toolbar=no,resizable=no';
    win = window.open(mypage, myname, settings);
  }
  </script>

  <!-- Another Popup (used?) -->
  <script type="text/javascript">
  function openWin() {
    var myWindow = window.open('serach_inv.php', '', 'width=200,height=100');
    myWindow.focus();
  }
  </script>

  <!-- Date Picker Initialization -->
  <script type="text/javascript">
  window.onload = function() {
    new JsDatePick({
      useMode: 2,
      target: "dte_shedule",
      dateFormat: "%Y-%m-%d"
    });
  };
  </script>

  <!-- Page Styles -->
  <style>
  .style1 { 
      font-weight: bold; 
  } 

  .col-md-3, .col-md-6 { 
      margin-top: 15px; 
  }
  </style>


  <fieldset>
    <legend>
      <div class="text_forheader" ><b>Stock Report</b></div>
    </legend>

    <form id="form1" name="form1" action="report_stock2.php" target="_blank" method="get">

      <!-- Filters Section -->
      <div class="row mt-3">
        
        <!-- Brand -->
        <div class="col-md-3">
          <label for="brand" class="form-label">Brand</label>
          <select name="brand" id="brand" class="form-control input-sm" onkeypress="keyset('brand',event);" onchange="setlist();">
            <option value='All'>All</option>
            <?php
            if ($_SESSION["CURRENT_DEP"] != "") {
              $sql = "SELECT * FROM brand_mas WHERE act = '1' AND costcenter = '".$_SESSION["department"]."' ORDER BY barnd_name"; 
            } else {
              $sql = "SELECT * FROM brand_mas WHERE act = '1' ORDER BY barnd_name";
            }
            $result = mysqli_query($GLOBALS['dbinv'], $sql);
            while ($row = mysqli_fetch_array($result)) {
              echo "<option value='".$row["barnd_name"]."'>".$row["barnd_name"]."</option>";
            }
            ?>
          </select>
        </div>

        <!-- Department -->
        <div class="col-md-3">
          <label for="department" class="form-label">Department</label>
          <select name="department" id="department" class="form-control input-sm" onkeypress="keyset('brand',event);">
            <?php
            echo "<option value='All'>All</option>";
            if ($_SESSION["CURRENT_DEP"] != "") {
              $sql = "SELECT * FROM s_stomas WHERE act = '0' AND department = '".$_SESSION["department"]."' ORDER BY CODE";
            } else {
              $sql = "SELECT * FROM s_stomas WHERE act = '0' ORDER BY CODE";
            }
            $result = mysqli_query($GLOBALS['dbinv'], $sql);
            while ($row = mysqli_fetch_array($result)) {
              echo "<option value='".$row["CODE"]."'>".$row["CODE"]." ".$row["DESCRIPTION"]."</option>";
            }
            ?>
          </select>
        </div>

        <!-- Type -->
        <div class="col-md-3">
          <label for="stype" class="form-label">Type</label>
          <select name="stype" id="stype" class="form-control input-sm" onkeypress="keyset('brand',event);">
            <?php if ($_SESSION["CURRENT_REP"] == "") { ?>
              <option value='Cost'>Cost</option>
            <?php } ?>
            <option value='Selling'>Selling</option>
            <option value='Print' selected="selected">Print</option>
          </select>
        </div>

        <!-- Name -->
        <div class="col-md-3">
          <label for="cmb_t" class="form-label">Name</label>
          <select name="cmb_t" id="cmb_t" class="form-control input-sm">
            <?php
            $sql_user = "SELECT * FROM user_mast WHERE user_name = '".$_SESSION["CURRENT_USER"]."'"; 
            $result_user = mysqli_query($GLOBALS['dbinv'], $sql_user);
            $row_user = mysqli_fetch_array($result_user);
            if ($row_user["department"] != "") {
              $sql = "SELECT costcenter FROM brand_mas WHERE act = '1' AND costcenter = '".$row_user["department"]."' GROUP BY costcenter";
              $result = mysqli_query($GLOBALS['dbinv'], $sql);
              while ($row = mysqli_fetch_array($result)) {
                echo "<option value='".$row["costcenter"]."'>".$row["costcenter"]."</option>";
              }
            } else {
              echo "<option value='All'>All</option>";
              $sql = "SELECT costcenter FROM brand_mas WHERE act = '1' GROUP BY costcenter";
              $result = mysqli_query($GLOBALS['dbinv'], $sql);
              while ($row = mysqli_fetch_array($result)) {
                echo "<option value='".$row["costcenter"]."'>".$row["costcenter"]."</option>";
              }
            }
            ?>
          </select>
        </div>

      </div>

      <!-- Checkboxes Section -->
      <div class="row mt-3">
        <div class="col-md-3">
          <div class="form-check">
            <input class="form-check-input" type="checkbox" id="chkmin" name="chkmin" value="1">
            <label class="form-check-label" for="chkmin">Minus</label>
          </div>
        </div>

        <div class="col-md-3">
          <div class="form-check">
            <input class="form-check-input" type="checkbox" id="lockite" name="lockite" value="1">
            <label class="form-check-label" for="lockite">Locked Items</label>
          </div>
        </div>

        <div class="col-md-3">
          <div class="form-check">
            <input class="form-check-input" type="checkbox" id="finance" name="finance" value="1">
            <label class="form-check-label" for="finance">With Finance</label>
          </div>
        </div>

        <div class="col-md-3">
          <div class="form-check">
            <input class="form-check-input" type="checkbox" id="balqty" name="balqty" value="1">
            <label class="form-check-label" for="balqty">With Bal Qty</label>
          </div>
        </div>
      </div>

      <!-- Available / Selected Items -->
      <div class="row mt-3">

        <!-- Available Items -->
        <div class="col-md-6">
          <fieldset>
            <legend>
              <div class="text_forheader">
                <input type="checkbox" name="chkitem" id="chkitem" /> Show selected items only
              </div>
            </legend>
            <br />
            <div id="available_frm">
              <select multiple="multiple" name="available" id="available" size="20" class="form-control">
                <?php
                $sql = "SELECT STK_NO, DESCRIPT FROM s_mas ORDER BY STK_NO";
                $result = mysqli_query($GLOBALS['dbinv'], $sql);
                while ($row = mysqli_fetch_array($result)) {
                  echo "<option id='".$row["STK_NO"]."' value='".$row["STK_NO"]."' ondblclick=\"sel_one('".$row['STK_NO']."');\">".$row["STK_NO"]." ".$row["DESCRIPT"]."</option>";
                }
                ?>
              </select>
            </div>
          </fieldset>
        </div>

        <!-- Selected Items -->
        <div class="col-md-6">
          <fieldset>
            <legend>
              <div class="text_forheader">Selected Items</div>
            </legend>
            <br />
            <div id="availab">
              <select multiple="multiple" name="selectedit" id="selectedit" size="20" class="form-control">
                <!-- Selected items will appear here -->
              </select>
            </div>
          </fieldset>
        </div>

      </div>

      <!-- Submit Button -->
      <div class="row mt-3" style="margin-top: 15px;">
        <div class="col-md-12 text-center">
          <input type="submit" name="button" id="button" value="View" class="btn btn-primary" />
        </div>
      </div>

    </form>
  </fieldset>
