<!DOCTYPE html>
<html lang="en">
<head>
	<meta charset="UTF-8">
	<meta name="viewport" content="width=device-width, initial-scale=1.0">
	<title>DataTable with Pagination</title>
	<style>

		table {
			width: 100%;
			border-collapse: collapse;
			margin: 20px 0;
			box-shadow: 0 2px 10px rgba(0, 0, 0, 0.1);
		}

		th, td {
			padding: 10px;
			text-align: left;
			border: 1px solid #ddd;
		}

		th {
			background-color: #3c8dbc;
			color: white;
			cursor: pointer;
		}

		th:hover {
			background-color: #3c8dbcb5;
		}

		input[type="text"] {
			padding: 8px;
			margin: 10px 0;
			width: 100%;
			max-width: 300px;
			border: 1px solid #ccc;
			border-radius: 4px;
		}

		tr:nth-child(even) {
			background-color: #f2f2f2;
		}

		tr:hover {
			background-color: #ddd;
		}

		.pagination {
			display: flex;
			justify-content: center;
			padding: 10px;
		}

		.pagination button {
			padding: 8px 12px;
			margin: 0 5px;
			background-color: #3c8dbc;
			color: white;
			border: none;
			border-radius: 4px;
			cursor: pointer;
		}

		.pagination button:hover {
			background-color: #3c8dbcb5;
		}

		.pagination .active {
			background-color: #3c8dbcb5;
		}
		.search-container {
			display: flex;
			justify-content: flex-end;
			width: 100%;
		}
	</style>
</head>
<body>


	<section class="content">
		<div class="box box-primary">
			<div class="box-header with-border" style="margin-top:20px">
				<div>
					 
					<div style="display: flex; justify-content: space-between; align-items: center;">
						<h3 class="box-title" style="margin: 0;width: 100%;">My Saless</h3>

						<div class="search-container">
							<input type="text" id="searchInput" onkeyup="searchTable()" placeholder="Search for names..">
						</div>
					</div>
				</div>


				<table id="dataTable">
					<thead>
						<tr>
							<th> Id</th>
							<th onclick="sortTable(0)">RFC No</th>
							<th onclick="sortTable(1)">Date</th>
							<th onclick="sortTable(2)">Customer</th>
							<th onclick="sortTable(3)">Age</th>
							<th onclick="sortTable(4)">Start Date</th>
							<th onclick="sortTable(5)">Salary</th>
						</tr>
					</thead>
					<tbody>
			 
						<tr>
							<td>Brielle Williamson</td>
							<td>Integration Specialist</td>
							<td>New York</td>
							<td>61</td>
							<td>2012/12/02</td>
							<td>$372,000</td>
						</tr>
						 
					</tbody>
				</table>

				<div class="pagination" id="pagination">  </div>
			</div>
		</div>
	</section>



	<script>
		let currentPage = 1;
		const rowsPerPage = 3;


		function showPage(page) {
			const table = document.getElementById('dataTable');
			const rows = table.getElementsByTagName('tr');
			const startIndex = (page - 1) * rowsPerPage;
			const endIndex = page * rowsPerPage;

			let visibleRows = 0;

			for (let i = 1; i < rows.length; i++) {
				if (rows[i].style.display !== "none") {
					visibleRows++;
				}
			}

			let rowCount = 0;
			for (let i = 1; i < rows.length; i++) {
				if (rows[i].style.display !== "none") {
					rowCount++;
				}
			}

			for (let i = 1; i < rows.length; i++) {
				const row = rows[i];
				if (rowCount === 0 || i > startIndex && i <= endIndex) {
					row.style.display = "";
				} else {
					row.style.display = "none";
				}
			}
		}


		function sortTable(n) {
			const table = document.getElementById("dataTable");
			let switching = true;
			let shouldSwitch, i, x, y;

			while (switching) {
				switching = false;
				const rows = table.rows;
				for (i = 1; i < rows.length - 1; i++) {
					shouldSwitch = false;
					x = rows[i].getElementsByTagName("TD")[n];
					y = rows[i + 1].getElementsByTagName("TD")[n];

					if (x.innerHTML.toLowerCase() > y.innerHTML.toLowerCase()) {
						shouldSwitch = true;
						break;
					}
				}

				if (shouldSwitch) {
					rows[i].parentNode.insertBefore(rows[i + 1], rows[i]);
					switching = true;
				}
			}
		}


		function searchTable() {
			let input = document.getElementById("searchInput");
			let filter = input.value.toLowerCase();
			let table = document.getElementById("dataTable");
			let tr = table.getElementsByTagName("tr");

			for (let i = 1; i < tr.length; i++) {
				let td = tr[i].getElementsByTagName("td");
				let found = false;
				for (let j = 0; j < td.length; j++) {
					if (td[j].textContent.toLowerCase().indexOf(filter) > -1) {
						found = true;
						break;
					}
				}

				tr[i].style.display = found ? "" : "none";
			}


			showPage(1);
		}


		function createPagination() {
			const table = document.getElementById('dataTable');
			const rows = table.getElementsByTagName('tr');
			const rowCount = rows.length - 1;
			const pageCount = Math.ceil(rowCount / rowsPerPage);

			let paginationHtml = '';

			for (let i = 1; i <= pageCount; i++) {
				paginationHtml += `<button class="pagination-button" onclick="goToPage(${i})">${i}</button>`;
			}

			document.getElementById('pagination').innerHTML = paginationHtml;
		}


		function goToPage(page) {
			currentPage = page;
			showPage(currentPage);
			updateActivePageButton();
		}


		function updateActivePageButton() {
			const buttons = document.getElementsByClassName('pagination-button');
			for (let i = 0; i < buttons.length; i++) {
				if (parseInt(buttons[i].textContent) === currentPage) {
					buttons[i].classList.add('active');
				} else {
					buttons[i].classList.remove('active');
				}
			}
		}


		function initializeTable() {
			createPagination();
			showPage(currentPage);
		}


		window.onload = function() {
			initializeTable();
		};
	</script>

</body>
</html>
