<?php
header('Content-Type: application/json');
session_start(); // Start session to access $_SESSION

require_once 'security/chart_connection.php';

// Get month and year from query parameters
$month = isset($_GET['month']) ? (int)$_GET['month'] : 0;
$year = isset($_GET['year']) ? (int)$_GET['year'] : 0;

// Get user_type and sal_ex from session
$user_type = isset($_SESSION['User_Type']) ? (int)$_SESSION['User_Type'] : null;
$salEx = isset($_SESSION['CURRENT_REP']) ? $_SESSION['CURRENT_REP'] : null;

if ($user_type === null) {
    echo json_encode(["error" => "User Type not defined in session"]);
    exit;
}

$pieChartData = [];

if ($user_type === 1) {
    // Admin: Fetch total sales grouped by SAL_EX
    if ($month > 0 && $year > 0) {
        $pieChartQuery = "SELECT SAL_EX, SUM(TOTPAY) as total_payment 
                          FROM s_salma 
                          WHERE TOTPAY > 0 AND MONTH(SDATE) = ? AND YEAR(SDATE) = ?
                          GROUP BY SAL_EX";
        $stmt = $conn->prepare($pieChartQuery);
        $stmt->bind_param("ii", $month, $year);
    } else {
        $pieChartQuery = "SELECT SAL_EX, SUM(TOTPAY) as total_payment 
                          FROM s_salma 
                          WHERE TOTPAY > 0 AND MONTH(SDATE) = ? AND YEAR(SDATE) = ?
                          GROUP BY SAL_EX";
        $stmt = $conn->prepare($pieChartQuery);
    }
} else {
    // Sales rep: Filter by SAL_EX
    if (!$salEx) {
        echo json_encode(["error" => "Sales executive not defined in session"]);
        exit;
    }

    if ($month > 0 && $year > 0) {
        $pieChartQuery = "SELECT REF_NO, TOTPAY 
                          FROM s_salma 
                          WHERE TOTPAY > 0 AND MONTH(SDATE) = ? AND YEAR(SDATE) = ? AND SAL_EX = ?";
        $stmt = $conn->prepare($pieChartQuery);
        $stmt->bind_param("iis", $month, $year, $salEx);
    } else {
        $pieChartQuery = "SELECT REF_NO, TOTPAY 
                          FROM s_salma 
                          WHERE TOTPAY > 0 AND SAL_EX = ?";
        $stmt = $conn->prepare($pieChartQuery);
        $stmt->bind_param("s", $salEx);
    }
}

$stmt->execute();
$result = $stmt->get_result();

while ($row = $result->fetch_assoc()) {
    if ($user_type === 1) {
        $pieChartData[] = [
            "label" => $row['SAL_EX'],
            "value" => round($row['total_payment'])
        ];
    } else {
        $pieChartData[] = [
            "label" => $row['REF_NO'],
            "value" => round($row['TOTPAY'])
        ];
    }
}

$conn->close();

// Return JSON response
echo json_encode([
    "pieChartData" => $pieChartData,
    "userType" => $user_type
]);
?>
