<?php
require_once("connectioni.php");
include './auth.php';


session_start();
echo $_SESSION["CURRENT_USER"];
?>


<html lang="en">

<head>
  <meta charset="utf-8" />
  <title>Dashboard - Admin Panel</title>
  <meta name="viewport" content="width=device-width, initial-scale=1.0">


  <!-- DataTables -->
  <link href="assets/libs/datatables.net-bs4/css/dataTables.bootstrap4.min.css" rel="stylesheet" type="text/css" />
  <link href="assets/libs/datatables.net-buttons-bs4/css/buttons.bootstrap4.min.css" rel="stylesheet" type="text/css" />

  <!-- Responsive datatable examples -->
  <link href="assets/libs/datatables.net-responsive-bs4/css/responsive.bootstrap4.min.css" rel="stylesheet"
  type="text/css" />
  <link href="plugin/sweetalert/sweetalert.css" rel="stylesheet" type="text/css" />
  <!-- Bootstrap Css -->
  <link href="assets/css/bootstrap.min.css" id="bootstrap-style" rel="stylesheet" type="text/css" />
  <!-- Icons Css -->
  <link href="assets/css/icons.min.css" rel="stylesheet" type="text/css" />
  <!-- App Css-->
  <link href='https://ajax.googleapis.com/ajax/libs/jqueryui/1.12.1/themes/ui-lightness/jquery-ui.css' rel='stylesheet'>
  <link href="https://code.jquery.com/ui/1.12.1/themes/base/jquery-ui.css" rel="stylesheet">


  <link href="assets/css/app.min.css" id="app-style" rel="stylesheet" type="text/css" />


  <style>
    .logo-sm {
      margin-top: 25px;
    }

    .table-container {
      width: 100%;
      overflow-x: auto;
      /* Enables horizontal scrolling */
      border: 1px solid #ddd;
      /* Border around the table container */
      border-radius: 5px;
      padding: 10px;
    }

    /* Style adjustments for the table */
    .CSSTableGenerator table {
      width: 100%;
      border-collapse: collapse;
    }

    .CSSTableGenerator td,
    .CSSTableGenerator th {
      padding: 10px;
      text-align: left;
      white-space: nowrap;
      /* Prevents text wrapping */
      border: 1px solid #ccc;
      /* Border around table cells */
    }

    /* Sticky header for better usability */
    .CSSTableGenerator tr:first-child {
      background-color: #333;
      color: white;
      position: sticky;
      top: 0;
    }

    /* Responsive Design */
    @media screen and (max-width: 768px) {
      .CSSTableGenerator td {
        font-size: 14px;
      }
    }

    .table-container {
      width: 100%;
      overflow-x: auto;
      /* Enables horizontal scrolling */

    }

    .CSSTableGenerator table {
      width: 100%;
      border-collapse: collapse;
    }

    .CSSTableGenerator td,
    .CSSTableGenerator th {
      padding: 10px;
      text-align: left;
      border: 1px solid #ccc;
    }

    .CSSTableGenerator tr:first-child {
      background-color: #333;
      color: white;
      position: sticky;
      top: 0;
    }

    @media screen and (max-width: 768px) {
      .CSSTableGenerator td {
        font-size: 14px;
      }
    }


    .summary-report-container {
      display: flex;
      justify-content: space-between;
      align-items: center;
      margin-bottom: 20px;
    }
    .summary-report-container h4 {
      margin: 0;
    }
  </style>

</head>

<body class="someBlock sidebar-enable vertical-collpsed">
  <div id="layout-wrapper">
    <?php
    include './header.php';
    ?>

    <div class="main-content">
      <div class="container-fluid">
        <div class="card" style="margin-top:100px">
          <div class="card-body">
            <div class="row">


            </div>



            <div class="row">
              <!-- Table 1: Invoice Data -->
              <div class="col-md-12">



                <div class="row">
                  <div class="row align-items-center ">
                    <h5> Summary Report </h5>
                   <div class="col-md-2 mb-4">
                    <label class="form-label">Year</label>
                    <select id="year" class="form-control" name="year">
                      <option value="">Select Year</option>
                      <script>
                        for (let i = 2024; i <= 2030; i++) {
                          document.write(`<option value="${i}">${i}</option>`);
                        }
                      </script>
                    </select>
                  </div>

                  <div class="col-md-2 mb-4">
                    <label class="form-label">Month</label>
                    <select id="month" class="form-control" name="month">
                      <option value="">Select Month</option>
                      <option value="01">January</option>
                      <option value="02">February</option>
                      <option value="03">March</option>
                      <option value="04">April</option>
                      <option value="05">May</option>
                      <option value="06">June</option>
                      <option value="07">July</option>
                      <option value="08">August</option>
                      <option value="09">September</option>
                      <option value="10">October</option>
                      <option value="11">November</option>
                      <option value="12">December</option>
                    </select>
                  </div>




                </div>
              </div>

              <div class="table-container CSSTableGenerator">
                <table id="invoiceTable" class="table table-striped table-bordered table-responsive">
                  <thead>
                    <tr>
                      <th>Date</th>
                      <th> Name</th>
                      <th>Target Sales</th>
                      <th>Total Sales</th>
                      <th> Outstanding</th>
                      <th>Total Return</th>
                      <th>Check Return</th>
                      <th>Check Collected</th> 
                      <th> Collection</th>
                      <th> Remark </th>
                    </tr>
                  </thead>
                  <tbody>
                    


                </tbody>
              </table>
            </div>
          </div> 


        </div>
      </div>
    </div>
  </div>
</div>



<!-- Right bar overlay-->
<div class="rightbar-overlay"></div>

<!-- JAVASCRIPT -->
<script src="assets/libs/jquery/jquery.min.js"></script>

<script src="assets/libs/metismenu/metisMenu.min.js"></script>
<script src="assets/libs/simplebar/simplebar.min.js"></script>
<script src="assets/libs/node-waves/waves.min.js"></script>
<script src="assets/libs/waypoints/lib/jquery.waypoints.min.js"></script>
<script src="assets/libs/jquery.counterup/jquery.counterup.min.js"></script>

<!-- Required datatable js -->
<!-- Buttons examples -->
<script src="assets/libs/jszip/jszip.min.js"></script>
<script src="assets/libs/pdfmake/build/pdfmake.min.js"></script>
<script src="assets/libs/pdfmake/build/vfs_fonts.js"></script>

<script src="assets/js/app.js"></script>

<!-- Bootstrap JS -->
<script src="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/js/bootstrap.bundle.min.js"></script>
<!-- DataTables JS -->
<script src="https://cdn.datatables.net/1.13.3/js/jquery.dataTables.min.js"></script>
<script src="https://cdn.datatables.net/1.13.3/js/dataTables.bootstrap4.min.js"></script>
<!-- DataTables Responsive JS -->
<script src="https://cdn.datatables.net/responsive/2.3.0/js/dataTables.responsive.min.js"></script>
<script src="https://cdn.datatables.net/responsive/2.3.0/js/responsive.bootstrap4.min.js"></script>
<script src="https://ajax.googleapis.com/ajax/libs/jqueryui/1.12.1/jquery-ui.min.js"></script>


<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0-alpha1/dist/js/bootstrap.bundle.min.js"></script>
<script src="https://code.jquery.com/ui/1.12.1/jquery-ui.min.js"></script>

<script>
 


  $(document).ready(function () {
      // Initialize DataTable for Invoice Table
    $('#invoiceTable').DataTable({
      responsive: true,
      lengthChange: true,
      fixedHeader: true,
        order: [[0, 'desc']], // Default sorting by the first column
        lengthMenu: [[15, 25, 50, 100, -1], ['15 rows', '25 rows', '50 rows', '100 rows', 'Show all']]
      });

      // Initialize DataTable for Summary Table
    $('#summaryTable').DataTable({
      responsive: true,
      lengthChange: true,
      fixedHeader: true,
        order: [[0, 'desc']], // Default sorting by the first column
        lengthMenu: [[15, 25, 50, 100, -1], ['15 rows', '25 rows', '50 rows', '100 rows', 'Show all']]
      });
  });


function fetchData() {
    var year = $('#year').val();
    var month = $('#month').val();

    if (year !== "" && month !== "") {
        $.ajax({
            url: "summary-report-data.php",  // Backend PHP script
            type: "POST",
            data: {
                action: "get_data",
                year: year,
                month: month
            },
            success: function (response) {
                // Clear existing table rows before adding new ones
                $('#invoiceTable tbody').empty();

                // Insert the HTML rows returned from PHP into the table
                $('#invoiceTable tbody').html(response);
            },
            error: function (xhr, status, error) {
                console.error("Error fetching data:", error);
            }
        });
    }
}


    // Trigger fetch on change of Year or Month selection
    $('#year, #month').change(fetchData);


</script>


</html>