<?php
session_start();
require_once("connectioni.php");
require_once("connection_sql.php");

// Check if the session is valid
if (!isset($_SESSION["company"])) {
    die("<p class='text-danger'>Session Expired. Please log in again.</p>");
}

// Retrieve 'stname' from POST or GET
$stname = isset($_POST['stname']) ? $_POST['stname'] : (isset($_GET['stname']) ? $_GET['stname'] : '');

// Assign to session
$_SESSION["stname"] = $stname;

// SQL query to fetch orders from s_cusordmas based on the company session
$sql = "SELECT REF_NO, CUS_NAME, SDATE, GRAND_TOT, Result, SAL_EX, approveby, Forward, INVNO 
        FROM s_cusordmas 
        WHERE CANCELL='0' AND Result='" . $_SESSION["company"] . "' 
        ORDER BY id ASC";

// Prepare the SQL statement
$stmt = mysqli_prepare($GLOBALS['dbinv'], $sql);
if (!$stmt) {
    die("Failed to prepare statement: " . mysqli_error($GLOBALS['dbinv']));
}

// Execute the query
mysqli_stmt_execute($stmt);

// Fetch the result
$result = mysqli_stmt_get_result($stmt);
?>

<div class="container">
    <?php if ($result && mysqli_num_rows($result) > 0): ?>
        <div class="table-responsive">
            <table class="example table table-centered datatable dt-responsive nowrap table-card-list" style="width: 100%;">
                <thead>
                    <tr>
                        <th align="center">Ref No</th>
                        <th align="center">Customer Name</th>
                        <th align="center">Order Date</th>
                        <th align="center">Invoice Total</th>
                        <th align="center">Status</th>
                        <th align="center">Sales Executive</th>
                        <th align="center">Approved By</th>
                        <th align="center">Approved Level</th>
                        <th align="center">Invoice No</th>
                    </tr>
                </thead>
                <tbody>
                    <?php
                    // Loop through the result set and display each row
                    while ($row = mysqli_fetch_array($result)) {
                        // Fetch Sales Executive Details (if needed)
                        $sql1 = "SELECT * FROM s_salrep WHERE REPCODE = '" . $row["SAL_EX"] . "'";
                        $result1 = mysqli_query($GLOBALS['dbinv'], $sql1);
                        $row1 = mysqli_fetch_array($result1);

                        // Output the table row
                        echo "<tr>
                                <td align='center'>" . $row['REF_NO'] . "</td>
                                <td align='left'>" . $row['CUS_NAME'] . "</td>
                                <td align='center'>" . $row['SDATE'] . "</td>
                                <td align='right'>" . number_format($row['GRAND_TOT'], 2) . "</td>
                                <td align='center'>" . $row['Result'] . "</td>
                                <td align='center'>" . $row1['Name'] . "</td>
                                <td align='center'>" . $row['approveby'] . "</td>
                                <td align='center'>" . $row['Forward'] . "</td>
                                <td align='center'>" . $row['INVNO'] . "</td>
                            </tr>";
                    }
                    ?>
                </tbody>
            </table>
        </div>
    <?php else: ?>
        <p class="text-danger">No orders found.</p>
    <?php endif; ?>
</div>
