<?php 
session_start();

// Include the Database class
require_once('Database.php');

// Create an instance of the Database class
$database = new Database();

// Use the database connection
$conn = $database->DB_CON;

 $sql = "SELECT * FROM s_mas ORDER BY STK_NO";
 
$result = $database->readQuery($sql);
?>

<div class="container">
    <?php if ($result && mysqli_num_rows($result) > 0): ?>
        <div class="table-responsive">
            <table id="example" class="table">
                <thead>
                    <tr>
                        <th align="center">Item Code</th>
                        <th align="center">Description</th>
                        <th align="center">Brand</th>
                        <th align="center">Available Qty</th>
                        <th align="center">List Price</th>
                    </tr>
                </thead>
                <tbody>
                    <?php while ($row = mysqli_fetch_array($result)): ?>
                        <tr>
                            <td onclick="itno('<?php echo $row['STK_NO']; ?>', '<?php echo $mstname; ?>');"><?php echo $row['STK_NO']; ?></td>
                            <td onclick="itno('<?php echo $row['STK_NO']; ?>', '<?php echo $mstname; ?>');"><?php echo $row['DESCRIPT']; ?></td>
                            <td onclick="itno('<?php echo $row['STK_NO']; ?>', '<?php echo $mstname; ?>');"><?php echo $row['BRAND_NAME']; ?></td>
                            <td onclick="itno('<?php echo $row['STK_NO']; ?>', '<?php echo $mstname; ?>');"><?php echo $row['QTYINHAND']; ?></td>
                            <td onclick="itno('<?php echo $row['STK_NO']; ?>', '<?php echo $mstname; ?>');"><?php echo $row['SELLING']; ?></td>
                        </tr>
                    <?php endwhile; ?>
                </tbody>
                <tfoot>
                    <tr>
                        <th align="center">Item No</th>
                        <th align="center">Description</th>
                        <th align="center">Brand</th>
                        <th align="center">Stock</th>
                        <th align="center">List Price</th>
                    </tr>
                </tfoot>
            </table>
        </div>
    <?php else: ?>
        <p class="text-danger">No items found.</p>
    <?php endif; ?>
</div>

<!-- Include jQuery and DataTable scripts -->
<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script type="text/javascript" charset="utf8" src="https://cdn.datatables.net/1.10.25/js/jquery.dataTables.min.js"></script>
  
 
<script type="text/javascript">
    $(document).ready(function() {
        $('#example tfoot th').each(function() {
            var title = $(this).text();
            $(this).html('<input type="text" placeholder="Search ' + title + '" />');
        });

        var table = $('#example').DataTable({
            lengthChange: true,
            fixedHeader: true,
            responsive: true,
            "deferRender": true,
            "order": [[0, 'desc']],
            lengthMenu: [[10, 25, 50, 100, -1], ['10 rows', '25 rows', '50 rows', '100 rows', 'Show all']],
            initComplete: function () {
                this.api().columns().every(function() {
                    var that = this;

                    $('input', this.footer()).on('keyup change clear', function() {
                        if (that.search() !== this.value) {
                            that.search(this.value).draw();
                        }
                    });
                });
            }
        });

        $('#chk_stock').on('change', function() {
            if ($(this).is(':checked')) {
                $.fn.dataTable.ext.search.push(
                    function(settings, data, dataIndex) {
                        return data[3] > 0;
                    }
                );
            } else {
                $.fn.dataTable.ext.search.pop();
            }
            table.draw();
        });
    });
</script>
