<?php
require_once("connectioni.php");
include './auth.php';
?>


<html lang="en">

<head>
  <meta charset="utf-8" />
  <title>Dashboard - Admin Panel</title>
  <meta name="viewport" content="width=device-width, initial-scale=1.0">


  <!-- DataTables -->
  <link href="assets/libs/datatables.net-bs4/css/dataTables.bootstrap4.min.css" rel="stylesheet" type="text/css" />
  <link href="assets/libs/datatables.net-buttons-bs4/css/buttons.bootstrap4.min.css" rel="stylesheet" type="text/css" />

  <!-- Responsive datatable examples -->
  <link href="assets/libs/datatables.net-responsive-bs4/css/responsive.bootstrap4.min.css" rel="stylesheet"
    type="text/css" />
  <link href="plugin/sweetalert/sweetalert.css" rel="stylesheet" type="text/css" />
  <!-- Bootstrap Css -->
  <link href="assets/css/bootstrap.min.css" id="bootstrap-style" rel="stylesheet" type="text/css" />
  <!-- Icons Css -->
  <link href="assets/css/icons.min.css" rel="stylesheet" type="text/css" />
  <!-- App Css-->
  <link href='https://ajax.googleapis.com/ajax/libs/jqueryui/1.12.1/themes/ui-lightness/jquery-ui.css' rel='stylesheet'>

  <link href="assets/css/app.min.css" id="app-style" rel="stylesheet" type="text/css" />


  <style>
    .logo-sm {
      margin-top: 25px;
    }

    .table-container {
      width: 100%;
      overflow-x: auto;
      /* Enables horizontal scrolling */
      border: 1px solid #ddd;
      /* Border around the table container */
      border-radius: 5px;
      padding: 10px;
    }

    /* Style adjustments for the table */
    .CSSTableGenerator table {
      width: 100%;
      border-collapse: collapse;
    }

    .CSSTableGenerator td,
    .CSSTableGenerator th {
      padding: 10px;
      text-align: left;
      white-space: nowrap;
      /* Prevents text wrapping */
      border: 1px solid #ccc;
      /* Border around table cells */
    }

    /* Sticky header for better usability */
    .CSSTableGenerator tr:first-child {
      background-color: #333;
      color: white;
      position: sticky;
      top: 0;
    }

    /* Responsive Design */
    @media screen and (max-width: 768px) {
      .CSSTableGenerator td {
        font-size: 14px;
      }
    }

    .table-container {
      width: 100%;
      overflow-x: auto;
      /* Enables horizontal scrolling */

    }

    .CSSTableGenerator table {
      width: 100%;
      border-collapse: collapse;
    }

    .CSSTableGenerator td,
    .CSSTableGenerator th {
      padding: 10px;
      text-align: left;
      border: 1px solid #ccc;
    }

    .CSSTableGenerator tr:first-child {
      background-color: #333;
      color: white;
      position: sticky;
      top: 0;
    }

    @media screen and (max-width: 768px) {
      .CSSTableGenerator td {
        font-size: 14px;
      }
    }
  </style>
</head>

<body class="someBlock sidebar-enable vertical-collpsed">
  <div id="layout-wrapper">
    <?php
    include './header.php';
    ?>

    <div class="main-content">
      <div class="container-fluid">
        <div class="card" style="margin-top:100px">
          <div class="card-body">
            <div class="row">

             
            </div>

            <fieldset>


            <form onsubmit="save_inv(event)">



                <div class="row">
                  <div class="row align-items-center ">
                    <div class="col-md-2  mb-4 " hidden>
                      <label class="form-label">Date</label>
                      <input type="hidden" size="20" name="invdate" disabled id="invdate"
                        value="<?php echo date("Y-m-d"); ?>" onfocus="load_calader('invdate');" class="form-control" />
                      <input id="dte_dor" name="dte_dor" type="hidden" value="" class="text_purchase3" />
                    </div>
                  </div>
                </div>

                <div class="row">
                  <div class="col-md-6    ">
                    <label class="form-label">Customer</label>
                    <div class="row g-2">
                      <!-- Short Code Input -->
                      <div class="col-12 col-md-auto">
                        <input type="text" class="form-control" name="firstname_hidden" id="firstname_hidden"
                          onblur="custno_ind('')" onkeypress="keyset('department',event);" placeholder="Code" disabled>
                      </div>

                      <!-- Full Name Input -->
                      <div class="col-12 col-md flex-grow-1">
                        <input type="text" class="form-control" name="firstname" id="firstname" onblur="custno_ind('');"
                          onkeypress="keyset('department', event);" placeholder="Enter customer name" disabled>
                      </div>

                      <!-- Find Button -->
                      <div class="col-12 col-md-auto">
                        <button type="button" class="btn btn-primary w-100" data-bs-toggle="modal"
                          data-bs-target="#dataModalCustomer">
                          Find
                        </button>
                      </div>
                    </div>

                    <!-- Customer Search Modal -->
                    <div class="modal fade" id="dataModalCustomer" tabindex="-1"
                      aria-labelledby="dataModalCustomerLabel" aria-hidden="true">
                      <div class="modal-dialog modal-xl">
                        <div class="modal-content">
                          <div class="modal-header">
                            <h5 class="modal-title" id="dataModalCustomerLabel">
                              Search Customer</h5>
                            <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                          </div>
                          <div class="modal-body">
                            <?php include 'serach_customer.php' ?>
                          </div>
                        </div>
                      </div>
                    </div>


                  </div>
                  <div class="col-md-4 ">
                    <label>Shedule Date</label>
                    <input type="text" size="20" name="s_date" id="s_date" value="<?php echo date("Y-m-d"); ?>" class="form-control" />
                   

                  </div>
                
               <div class="col-12 col-md-2" style="margin-top: 25px">
   
    <button class="btn btn-success w-100 d-md-inline-block" type="submit">
      <i class="fas fa-plus"></i> Save
    </button> 
</div>



                </div>

                <div class="row">
                  <!-- Table 1: Invoice Data -->
                  <div class="col-md-12">
                    <h4>Invoice Details</h4>
                    <div class="table-container CSSTableGenerator">
                      <table id="invoiceTable" class="table table-striped table-bordered table-responsive">
                        <thead>
                          <tr>
                            <th>Ref No</th>
                            <th>Date</th>
                            <th>Value</th> 
                            <th>Balance</th>
                            <th>Collect</th>
                            <th>Remark</th>
                          </tr>
                        </thead>
                        <tbody> </tbody>
                      </table>
                    </div>
                  </div>


                  <!-- Table 2: Summary Data -->
                  <div class="col-md-12" style="margin-top:20px">
                    <h4>Summary Details</h4>
                    <div class="table-container CSSTableGenerator">
                      <table id="summaryTable" class="table table-striped table-bordered table-responsive">
                        <thead>
                          <tr>
                            <th>Ref No</th>
                            <th>s_date</th>
                            <th>Grand Total</th>  
                             <th>Balance</th>
                            <th>Collect</th>
                            <th>Remark</th>
                          </tr>
                        </thead>
                        <tbody>  </tbody>
                      </table>
                    </div>
                  </div>
                </div>
              </form>
          </div>
        </div>
      </div>
    </div>
  </div>



  <!-- Right bar overlay-->
  <div class="rightbar-overlay"></div>

  <!-- JAVASCRIPT -->
  <script src="assets/libs/jquery/jquery.min.js"></script>




  <script src="assets/libs/metismenu/metisMenu.min.js"></script>
  <script src="assets/libs/simplebar/simplebar.min.js"></script>
  <script src="assets/libs/node-waves/waves.min.js"></script>
  <script src="assets/libs/waypoints/lib/jquery.waypoints.min.js"></script>
  <script src="assets/libs/jquery.counterup/jquery.counterup.min.js"></script>

  <!-- Required datatable js -->
  <!-- Buttons examples -->
  <script src="assets/libs/jszip/jszip.min.js"></script>
  <script src="assets/libs/pdfmake/build/pdfmake.min.js"></script>
  <script src="assets/libs/pdfmake/build/vfs_fonts.js"></script>

  <script src="assets/js/app.js"></script>

  <!-- Bootstrap JS -->
  <script src="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/js/bootstrap.bundle.min.js"></script>
  <!-- DataTables JS -->
  <script src="https://cdn.datatables.net/1.13.3/js/jquery.dataTables.min.js"></script>
  <script src="https://cdn.datatables.net/1.13.3/js/dataTables.bootstrap4.min.js"></script>
  <!-- DataTables Responsive JS -->
  <script src="https://cdn.datatables.net/responsive/2.3.0/js/dataTables.responsive.min.js"></script>
  <script src="https://cdn.datatables.net/responsive/2.3.0/js/responsive.bootstrap4.min.js"></script>
  <script src="https://ajax.googleapis.com/ajax/libs/jqueryui/1.12.1/jquery-ui.min.js"></script>


  <script>
 
function save_inv(event) {
  // Prevent form submission
  event.preventDefault();

  var ref_no = [];
  var collect = [];
  var remark = [];

  // Collect data from the inputs
  $("input[name='ref_no[]']").each(function() {
    ref_no.push($(this).val());
  });

  $("input[name='collect[]']").each(function() {
    collect.push($(this).val());
  });

  $("input[name='remark[]']").each(function() {
    remark.push($(this).val());
  });

  // Collect other form data
  var data = {
    action: 'save',
    ref_no: ref_no,
    collect: collect,
    remark: remark,
    sdate1: $('#s_date').val(),
    c_code: $('#firstname_hidden').val(),
    cus_name: $('#firstname').val(), 
  };

  // AJAX request for the first part (save)
  $.ajax({
    type: 'POST',
    url: 'ref-remark-summary-save.php',
    data: data,
    success: function(response) {
      alert(response);  // Show success message
      
      // Now call the second AJAX request for 'summary_save'
      var ref_no_summary = [];
      var collect_summary = [];
      var remark_summary = [];

      // Collect data from the inputs for the summary
      $("input[name='ref_no_summary[]']").each(function() {
        ref_no_summary.push($(this).val());
      });

      $("input[name='collect_summary[]']").each(function() {
        collect_summary.push($(this).val());
      });

      $("input[name='remark_summary[]']").each(function() {
        remark_summary.push($(this).val());
      });

      // Collect other form data for summary
      var summary_data = {
        action: 'summary_save',
        ref_no: ref_no_summary,
        collect: collect_summary,
        remark: remark_summary,
        sdate1: $('#s_date').val(),
        c_code: $('#firstname_hidden').val(),
        cus_name: $('#firstname').val(),
      };

      // AJAX request for the second part (summary_save)
      $.ajax({
        type: 'POST',
        url: 'ref-remark-summary-save.php',
        data: summary_data,
        success: function(response) {
          window.location.reload()
        },
        error: function(xhr, status, error) {
          console.log("Error: " + error);
          alert("There was an error saving the data. Please try again.");
        }
      });
    },
    error: function(xhr, status, error) {
      console.log("Error: " + error);
      alert("There was an error saving the data. Please try again.");
    }
  });
}

 

    $(document).ready(function () {
      $(".date_picker").datepicker({
        dateFormat: "yy-mm-dd",
        defaultDate: new Date(),
      }).datepicker("setDate", new Date());
    });

    $(document).ready(function () {
      $('.example').DataTable({
        responsive: true,
        lengthChange: true,
        fixedHeader: true,
        deferRender: true,
        order: [[0, 'desc']],
        lengthMenu: [[15, 25, 50, 100, -1], ['15 rows', '25 rows', '50 rows', '100 rows', 'Show all']]
      });
    });

    $(document).ready(function () {
      // Initialize DataTable for Invoice Table
      $('#invoiceTable').DataTable({
        responsive: true,
        lengthChange: true,
        fixedHeader: true,
        order: [[0, 'desc']], // Default sorting by the first column
        lengthMenu: [[15, 25, 50, 100, -1], ['15 rows', '25 rows', '50 rows', '100 rows', 'Show all']]
      });

      // Initialize DataTable for Summary Table
      $('#summaryTable').DataTable({
        responsive: true,
        lengthChange: true,
        fixedHeader: true,
        order: [[0, 'desc']], // Default sorting by the first column
        lengthMenu: [[15, 25, 50, 100, -1], ['15 rows', '25 rows', '50 rows', '100 rows', 'Show all']]
      });
    });


  </script>

  <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0-alpha1/dist/js/bootstrap.bundle.min.js"></script>


  <script>
    //click customer data show
    function custno(cuscode, stname) {

      var row = event.target.closest('tr');
      var customerCode = row.cells[0].innerText;
      var customerName = row.cells[1].innerText;
      var customerAddress = row.cells[2].innerText;
      var customerPhone = row.cells[3].innerText;
      var subCustomerCode = row.cells[4].innerText;

      document.getElementById('firstname_hidden').value = customerCode;
      document.getElementById('firstname').value = customerName;


      custno_ind(customerCode);
      custno_ind_salmas(customerCode);

      setTimeout(function () {
        $('#dataModalCustomer').modal('hide');
      }, 500);
    }

    function custno_ind(customerCode) {
      var customer_id = customerCode;

      if (customer_id != '') {
        $.ajax({
          type: "POST",
          url: "ref-remark-summary-data.php",  // PHP file to process the data
          data: {
            action: 'cheq',  // Pass the action as 'cheq'
            firstname_hidden: customer_id
          },
          success: function (response) {
            $("#invoiceTable tbody").html(response);  // Update table body with response
          },
          error: function () {
            alert('Error fetching data.');
          }
        });
      } else {
        alert('Please enter a customer code.');
      }
    }

    function custno_ind_salmas(customerCode) {
      var customer_id = customerCode;

      if (customer_id != '') {
        $.ajax({
          type: "POST",
          url: "ref-remark-summary-data.php",  // PHP file to process the data
          data: {
            action: 'salmas',  // Pass the action as 'salmas'
            firstname_hidden: customer_id
          },
          success: function (response) {
            $("#summaryTable tbody").html(response);  // Update table body with response
          },
          error: function () {
            alert('Error fetching data.');
          }
        });
      } else {
        alert('Please enter a customer code.');
      }
    }



  </script>

</html>