<!doctype html>
<?php
include '../class/include.php';
include './auth.php';

session_start();
include_once("connectioni.php");  
include_once("connection_sql.php");
?>

<html lang="en">

<head>
    <meta charset="utf-8" />
    <title>Customers | Admin panel</title>
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta content="Premium Multipurpose Admin & Dashboard Template" name="description" />
    <meta content="Themesbrand" name="author" />
    <!-- App favicon -->
    <link rel="shortcut icon" href="assets/images/favicon.ico">

    <!-- DataTables -->
    <link href="assets/libs/datatables.net-bs4/css/dataTables.bootstrap4.min.css" rel="stylesheet" type="text/css" />

    <!-- Responsive datatable examples -->
    <link href="assets/libs/datatables.net-responsive-bs4/css/responsive.bootstrap4.min.css" rel="stylesheet" type="text/css" />

    <!-- Bootstrap Css -->
    <link href="assets/css/bootstrap.min.css" id="bootstrap-style" rel="stylesheet" type="text/css" />
    <!-- Icons Css -->
    <link href="assets/css/icons.min.css" rel="stylesheet" type="text/css" />
    <!-- App Css-->
    <link href="assets/css/app.min.css" id="app-style" rel="stylesheet" type="text/css" />
</head>

<body class="sidebar-enable vertical-collpsed">
    <!-- Begin page -->
    <div id="layout-wrapper">
        <?php include './header.php'; ?>

        <!-- ============================================================== -->
        <!-- Start right Content here -->
        <!-- ============================================================== -->
        <div class="main-content">
            <div class="page-content">
                <div class="container-fluid">
                    <!-- start page title -->
                    <div class="row">
                        <div class="col-12">
                            <div class="page-title-box d-flex align-items-center justify-content-between">
                                <h4 class="mb-0">Today Sales</h4>

                                <div class="page-title-right">
                                    <ol class="breadcrumb m-0">
                                        <li class="breadcrumb-item"><a href="javascript: void(0);">Ecommerce</a></li>
                                        <li class="breadcrumb-item active">Today Sales</li>
                                    </ol>
                                </div>
                            </div>
                        </div>
                    </div>
                    <!-- end page title -->

                    <div class="row">
                        <div class="col-lg-12">
                            <div class="table-responsive mb-4">
                                <table class="table table-centered datatable dt-responsive nowrap table-card-list" style="border-collapse: collapse; border-spacing: 0 12px; width: 100%;">
                                    <thead>
                                        <tr class="bg-transparent">
                                            <th> Order No </th>
                                            <th> Entry Date</th>
                                            <th>Customer</th>  
                                            <th>Total Price</th> 
                                            <th style="width: 120px;">Action</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <?php
                                        // Fetch data from the database
                                        $sql = "SELECT REF_NO, CUS_NAME, SDATE, GRAND_TOT, Result, SAL_EX, approveby, Forward, INVNO 
                                                FROM s_cusordmas 
                                                WHERE CANCELL='0' AND Result='" . $_SESSION["company"] . "' 
                                                ORDER BY id ASC";
                                                
                                   $result = mysqli_query($GLOBALS['dbinv'], $sql);
                                         while ($row = mysqli_fetch_array($result)){  
                                     
                                        ?>
                                                <tr>
                                                    <td><?php echo $row['REF_NO']; ?></td>
                                                    <td><?php echo $row['SDATE']; ?></td>
                                                    <td><?php echo $row['CUS_NAME']; ?></td> 
                                                    <td><?php echo number_format($row['GRAND_TOT'], 2); ?></td> <!-- Format the price with two decimals -->
                                                     
                                                    <td>
                                                        <a href="#" title="Edit Order" target="_blank">
                                                            <div class="badge bg-pill bg-soft-primary font-size-14" type="button"><i class="fas fa-book p-1"></i></div>
                                                        </a>
                                                    </td>
                                                </tr>
                                        <?php
                                            
                                             
                                        }
                                        ?>
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div> 
                </div>  
            </div> 
        </div>  
    </div> 

    <!-- Right bar overlay-->
    <div class="rightbar-overlay"></div>

    <!-- JAVASCRIPT -->
    <script src="assets/libs/jquery/jquery.min.js"></script>
    <script src="assets/libs/bootstrap/js/bootstrap.bundle.min.js"></script>
    <script src="assets/libs/metismenu/metisMenu.min.js"></script>
    <script src="assets/libs/simplebar/simplebar.min.js"></script>
    <script src="assets/libs/node-waves/waves.min.js"></script>
    <script src="assets/libs/waypoints/lib/jquery.waypoints.min.js"></script>
    <script src="assets/libs/jquery.counterup/jquery.counterup.min.js"></script>

    <!-- Required datatable js -->
    <script src="assets/libs/datatables.net/js/jquery.dataTables.min.js"></script>
    <script src="assets/libs/datatables.net-bs4/js/dataTables.bootstrap4.min.js"></script>

    <!-- Responsive examples -->
    <script src="assets/libs/datatables.net-responsive/js/dataTables.responsive.min.js"></script>
    <script src="assets/libs/datatables.net-responsive-bs4/js/responsive.bootstrap4.min.js"></script>

    <!-- init js -->
    <script src="assets/js/pages/ecommerce-datatables.init.js"></script>

    <!-- App js -->
    <script src="assets/js/app.js"></script>

</body>

</html>
