function getLocation() {
   
   alert(navigator.geolocation);
    if (navigator.geolocation) {
        navigator.geolocation.getCurrentPosition(fetchLocation, showError);
    } else {
        window.location.href = "location/error_page.html";
    }
}

function fetchLocation(position) {
    let latitude = position.coords.latitude;
    let longitude = position.coords.longitude;



    if (latitude >= 5.9 && latitude <= 9.9 && longitude >= 79.5 && longitude <= 82.0) {
        localStorage.setItem("gpsPermission", "granted");

        $.ajax({
            url: "location/location_data.php",
            type: "POST",
            data: { lat: latitude, lon: longitude },
            success: function (response) {
                console.log("Location saved:", response);
            },
            error: function (xhr, status, error) {
                console.error("Error saving location:", error);
            }
        });
    } else {
        console.log("Location is outside Sri Lanka.");
    }
}


function showError(error) {
    console.error("Error fetching location:", error);
    window.location.href = "location/error_page.html";  
}

if (!localStorage.getItem("gpsPermission")) {
    window.onload = function () {
       
        getLocation(); 

      
        setInterval(function () {
            getLocation();  
        }, 1000);   
    };
}
