<?php
ini_set('session.gc_maxlifetime', 30 * 60 * 60 * 60);
session_start(); 
include("security/connection_sql.php");
date_default_timezone_set('Asia/Colombo');

if ($_SESSION["CURRENT_USER"] == "") {
  echo "Please Logging Again..";
}
?>

<link rel="stylesheet" href="css/bootstrap/css/bootstrap.min.css">
<link rel="stylesheet" href="css/bootstrap_custom.css">
<script src="https://cdnjs.cloudflare.com/ajax/libs/apexcharts/3.35.3/apexcharts.min.js"></script>
<section class="content-header">
  <h4>
    Dashboard 
    <small> / Home Page</small>
  </h4>
  <style type="text/css">
    #nav-pills>li>a, .nav-pills>li>a:focus, .nav-pills>li>a:hover {
      background-color:#7eaad6; 
    }

    .card {

      margin: 10px auto;
      border: 1px solid #ddd;
      border-radius: 10px;
      box-shadow: 0 2px 5px rgba(0, 0, 0, 0.1);
      background-color: #f9f9f9;
    }

    .card-body {
      padding: 15px;
    }

    .card-title a {
      color: #333;
      font-size: 18px;
      text-decoration: none;
      font-family: 'Verdana', sans-serif;
    }

    .card-title a:hover {
      color: #007bff;
    }

    .card-icon {
      text-align: center;
      font-size: 40px;
      margin-top: 10px;
      color: #007bff;
    }

    .btn {
      display: block;
      width: 100%;
      margin-top: 10px;
      background-color: #007bff;
      color: white;
      border: none;
      padding: 8px 0;
      font-size: 14px;
      text-align: center;
      text-decoration: none;
      border-radius: 5px;
    }

    .btn:hover {
      background-color: #0056b3;
    }

    @media (max-width: 767px) {
      .card {
        width: 100%;
      }
    }
  </style>
</section>

<section class="content">
  <div class="row">
    <!-- Static Cards -->
    <div class="col-md-3 col-xl-3">
      <div class="card">
        <div class="card-body">
          <div style="display: flex; justify-content: space-between; align-items: center;">
            <div>
              <h4 class="mb-1 mt-1"><span data-plugin="counterup"> Rs: 34,152</span></h4>
              <p class="text-muted mb-0">Sales Order</p>
            </div>
            <div class="float-end mt-2">
              <i class="fas fa-chart-line" style="font-size: 30px; color: #5b73e8;"></i>
            </div>
          </div>
        </div>
      </div>
    </div>

    <div class="col-md-3 col-xl-3">
      <div class="card">
        <div class="card-body">
          <div style="display: flex; justify-content: space-between; align-items: center;">
            <div>
              <h4 class="mb-1 mt-1"><span data-plugin="counterup"> Rs: 24,230</span></h4>
              <p class="text-muted mb-0">Sales Order</p>
            </div>
            <div class="float-end mt-2">
              <i class="fas fa-chart-pie" style="font-size: 30px; color: #5b73e8;"></i>
            </div>
          </div>
        </div>
      </div>
    </div>

    <div class="col-md-3 col-xl-3">
      <div class="card">
        <div class="card-body">
          <div style="display: flex; justify-content: space-between; align-items: center;">
            <div>
              <h4 class="mb-1 mt-1"><span data-plugin="counterup"> Rs: 24,230</span></h4>
              <p class="text-muted mb-0">Sales Order</p>
            </div>
            <div class="float-end mt-2">
              <i class="fas fa-chart-pie" style="font-size: 30px; color: #5b73e8;"></i>
            </div>
          </div>
        </div>
      </div>
    </div>

    <div class="col-md-3 col-xl-3">
      <div class="card">
        <div class="card-body">
          <div style="display: flex; justify-content: space-between; align-items: center;">
            <div>
              <h4 class="mb-1 mt-1"><span data-plugin="counterup"> Rs: 12,750</span></h4>
              <p class="text-muted mb-0">Purchases</p>
            </div>
            <div class="float-end mt-2">
              <i class="fas fa-truck-loading" style="font-size: 30px; color: #5b73e8;"></i>
            </div>
          </div>
        </div>
      </div>
    </div>

    <!-- Static Quick Links Section -->
    <div class="col-md-12">
      <h4>Quick Links</h4>
    </div>

    <div class="col-xs-3">
      <div class="card">
        <div class="card-body">
          <h5 class="card-title">
            <a href="home.php?url=sales_ord" class="card-link">Sales Order</a>
          </h5>
          <a href="home.php?url=sales_ord" class="btn btn-primary">Go to Sales Order</a>
        </div>
      </div>
    </div>



    <div class="col-xs-3">
      <div class="card">
        <div class="card-body">
          <h5 class="card-title">
            <a href="home.php?url=collection_assign" class="card-link">Collection Assign </a>
          </h5>
          <a href="home.php?url=collection_assign" class="btn btn-primary">Go to Collection Assign  </a>
        </div>
      </div>
    </div>

    <div class="col-xs-3">
      <div class="card">
        <div class="card-body">
          <h5 class="card-title">
            <a href="home.php?url=collection_report" class="card-link">Collection Summary</a>
          </h5>
          <a href="home.php?url=collection_report" class="btn btn-primary">Go to  Collection Summary</a>
        </div>
      </div>
    </div>

    <div class="col-xs-3">
      <div class="card">
        <div class="card-body">
          <h5 class="card-title">
            <a href="home.php?url=ref_out_standing" class="card-link">OutStanding</a>
          </h5>
          <a href="home.php?url=ref_out_standingl" class="btn btn-primary">Go to OutStanding</a>
        </div>
      </div>
    </div>



    <div class="col-md-12">
     <h4> Summary Charts </h4>
   </div>
   <div class="col-md-6 col-xl-6">
    <div class="card">
      <div class="card-body">
        <div id="area-chart"></div>
      </div>
    </div>
  </div>
  <div class="col-md-6 col-xl-6">
    <div class="card">
      <div class="card-body">
        <div id="bar-chart"></div>
      </div>
    </div>
  </div>
  <div class="col-md-6 col-xl-6">
    <div class="card">
      <div class="card-body">
        <div id="donut-chart"></div>
      </div>
    </div>
  </div>
  <div class="col-md-6 col-xl-6">
    <div class="card">
      <div class="card-body">
        <div id="radial-bar-chart"></div>
      </div>
    </div>
  </div>
</div> 
</section>

<script>
  // ---------- CHARTS ----------

  // Static Data
  const cusName = ['Alice', 'Bob', 'Charlie', 'David', 'Emma'];
  const grandTot = [5000, 7000, 4000, 9000, 6500];
  const purchaseOrders = [30, 50, 40, 60, 45];
  const salesOrders = [20, 40, 35, 55, 50];
  const months = ['Jan', 'Feb', 'Mar', 'Apr', 'May'];
  const prodQuantity = [10, 20, 30, 40];
  const prodLabels = ['Product A', 'Product B', 'Product C', 'Product D'];
  const categorySeries = [25, 35, 40];
  const categoryLabels = ['Category A', 'Category B', 'Category C'];

  // Bar Chart
  const barChartOptions = {
    series: [{
      name: 'cusName & grandTot',
      data: grandTot,
    }],
    chart: { type: 'bar', height: 350, toolbar: { show: false } },
    colors: ['#246dec', '#cc3c43', '#367952', '#f5b74f', '#4f35a1'],
    plotOptions: { bar: { distributed: true, borderRadius: 4, columnWidth: '40%' } },
    dataLabels: { enabled: false },
    legend: { show: false },
    xaxis: { categories: cusName },
    yaxis: { title: { text: 'Grand Total' } },
  };
  new ApexCharts(document.querySelector('#bar-chart'), barChartOptions).render();

  // Area Chart
  new ApexCharts(document.querySelector('#area-chart'), {
    series: [
      { name: 'Purchase Orders', data: purchaseOrders },
      { name: 'Sales Orders', data: salesOrders },
    ],
    chart: { type: 'area', height: 350 },
    xaxis: { categories: months },
    colors: ['#4f35a1', '#246dec'],
  }).render();

  // Pie Chart
  new ApexCharts(document.querySelector('#pie-chart'), {
    series: prodQuantity,
    chart: { type: 'pie', height: 350 },
    labels: prodLabels,
    colors: ['#246dec', '#f5b74f', '#367952', '#cc3c43'],
  }).render();

  // Donut Chart
  new ApexCharts(document.querySelector('#donut-chart'), {
    series: categorySeries,
    chart: { type: 'donut', height: 350 },
    labels: categoryLabels,
    colors: ['#246dec', '#f5b74f', '#367952', '#cc3c43'],
  }).render();

  // Line Chart
  new ApexCharts(document.querySelector('#line-chart'), {
    series: [
      { name: 'Purchase Orders', data: purchaseOrders },
      { name: 'Sales Orders', data: salesOrders },
    ],
    chart: { type: 'line', height: 350 },
    xaxis: { categories: months },
    colors: ['#246dec','#4f35a1'],
  }).render();

  // Radial Bar Chart
  new ApexCharts(document.querySelector('#radial-bar-chart'), {
    series: categorySeries,
    chart: { type: 'radialBar', height: 350 },
    labels: categoryLabels,
    colors: ['#246dec', '#f5b74f', '#367952', '#cc3c43'],
    plotOptions: {
      radialBar: {
        dataLabels: {
          name: { show: true },
          value: { show: true },
          total: {
            show: true,
            label: 'Total',
            formatter: function (w) {
              return w.globals.seriesTotals.reduce((a, b) => a + b, 0);
            }
          }
        }
      }
    },
    legend: {
      show: true,
      position: 'right',
      labels: { colors: ['#000'] },
    }
  }).render();
</script>

</section>
