<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width,initial-scale=1.0">
  <title>Admin Dashboard</title>
  <link href="https://fonts.googleapis.com/css2?family=Montserrat:wght@100;200;300;400;500;600;700;800;900&display=swap" rel="stylesheet">
  <link href="https://fonts.googleapis.com/icon?family=Material+Icons+Outlined" rel="stylesheet">
  <script src="https://cdnjs.cloudflare.com/ajax/libs/apexcharts/3.35.3/apexcharts.min.js"></script>
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0-beta3/css/all.min.css">

  <style>
    body {
      margin: 0;
      padding: 0;
      background-color: red !important;
      font-family: "Montserrat", sans-serif;
    }

    .dash {
      margin-left: 2%;
      text-decoration: solid;
      background-color: red;
    }

    .cards {
      display: grid;
      grid-template-columns: repeat(auto-fit, minmax(250px, 1fr));
      gap: 20px;
      margin: 20px;
    }

    .card {
      background-color: #fff;
      padding: 20px;
      border-radius: 5px;
      box-shadow: 0 6px 7px -4px rgba(0, 0, 0, 0.2);
      text-align: center;
      margin: 20px;
    }

    .charts {
      display: grid;
      grid-template-columns: repeat(auto-fit, minmax(250px, 1fr));
      gap: 20px;
      margin: 20px;
    }

    .chart {
      padding: 20px;
      background-color: #fff;
      border-radius: 5px;
      box-shadow: 0 6px 7px -4px rgba(0, 0, 0, 0.2);
    }

    .bg-red{
      background-color: red !;
    }

    @media (max-width: 768px) {
      .cards, .charts {
        grid-template-columns: 1fr;
      }
    }
  </style>
</head>
<body>
  <!-- <h1 class="dash">Dashboard</h1> -->
  <div class="row">
    <div class="col-md-3 col-xl-3">
      <div class="card">
        <div class="card-body">
          <div style="display: flex; justify-content: space-between; align-items: center;">
            <div>
              <!-- Sales Order -->
              <h4 class="mb-1 mt-1"><span data-plugin="counterup">  Rs: 34, 152</span></h4>
              <p class="text-muted mb-0">  Sales Order</p>
              <!-- Uncomment this section if you want to display a percentage change -->
              <!-- <p class="text-muted mt-3 mb-0"><span class="text-danger me-1"><i class="mdi mdi-arrow-down-bold me-1"></i>6.24%</span> since last week</p> -->
            </div>
            <div class="float-end mt-2">
              <i class="fas fa-chart-line" style="font-size: 30px; color: #5b73e8;"></i>
            </div>
          </div>
        </div>
      </div>
    </div>

    <div class="col-md-3 col-xl-3">
      <div class="card">
        <div class="card-body">
          <div style="display: flex; justify-content: space-between; align-items: center;">
            <div>
              <!-- Sales Order -->
              <h4 class="mb-1 mt-1"><span data-plugin="counterup">  Rs: 24, 230</span></h4>
              <p class="text-muted mb-0"> Sales Order</p>
            </div>
            <div class="float-end mt-2">
              <i class="fas fa-chart-pie" style="font-size: 30px; color: #5b73e8;"></i>
            </div>
          </div>
        </div>
      </div>
    </div>

  <div class="col-md-3 col-xl-3">
      <div class="card">
        <div class="card-body">
          <div style="display: flex; justify-content: space-between; align-items: center;">
            <div>
              <!-- Sales Order -->
              <h4 class="mb-1 mt-1"><span data-plugin="counterup">  Rs: 24, 230</span></h4>
              <p class="text-muted mb-0"> Sales Order</p>
            </div>
            <div class="float-end mt-2">
              <i class="fas fa-chart-pie" style="font-size: 30px; color: #5b73e8;"></i>
            </div>
          </div>
        </div>
      </div>
    </div>

    

    <div class="col-md-3 col-xl-3">
      <div class="card">
        <div class="card-body">
          <div style="display: flex; justify-content: space-between; align-items: center;">
            <div>
              <!-- Sales Order -->
              <h4 class="mb-1 mt-1"><span data-plugin="counterup"> Rs: 12, 750</span></h4>
              <p class="text-muted mb-0">  Purchases</p>
            </div>
            <div class="float-end mt-2">
              <i class="fas fa-truck-loading" style="font-size: 30px; color: #5b73e8;"></i>
            </div>
          </div>
        </div>
      </div>
    </div>

</div>

   <div class="row">
    <div class="col-md-6 col-xl-6">
      <div class="card">
        <div class="card-body">
          <div id="area-chart"></div>
        </div>
      </div>
    </div>
    <div class="col-md-6 col-xl-6">
      <div class="card">
        <div class="card-body">
          <div id="bar-chart"></div>
        </div>
      </div>
    </div>
    <div class="col-md-6 col-xl-6">
      <div class="card">
        <div class="card-body">
          <div id="donut-chart"></div>
        </div>
      </div>
    </div>
    <div class="col-md-6 col-xl-6">
      <div class="card">
        <div class="card-body">
          <div id="radial-bar-chart"></div>
        </div>
      </div>
    </div>
  </div> 

</body>

<script>
  // ---------- CHARTS ----------

  // Static Data
  const cusName = ['Alice', 'Bob', 'Charlie', 'David', 'Emma'];
  const grandTot = [5000, 7000, 4000, 9000, 6500];
  const purchaseOrders = [30, 50, 40, 60, 45];
  const salesOrders = [20, 40, 35, 55, 50];
  const months = ['Jan', 'Feb', 'Mar', 'Apr', 'May'];
  const prodQuantity = [10, 20, 30, 40];
  const prodLabels = ['Product A', 'Product B', 'Product C', 'Product D'];
  const categorySeries = [25, 35, 40];
  const categoryLabels = ['Category A', 'Category B', 'Category C'];

  // Bar Chart
  const barChartOptions = {
    series: [{
      name: 'cusName & grandTot',
      data: grandTot,
    }],
    chart: { type: 'bar', height: 350, toolbar: { show: false } },
    colors: ['#246dec', '#cc3c43', '#367952', '#f5b74f', '#4f35a1'],
    plotOptions: { bar: { distributed: true, borderRadius: 4, columnWidth: '40%' } },
    dataLabels: { enabled: false },
    legend: { show: false },
    xaxis: { categories: cusName },
    yaxis: { title: { text: 'Grand Total' } },
  };
  new ApexCharts(document.querySelector('#bar-chart'), barChartOptions).render();

  // Area Chart
  new ApexCharts(document.querySelector('#area-chart'), {
    series: [
      { name: 'Purchase Orders', data: purchaseOrders },
      { name: 'Sales Orders', data: salesOrders },
    ],
    chart: { type: 'area', height: 350 },
    xaxis: { categories: months },
    colors: ['#4f35a1', '#246dec'],
  }).render();

  // Pie Chart
  new ApexCharts(document.querySelector('#pie-chart'), {
    series: prodQuantity,
    chart: { type: 'pie', height: 350 },
    labels: prodLabels,
    colors: ['#246dec', '#f5b74f', '#367952', '#cc3c43'],
  }).render();

  // Donut Chart
  new ApexCharts(document.querySelector('#donut-chart'), {
    series: categorySeries,
    chart: { type: 'donut', height: 350 },
    labels: categoryLabels,
    colors: ['#246dec', '#f5b74f', '#367952', '#cc3c43'],
  }).render();

  // Line Chart
  new ApexCharts(document.querySelector('#line-chart'), {
    series: [
      { name: 'Purchase Orders', data: purchaseOrders },
      { name: 'Sales Orders', data: salesOrders },
    ],
    chart: { type: 'line', height: 350 },
    xaxis: { categories: months },
    colors: ['#246dec','#4f35a1'],
  }).render();

  // Radial Bar Chart
  new ApexCharts(document.querySelector('#radial-bar-chart'), {
    series: categorySeries,
    chart: { type: 'radialBar', height: 350 },
    labels: categoryLabels,
    colors: ['#246dec', '#f5b74f', '#367952', '#cc3c43'],
  }).render();
</script>
</html>
