<?php
require_once("security/connection_sql.php");

$year = $_POST['year'];
$month = $_POST['month'];

$sdate1_start = "$year-$month-01";   
$sdate1_end = date("Y-m-t", strtotime($sdate1_start));  


$query = "SELECT sdate1, c_code, cus_name, ref_no, ref_no1, flag, balance, collect, remark, traget, archived, id 
FROM vendor_visit 
WHERE sdate1 BETWEEN :sdate1_start AND :sdate1_end";

$stmt = $conn->prepare($query);


$stmt->bindParam(':sdate1_start', $sdate1_start);
$stmt->bindParam(':sdate1_end', $sdate1_end);


$stmt->execute();


$result = $stmt->fetchAll(PDO::FETCH_ASSOC);


if (count($result) > 0) {
    $tableRows = '';
    foreach ($result as $row_inv) {

        //query 2 total sales
        $query2 = "SELECT sum(AMOUNT) 
        FROM s_salma 
        WHERE C_CODE = :c_code AND SDATE BETWEEN :sdate1_start AND :sdate1_end";
        
        
        $amountStmt = $conn->prepare($query2);
        $amountStmt->bindParam(':c_code', $row_inv['c_code']);
        $amountStmt->bindParam(':sdate1_start', $sdate1_start);
        $amountStmt->bindParam(':sdate1_end', $sdate1_end);
        
        
        $amountStmt->execute();
        
        
        $amountResult = $amountStmt->fetch(PDO::FETCH_ASSOC);
        $amount = $amountResult ? $amountResult['sum(AMOUNT)'] : 0;

       //query 3 total outstanding 
        $query3 = "SELECT sum(GRAND_TOT) as grand_tot 
        FROM s_salma 
        WHERE C_CODE = :c_code AND SDATE BETWEEN :sdate1_start AND :sdate1_end";
        
        
        $grand_tot_amountStmt = $conn->prepare($query3);
        $grand_tot_amountStmt->bindParam(':c_code', $row_inv['c_code']);
        $grand_tot_amountStmt->bindParam(':sdate1_start', $sdate1_start);
        $grand_tot_amountStmt->bindParam(':sdate1_end', $sdate1_end);
        
        
        $grand_tot_amountStmt->execute();
        
        
        $grand_tot_Result = $grand_tot_amountStmt->fetch(PDO::FETCH_ASSOC);
        $grand_tot_amount = $grand_tot_Result ? $grand_tot_Result['sum(GRAND_TOT)'] : 0;

        ////////////////
        $query3_1 = "SELECT sum(TOTPAY) as tot_pay 
        FROM s_salma 
        WHERE C_CODE = :c_code AND SDATE BETWEEN :sdate1_start AND :sdate1_end";
        
        
        $tot_pay_amountStmt = $conn->prepare($query3_1);
        $tot_pay_amountStmt->bindParam(':c_code', $row_inv['c_code']);
        $tot_pay_amountStmt->bindParam(':sdate1_start', $sdate1_start);
        $tot_pay_amountStmt->bindParam(':sdate1_end', $sdate1_end);
        
        
        $tot_pay_amountStmt->execute();
        
        
        $tot_pay_aamountResult = $tot_pay_amountStmt->fetch(PDO::FETCH_ASSOC);
        $tot_pay_amount = $tot_pay_aamountResult ? $tot_pay_aamountResult['sum(TOTPAY)'] : 0;

        

        $total_out_standing =  $grand_tot_amount - $tot_pay_amount;

        //query 4 out standing collection
        $query4 = "SELECT sum(collect) 
        FROM vendor_visit 
        WHERE c_code = :c_code AND sdate1 BETWEEN :sdate1_start AND :sdate1_end";
        
        
        $collectionamountStmt = $conn->prepare($query4);
        $collectionamountStmt->bindParam(':c_code', $row_inv['c_code']);
        $collectionamountStmt->bindParam(':sdate1_start', $sdate1_start);
        $collectionamountStmt->bindParam(':sdate1_end', $sdate1_end);
        
        
        $collectionamountStmt->execute();
        
        
        $collectionamountResult = $collectionamountStmt->fetch(PDO::FETCH_ASSOC);
        $collectionamount = $collectionamountResult ? $collectionamountResult['sum(collect)'] : 0;

        //query 5 total return cheque sql
        $query4 = "SELECT sum(CR_CHEVAl) 
        FROM s_cheq
        WHERE CR_C_CODE = :c_code AND CR_CHDATE BETWEEN :sdate1_start AND :sdate1_end";
        

        
        $return_cheque_amountStmt = $conn->prepare($query4);
        $return_cheque_amountStmt->bindParam(':c_code', $row_inv['c_code']);
        $return_cheque_amountStmt->bindParam(':sdate1_start', $sdate1_start);
        $return_cheque_amountStmt->bindParam(':sdate1_end', $sdate1_end);
        
        
        $return_cheque_amountStmt->execute();
        
        
        $return_cheque_amountResult = $return_cheque_amountStmt->fetch(PDO::FETCH_ASSOC);
        $return_cheque_amount = $return_cheque_amountResult ? $return_cheque_amountResult['sum(CR_CHEVAl)'] : 0;




        $tableRows .= "<tr>";
        $tableRows .= "<td>" . $row_inv['sdate1'] . "</td>";  
        $tableRows .= "<td>" . $row_inv['cus_name'] . "</td>";  
        $tableRows .= "<td>" . ($row_inv['traget'] ? $row_inv['traget'] : '-') . "</td>"; 
        $tableRows .= "<td>" . (isset($amount) && $amount !== null && $amount !== 0 ? number_format($amount, 2, '.', ',') : '-') . "</td>";
        
        $tableRows .= "<td>" . (isset($total_out_standing) && $total_out_standing !== null && $total_out_standing !== 0 ? number_format($total_out_standing, 2, '.', ',') : '-') . "</td>";
        
        $tableRows .= "<td>" . (isset($collectionamount) && $collectionamount !== null && $collectionamount !== 0 ? number_format($collectionamount, 2, '.', ',') : '-') . "</td>";
        
        $tableRows .= "<td>" . (isset($return_cheque_amount) && $return_cheque_amount !== null && $return_cheque_amount !== 0 ? number_format($return_cheque_amount, 2, '.', ',') : '-') . "</td>";

        $tableRows .= "<td>" . ($row_inv['id'] ? $row_inv['id'] : '-') . "</td>";   

        $tableRows .= "<td>" . (isset($row_inv['collect']) && $row_inv['collect'] !== null && $row_inv['collect'] !== 0 ? number_format($row_inv['collect'], 2, '.', ',') : '-') . "</td>";  

        $tableRows .= "<td>" . ($row_inv['remark'] ? $row_inv['remark'] : '-') . "</td>";
        
        $tableRows .= "<td>
        <a href='home.php?url=collection_chart&c_code=" . $row_inv['c_code'] . "'>
        <div class='input-icon-wrapper'>
        <i class='fas fa-chart-line'></i> View Chart
        </div>
        </a>
        </td>";




        
        $tableRows .= "</tr>";
    }
    echo $tableRows;
} else {
    echo "<tr><td colspan='9'>No data available</td></tr>";
}
?>
