<?php
$currentYear = date("Y"); 
$id = '';
$id = $_GET['c_code']
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>Sales Chart</title>
    <script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
</head>
<body>



 <!--    <select id="yearSelect">
        <?php
        $startYear = 2020;
        $endYear = $currentYear + 5;  
        for ($year = $startYear; $year <= $endYear; $year++) {
            echo "<option value='$year'" . ($year == $currentYear ? " selected" : "") . ">$year</option>";
        }
        ?>
    </select> -->
    <section class="content" style="margin-bottom:100px;">
      <div class="box box-primary">
        <div class="box-header with-border" style="margin-top:20px">
            <h3 class="box-title">Collection Summary Chart - " <?php echo $currentYear ?> " Years - <?php echo $id ?></h3>
            <b style="margin-top: -10px;">
                <p style="float: right; color: black" id="time"></p>
            </b> 
            <canvas id="salesChart" width="400" height="200" style="margin-top:40px"></canvas>
        </div>
    </div>
</section>

<script>
    function fetchChartData(year) {
        $.ajax({
            url: 'collection_chart_data.php',
            type: 'POST',
            data: {
                year: year,
                c_code:c_code  
            },
            success: function(response) {
                try {
                    var data = JSON.parse(response);
                    var months = data.labels;  
                    var sales = data.values;   

                    var ctx = document.getElementById('salesChart').getContext('2d');
                    var chart = new Chart(ctx, {
                        type: 'bar',
                        data: {
                            labels: months,
                            datasets: [{
                                label: 'Collection Amount',
                                data: sales,
                                backgroundColor: 'rgba(75, 192, 192, 0.2)',  
                                borderColor: 'rgba(75, 192, 192, 1)',  
                                borderWidth: 1,
                                barThickness: 10, 
                            }]
                        },
                        options: {
                            responsive: true,
                            plugins: {
                                legend: {
                                    position: 'top',
                                },
                                tooltip: {
                                    mode: 'index',
                                    intersect: false,
                                },
                            },
                            scales: {
                                x: {
                                    beginAtZero: true
                                },
                                y: {
                                    beginAtZero: true  
                                }
                            }
                        }
                    });
                } catch (e) {
                    console.error('Error parsing JSON:', e);
                }
            },
            error: function(xhr, status, error) {
                console.error("Error fetching data:", error);
            }
        });
    }

    var currentYear = '<?php echo $currentYear; ?>';
    var c_code = '<?php echo $id; ?>';
    fetchChartData(currentYear,c_code);

    $('#yearSelect').change(function() {
        var selectedYear = $(this).val();
        fetchChartData(selectedYear);
    });
</script>

</body>
</html>
