<?php
require_once ("security/connection_sql.php");

if ($_POST['action'] === 'save') {
    // Collect the input data from POST request
    $ref_no = $_POST['ref_no'];
    $collect = $_POST['collect'];
    $remark = $_POST['remark'];

    $sdate1 = $_POST['sdate1'];
    $c_code = $_POST['c_code'];
    $cus_name = $_POST['cus_name'];
    $sal_ex = $_POST['sal_ex'];

    // Prepare the query once to reuse it in the loop
    $query = "INSERT INTO vendor_visit (sdate1, ref_no1, c_code, cus_name, ref_no, collect, remark, flag) 
              VALUES (:sdate1, :sal_ex, :c_code, :cus_name, :ref_no, :collect, :remark, :flag)";

    $stmt = $conn->prepare($query); // Prepare the statement

    foreach ($ref_no as $index => $ref_no_val) {
        // Get the collect and remark values for this reference number
        $collect_val = isset($collect[$index]) ? $collect[$index] : '';  
        $remark_val = isset($remark[$index]) ? $remark[$index] : '';

        if (!empty($collect_val) || !empty($remark_val)) {
            // Bind parameters for each iteration
            $stmt->bindParam(':sdate1', $sdate1);
            $stmt->bindParam(':sal_ex', $sal_ex);
            $stmt->bindParam(':c_code', $c_code);
            $stmt->bindParam(':cus_name', $cus_name);
            $stmt->bindParam(':ref_no', $ref_no_val);
            $stmt->bindParam(':collect', $collect_val);
            $stmt->bindParam(':remark', $remark_val);
            $stmt->bindParam(':flag', $flag = 'checq'); // or 'inv' depending on the condition

            // Execute the query
            if (!$stmt->execute()) {
                // If the query fails, output the error and stop execution
                echo "Error saving data: " . implode(", ", $stmt->errorInfo());
                exit;
            }
        }
    }

    echo "Data saved successfully!";
    // Close the connection (PDO automatically closes when the script ends)
}

if ($_POST['action'] === 'summary_save') {
    // Collect the input data from POST request
    $ref_no = $_POST['ref_no'];
    $collect = $_POST['collect'];
    $remark = $_POST['remark'];

    $sdate1 = $_POST['sdate1'];
    $c_code = $_POST['c_code'];
    $cus_name = $_POST['cus_name'];
    $sal_ex = $_POST['sal_ex'];

    // Prepare the query once to reuse it in the loop
    $query = "INSERT INTO vendor_visit (sdate1, ref_no1, c_code, cus_name, ref_no, collect, remark, flag) 
              VALUES (:sdate1, :sal_ex, :c_code, :cus_name, :ref_no, :collect, :remark, :flag)";

    $stmt = $conn->prepare($query); // Prepare the statement

    foreach ($ref_no as $index => $ref_no_val) {
        // Get the collect and remark values for this reference number
        $collect_val = isset($collect[$index]) ? $collect[$index] : '';  
        $remark_val = isset($remark[$index]) ? $remark[$index] : '';

        if (!empty($collect_val) || !empty($remark_val)) {
            // Bind parameters for each iteration
            $stmt->bindParam(':sdate1', $sdate1);
            $stmt->bindParam(':sal_ex', $sal_ex);
            $stmt->bindParam(':c_code', $c_code);
            $stmt->bindParam(':cus_name', $cus_name);
            $stmt->bindParam(':ref_no', $ref_no_val);
            $stmt->bindParam(':collect', $collect_val);
            $stmt->bindParam(':remark', $remark_val);
            $stmt->bindParam(':flag', $flag = 'inv'); // or 'checq' depending on the condition

            // Execute the query
            if (!$stmt->execute()) {
                // If the query fails, output the error and stop execution
                echo "Error saving data: " . implode(", ", $stmt->errorInfo());
                exit;
            }
        }
    }

    echo "Data saved successfully!";
    // Close the connection (PDO automatically closes when the script ends)
}
?>
