<?php
session_start();
date_default_timezone_set('Asia/Colombo');
?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
    <meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
    <title>Print Invoice</title>
    <style type="text/css">
        body {
            font-family: Calibri, sans-serif;
        }

        .style1 {
            font-size: 14px;
            font-weight: bold;
        }

        .style2 {
            font-size: 16px;
        }

        .style3 {
            font-size: 15px;
            font-weight: bold;
        }

        .style4 {
            font-size: 12px;
        }

        .page-break {
            page-break-after: always;
            height: 0;
        }

        /* Preloader styles */
        #preloader {
            position: fixed;
            top: 0;
            left: 0;
            width: 100vw;
            height: 100vh;
            background: white;
            z-index: 9999;
            display: flex;
            align-items: center;
            justify-content: center;
            flex-direction: column;
        }

        .spinner {
            width: 40px;
            height: 40px;
            border: 5px solid #ccc;
            border-top-color: #007bff;
            border-radius: 50%;
            animation: spin 1s linear infinite;
        }

        @keyframes spin {
            to {
                transform: rotate(360deg);
            }
        }
    </style>
</head>

<body>
<div id="preloader">
    <div style="font-size: 20px; margin-bottom: 10px;">Loading Invoices...</div>
    <div class="spinner"></div>
</div>

<center>
<?php
require_once("connectioni.php");
$invnos = isset($_GET["invnos"]) ? explode(",", $_GET["invnos"]) : [];

foreach ($invnos as $index => $invno) {
    $invno = trim($invno);

    // Render individual invoice
    include("rep_inv_single_render.php");

    // Page break between invoices
    if ($index < count($invnos) - 1) {
        echo '<div class="page-break"></div>';
    }
}
?>
</center>
 

<script type="text/javascript">
    window.onload = function () {
        // Hide preloader after full content is loaded
        document.getElementById("preloader").style.display = "none";

        // Trigger print
        window.print();

        // Show loader again after printing before closing
        window.onafterprint = function () {
            document.getElementById("preloader").style.display = "flex";
            setTimeout(function () {
                window.close();
            }, 2000); // Show loader for 2 seconds before closing
        };

        // Fallback in case onafterprint doesn't work
        setTimeout(function () {
            window.close();
        }, 5000); // Close after 5 seconds max
    };
</script>

</body>
</html>
