<?php
require_once("db_connect.php");

// Fetch active users
$sql = "SELECT user_name FROM user_mast ORDER BY user_name ASC";
$result = $conn->query($sql);
?>

<link rel="stylesheet" href="https://unpkg.com/leaflet/dist/leaflet.css" />
<script src="https://unpkg.com/leaflet/dist/leaflet.js"></script>

<section class="content">
    <div class="box box-primary">
        <div class="box-header with-border">
            <h3 class="box-title">Location Map Report</h3>
        </div>

        <form role="form" class="form-horizontal" onsubmit="return false;">
            <div class="box-body">
                <div class="form-group">
                    <div class="col-sm-12 text-left" style="margin-bottom: 15px;">
                        <button type="button" onclick="location.reload()" class="btn btn-default">
                            <i class="fa fa-refresh"></i> New
                        </button>
                        <button type="button" class="btn btn-primary" onclick="loadMap()">
                            Show Map
                        </button>
                    </div>
                </div>

                <div class="form-group">
                    <label class="col-sm-1 control-label">User</label>
                    <div class="col-sm-2">
                        <select class="form-control input-sm" id="Txtcusco">
                            <option value="">-- Select User --</option>
                            <?php while ($row = $result->fetch_assoc()) { ?>
                                <option value="<?php echo htmlspecialchars($row['user_name']); ?>">
                                    <?php echo htmlspecialchars($row['user_name']); ?>
                                </option>
                            <?php } ?>
                        </select>
                    </div>

                    <label class="col-sm-1 control-label">Date From</label>
                    <div class="col-sm-2">
                        <input type="date" id="dtfrom" class="form-control input-sm" value="<?php echo date('Y-m-d'); ?>">
                    </div>

                    <label class="col-sm-1 control-label">Date To</label>
                    <div class="col-sm-2">
                        <input type="date" id="dtto" class="form-control input-sm" value="<?php echo date('Y-m-d'); ?>">
                    </div>
                </div>
            </div>
        </form>
    </div>

    <div id="map" style="height: 500px; margin-top:20px; display:none;"></div>
</section>

<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script>
function loadMap() {
    let user = $("#Txtcusco").val().trim();
    let from = $("#dtfrom").val();
    let to   = $("#dtto").val();

    if (!user) {
        alert("Please select a User.");
        return;
    }

    $.ajax({
        url: "get_locations.php",
        type: "GET",
        data: { user_name: user, from: from, to: to },
        dataType: "json",
        success: function(response) {
            if (response.status !== "success" || response.count === 0) {
                alert("No location data found.");
                return;
            }

            let data = response.data;
            $("#map").show();

            let map = L.map('map').setView([data[0].latitude, data[0].longitude], 13);

            L.tileLayer('https://{s}.tile.openstreetmap.org/{z}/{x}/{y}.png', {
                attribution: '&copy; OpenStreetMap contributors'
            }).addTo(map);

            let latlngs = [];

            data.forEach((point, index) => {
                let lat = parseFloat(point.latitude);
                let lng = parseFloat(point.longitude);
                latlngs.push([lat, lng]);

                // Circle marker instead of pin
                L.circleMarker([lat, lng], {
                    radius: 8,
                    color: "blue",
                    fillColor: "lightblue",
                    fillOpacity: 0.8
                }).addTo(map);

                // Number + datetime label
                L.marker([lat, lng], {
    icon: L.divIcon({
        className: "custom-number",
        html: `
            <div style="
                background: ${index === 0 ? '#28a745' : (index === data.length-1 ? '#dc3545' : '#007bff')};
                color: white;
                width: 28px;
                height: 28px;
                line-height: 28px;
                border-radius: 50%;
                font-size: 14px;
                font-weight: bold;
                text-align: center;
                box-shadow: 0 0 3px rgba(0,0,0,0.6);
            ">
                ${index+1}
            </div>
        `
    })
}).addTo(map);
 
            });

            // Draw polyline
            L.polyline(latlngs, { color: 'red' }).addTo(map);
            map.fitBounds(latlngs);
        },
        error: function() {
            alert("Error loading map data.");
        }
    });
}
</script>
