<!-- Main content -->
<link rel="stylesheet" href="css/bootstrap.min.css">
<link rel="stylesheet" href="https://cdn.datatables.net/1.13.7/css/jquery.dataTables.min.css">
<script src="https://code.jquery.com/jquery-3.7.0.js"></script>
<script src="https://cdn.datatables.net/1.13.7/js/jquery.dataTables.min.js"></script>

<?php
require_once("./connection_sql.php");
?>

<style>
    .view-cell {
        background-color: red;
        color: white;
    }
    .table-hover tbody tr:hover td {
        background: aqua;
    }
    .printer table {
        counter-reset: rowNumber;
    }
    .printer tr {
        counter-increment: rowNumber;
    }
    .printer tr td:first-child::before {
        content: counter(rowNumber);
        min-width: 1em;
        margin-right: 0.5em;
    }
</style>
<section class="content">
    <div class="box box-primary">
        <div class="box-header with-border">
            <h3 class="box-title">LIVE STOCK</h3>
            <h4 style="float: right;height: 3px;"><b id="time"></b></h4>
        </div>
        <form role="form" class="form-horizontal">
            <div class="box-body">
                <div class="panel-body" style="overflow-x: auto">
                    <table width="100%" class="table table-striped table-bordered table-hover" id="example" style="width:auto">
                        <thead>
                            <tr>
                                <th>#</th> 
                                <th>Item Code</th>
                                <th>Description</th>
                                <th>Pattern</th>
                                <th>Brand</th>
                                <th>Cat</th>  
                                <th>Selling</th> 
                                <th>Qty In Hand</th> 
                                <th>Your In Hand</th> 
                            </tr>
                        </thead>
                        <tfoot>
                            <tr>
                                <th>#</th> 
                                <th>Item Code</th>
                                <th>Description</th>
                                <th>Pattern</th>
                                <th>Brand</th>
                                <th>Cat</th>  
                                <th>Selling</th> 
                                <th>Qty In Hand</th>  
                                <th>Your In Hand</th> 
                            </tr>
                        </tfoot>
                    </table>
                </div>
            </div>
        </form>
    </div>
</section>

<script>
    $(document).ready(function() {
        $('#example').DataTable({
            ajax: {
                url: 'live_stock_data.php',
                type: 'POST'
            },
            columns: [
                { data: 'id' }, 
                { data: 'STK_NO' },
                { data: 'DESCRIPT' },
                { data: 'PART_NO' },
                { data: 'BRAND_NAME' },
                { data: 'Cat1' },  
                { data: 'SELLING' } ,
                { data: 'QTYINHAND' } , 
                { data: 'QTYINHAND1' } 
            ],
            order: [[7, 'desc']],
            processing: true,
            serverSide: true
        });

        
    });
</script>
