<?php
// Database credentials
$host     = "localhost";   // or 127.0.0.1
$username = "root";        // your MySQL username
$password = "";            // your MySQL password
$database = "SWijesooriya_tht"; // your database name

// Create connection
$conn = new mysqli($host, $username, $password, $database);

// Check connection
if ($conn->connect_error) {
    die("Database connection failed: " . $conn->connect_error);
}

// Optional: set charset
$conn->set_charset("utf8");


  

header('Content-Type: application/json; charset=utf-8');

$user = isset($_GET['user_name']) ? trim($_GET['user_name']) : '';
$from = isset($_GET['from']) ? trim($_GET['from']) : '';
$to   = isset($_GET['to']) ? trim($_GET['to']) : '';

$data = [];

if ($user && $from && $to) {
    $stmt = $conn->prepare("SELECT latitude, longitude, created_at, ip 
                            FROM s_locations 
                            WHERE user_name = ? 
                              AND DATE(created_at) BETWEEN ? AND ? 
                            ORDER BY created_at ASC");
    $stmt->bind_param("sss", $user, $from, $to);
    $stmt->execute();
    $result = $stmt->get_result();

    while ($row = $result->fetch_assoc()) {
        $data[] = $row;
    }

    echo json_encode([
        'status' => 'success',
        'count'  => count($data),
        'data'   => $data
    ]);

    $stmt->close();
} else {
    echo json_encode([
        'status'  => 'error',
        'message' => 'Missing parameters (user_name, from, to)'
    ]);
}

$conn->close();
?>