<?php
ini_set('session.gc_maxlifetime', 30 * 60 * 60 * 60);
session_start();

if ($_SESSION["dev"] == "") {
    echo "Please Log in Again";
    exit();
}
?>

<head>
    <meta charset="UTF-8">
    <link rel="stylesheet" href="https://code.jquery.com/ui/1.13.2/themes/base/jquery-ui.css">
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script> <!-- jQuery first -->
    <script src="https://code.jquery.com/ui/1.13.2/jquery-ui.min.js"></script>

    <script>
      $(function () {
        $("#start_date, #end_date").datepicker({
          dateFormat: "yy-mm-dd"
        });

        // Optional: Enforce logical date range
        $("#start_date").on("change", function () {
          var minEndDate = $(this).datepicker("getDate");
          $("#end_date").datepicker("option", "minDate", minEndDate);
        });

        $("#end_date").on("change", function () {
          var maxStartDate = $(this).datepicker("getDate");
          $("#start_date").datepicker("option", "maxDate", maxStartDate);
        });
      });
    </script>
</head>


<section class="content">

    <div class="box box-primary">

        <div class="box-header with-border">
            <h3 class="box-title">Delivery Schema</h3>
        </div>

        <form role="form" class="form-horizontal">
            <div class="box-body">

                <div class="form-group">
                    <a onclick="new_inv();" class="btn btn-default btn-sm">
                        <span class="fa fa-user-plus"></span> &nbsp; New
                    </a>
                    <a onclick="save_inv();" class="btn btn-success btn-sm">
                        <span class="fa fa-save"></span> &nbsp; Save
                    </a> 
                </div>

                <div class="panel-body">

                    <div class="form-group"> 
                        <label class="col-sm-2 control-label" for="start_date">Delivery Marking Since</label>
                        <div class="col-sm-2">
                            <input type="date" name="start_date" id="start_date"
                                   placeholder="Please Select Start Date" 
                                   class="form-control dt input-sm" required>    
                        </div>

                        <label class="col-sm-2 control-label" for="end_date">Last Delivery Marking Date</label>
                        <div class="col-sm-2">
                            <input type="date" name="end_date" id="end_date"
                                   placeholder="Please Select End Date" 
                                   class="form-control dt input-sm" required>    
                        </div>

                        <label class="col-sm-2 control-label" for="stop_date">Marking Enter Stop Date</label>
                        <div class="col-sm-2">
                            <input type="date" name="stop_date" id="stop_date"
                                   placeholder="Please Select End Date" 
                                   class="form-control dt input-sm" required>    
                        </div>
                    </div>

                    <table width="100%" class="table table-striped table-bordered table-hover" id="dataTables-example">
                        <thead> 
                            <tr>
                                <th>#</th>
                                <th>Start Date</th>  
                                <th>End Date</th>
                                <th>Marking Enter Stop Date</th>
                                <th>Created At</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php
                            $i = 1;
                            include './connection_sql.php';

                            $sql = "SELECT * FROM delivery_schema ORDER BY start_date desc";

                            foreach ($conn->query($sql) as $row) {
                                ?>
                                <tr>
                                    <td><?php echo $i; ?></td>
                                    <td><?php echo $row['start_date']; ?></td>
                                    <td><?php echo $row['end_date']; ?></td>
                                    <td><?php echo $row['stop_date']; ?></td>
                                    <td><?php echo $row['create_date']; ?></td>
                                </tr>
                                <?php
                                $i++;
                            }
                            ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </form>
    </div>
</section>

<script>
function new_inv() {
    document.getElementById("start_date").value = "";
    document.getElementById("end_date").value = "";
    document.getElementById("stop_date").value = "";
}

function save_inv() {
    const start_date = document.getElementById("start_date").value;
    const end_date = document.getElementById("end_date").value;
    const stop_date = document.getElementById("stop_date").value;

    if (!start_date || !end_date || !stop_date) {
        alert("Please fill both start and end dates.");
        return;
    }

    const xhr = new XMLHttpRequest();
    xhr.open("POST", "delivery_schema_data.php", true);
    xhr.setRequestHeader("Content-type", "application/x-www-form-urlencoded");

    xhr.onload = function () {
        alert(xhr.responseText);
        if (xhr.status === 200 && xhr.responseText.includes("success")) {
            location.reload(); // refresh table
        }
    };

    xhr.send(`start_date=${start_date}&end_date=${end_date}&stop_date=${stop_date}`);
}
</script>

