<?php
session_start();
include_once 'connection_sql.php';
?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
    <meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
    <link href="style.css" rel="stylesheet" type="text/css" media="screen" />
    <title>Search Collection Note Details</title>

    <link rel="stylesheet" href="css/bootstrap.min.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/twitter-bootstrap/4.1.3/css/bootstrap.css">
    <link rel="stylesheet" href="https://cdn.datatables.net/1.10.19/css/dataTables.bootstrap4.min.css">

    <script src="https://code.jquery.com/jquery-3.3.1.js"></script>
    <script src="https://cdn.datatables.net/1.10.19/js/jquery.dataTables.min.js"></script>
    <script src="https://cdn.datatables.net/1.10.19/js/dataTables.bootstrap4.min.js"></script>
    <script src="js/collection_note.js"></script>
</head>
<body>

<?php
$selectedFilter = isset($_GET['filter']) ? $_GET['filter'] : 'all';
?>

<div class="container my-3">
    <label><input type="radio" name="filterStatus" value="all" <?= ($selectedFilter == 'all') ? 'checked' : '' ?>> All</label>
    <label class="ml-3"><input type="radio" name="filterStatus" value="approved" <?= ($selectedFilter == 'approved') ? 'checked' : '' ?>> Approved</label>
    <label class="ml-3"><input type="radio" name="filterStatus" value="non_approved" <?= ($selectedFilter == 'non_approved') ? 'checked' : '' ?>> Non-Approved</label>
    <label class="ml-3"><input type="radio" name="filterStatus" value="reject" <?= ($selectedFilter == 'reject') ? 'checked' : '' ?>> Reject</label>
</div>

<?php
$filterSql = "";

if ($selectedFilter == 'approved') {
    $filterSql = "approved = 1";
} elseif ($selectedFilter == 'non_approved') {
    $filterSql = "approved = 0";
} elseif ($selectedFilter == 'reject') {
    $filterSql = "approved = 2";
} else {
    $filterSql = "1"; // all records
}

if ($_SESSION["CURRENT_USER"] == 'rohan') {
    $sql = "SELECT * FROM s_collection_note WHERE type = 'New' AND $filterSql ORDER BY ref_no DESC";
} else {
    $sql = "SELECT * FROM s_collection_note WHERE $filterSql ORDER BY ref_no DESC";
}
?>

<div class="container">
    <table id="example" class="table table-bordered" style="font-size: 12px;">
        <thead>
            <tr>
                <th style="text-align:center">Ref No</th>
                <th style="text-align:center">Ref Date</th>    
                <th style="text-align:center">Customer Code</th>    
                <th style="text-align:center">Type</th>    
                <th style="text-align:center">Remark</th> 
                <th style="text-align:center">Status</th>
                <th style="text-align:center">Print</th>            
            </tr>
        </thead>
        <tbody>
<?php

 
foreach ($conn->query($sql) as $row) {
     $approvedBy="";
    if($row['approved']=="1"){
        $status="<span style='color: green; font-weight: bold;'>Approved</span>" ;
        $approvedBy = !empty($row['approved_by']) ? " - {$row['approved_by']}" : "";
    }else if($row['approved']=="2"){
        $status="<span style='color: orange; font-weight: bold;'>Rejected</span>" ;
    }else if($row['approved']=="0"){
        $status="<span style='color: red; font-weight: bold;'>Not Approved</span>" ;
    }


    echo "<tr>
        <td onclick=\"pass_inv('{$row['ref_no']}');\">{$row['ref_no']}</td>
        <td onclick=\"pass_inv('{$row['ref_no']}');\">{$row['date_time']}</td>
        <td onclick=\"pass_inv('{$row['ref_no']}');\">{$row['customer_code']} - {$row['customer_name']}</td>
        <td onclick=\"pass_inv('{$row['ref_no']}');\">{$row['type']}</td>
        <td onclick=\"pass_inv('{$row['ref_no']}');\">{$row['remark']}</td>
        <td onclick=\"pass_inv('{$row['ref_no']}');\">{$status}{$approvedBy}</td>
        <td onclick=\"pass_inv('{$row['ref_no']}');\">{$row['printed']}</td>
    </tr>";
}
?>
</tbody>

    </table>
</div>

<script type="text/javascript">
$(document).ready(function() {
    $('#example').DataTable({
        lengthChange: true,
        fixedHeader: true,
        responsive: true,
        deferRender: true,
        order: [[ 0, 'desc' ]],
        lengthMenu: [[25, 50, 100, -1], ['25 rows', '50 rows', '100 rows', 'Show all']],
    });

    $('input[name="filterStatus"]').change(function () {
        const selected = $(this).val();
        window.location.href = "search_collection_note.php?filter=" + selected;
    });
});
</script>

</body>
</html>
