<?php
include './connection_sql.php';

if (isset($_POST["Command"])) {
    if ($_POST["Command"] == "get_item") {
        getItemDetails();
    } else if ($_POST["Command"] == "get_trn_detail") {
        getTrnDetails();
    }
}

function getItemDetails() {
    $itemno = mysqli_real_escape_string($GLOBALS['dbinv'], $_POST["itemno"]);
    $dep = mysqli_real_escape_string($GLOBALS['dbinv'], $_POST["dep"]);
    $dtfrom = mysqli_real_escape_string($GLOBALS['dbinv'], $_POST["dtfrom"]);
    $year = mysqli_real_escape_string($GLOBALS['dbinv'], $_POST["year"]);
    $showTrans = $_POST["showTrans"];
    $response = array();

    // Get item details from s_mas
    $sql = "SELECT * FROM s_mas WHERE STK_NO = '$itemno'";
    $result = mysqli_query($GLOBALS['dbinv'], $sql);
    
    if (mysqli_num_rows($result) > 0) {
        $response["status"] = "success";
        $response["item"] = mysqli_fetch_assoc($result);
        
        // Get 90-day sales
        $sql90 = "SELECT SUM(QTY) as qty90 FROM s_trn 
                 WHERE STK_NO = '$itemno' 
                 AND SDATE >= DATE_SUB(CURDATE(), INTERVAL 90 DAY)
                 AND LEDINDI = 'INV'";
        $result90 = mysqli_query($GLOBALS['dbinv'], $sql90);
        $row90 = mysqli_fetch_assoc($result90);
        $response["day90"] = $row90["qty90"] ? $row90["qty90"] : "0";
        
        // Get stock in hand
        $sqlStk = "SELECT SUM(QTY) as stk FROM s_trn 
                  WHERE STK_NO = '$itemno' 
                  AND LEDINDI = 'GRN'";
        $resultStk = mysqli_query($GLOBALS['dbinv'], $sqlStk);
        $rowStk = mysqli_fetch_assoc($resultStk);
        $response["stkinhand"] = $rowStk["stk"] ? $rowStk["stk"] : "0";
        
        // Get unsold quantity
        $sqlUnsold = "SELECT SUM(QTY) as unsold FROM s_trn 
                     WHERE STK_NO = '$itemno' 
                     AND LEDINDI = 'GRN' 
                     AND REFNO NOT IN (SELECT REFNO FROM s_trn WHERE STK_NO = '$itemno' AND LEDINDI = 'INV')";
        $resultUnsold = mysqli_query($GLOBALS['dbinv'], $sqlUnsold);
        $rowUnsold = mysqli_fetch_assoc($resultUnsold);
        $response["unsold"] = $rowUnsold["unsold"] ? $rowUnsold["unsold"] : "0";
        
        // Get pending orders
        $sqlPending = "SELECT COUNT(*) as pending FROM s_ordmas 
                      WHERE STK_NO = '$itemno' AND CANCEL='0'";
        $resultPending = mysqli_query($GLOBALS['dbinv'], $sqlPending);
        $rowPending = mysqli_fetch_assoc($resultPending);
        $response["pending"] = $rowPending["pending"];
        
        // Get consumption data by month for the selected year
        $consumHtml = "<table class='table table-striped'>";
        $consumHtml .= "<tr class='info'><th>Month</th><th>Quantity</th><th>Amount</th></tr>";
        
        for ($i = 1; $i <= 12; $i++) {
            $sqlCons = "SELECT SUM(QTY) as qty, SUM(QTY*COST) as amount 
                      FROM s_trn 
                      WHERE STK_NO = '$itemno' 
                      AND YEAR(SDATE) = '$year' 
                      AND MONTH(SDATE) = '$i'
                      AND LEDINDI = 'INV'";
            $resultCons = mysqli_query($GLOBALS['dbinv'], $sqlCons);
            $rowCons = mysqli_fetch_assoc($resultCons);
            
            $monthName = date("F", mktime(0, 0, 0, $i, 10));
            $qty = $rowCons["qty"] ? $rowCons["qty"] : "0";
            $amount = $rowCons["amount"] ? number_format($rowCons["amount"], 2) : "0.00";
            
            $consumHtml .= "<tr><td>$monthName</td><td>$qty</td><td>$amount</td></tr>";
        }
        $consumHtml .= "</table>";
        $response["consumHtml"] = $consumHtml;
        
        // Get transaction details
        $transHtml = "";
        if ($showTrans == "1") {
            $transHtml = "<table class='table table-bordered table-striped'>";
            $transHtml .= "<tr class='success'><th>Date</th><th>Ref No</th><th>Type</th><th>Qty</th><th>Cost</th><th>Selling</th><th>Balance</th><th>Action</th></tr>";
            
            $depCondition = "";
            if ($dep != "All") {
                $depCondition = "AND DEPARTMENT = '$dep'";
            }
            
            $sqlTrn = "SELECT *, 
                      @balance := @balance + IF(QTY_B > 0, QTY, -QTY) as BALANCE
                      FROM s_trn, (SELECT @balance := 0) as b
                      WHERE STK_NO = '$itemno' $depCondition
                      AND SDATE >= '$dtfrom'
                      ORDER BY SDATE, LEDINDI";
            $resultTrn = mysqli_query($GLOBALS['dbinv'], $sqlTrn);
            
            while ($rowTrn = mysqli_fetch_assoc($resultTrn)) {
                $date = $rowTrn["SDATE"];
                $refno = $rowTrn["REFNO"];
                $ledindi = $rowTrn["LEDINDI"];
                $qty = $rowTrn["QTY"];
                $cost = number_format($rowTrn["COST"], 2);
                $selling = number_format($rowTrn["SELLING"], 2);
                $balance = $rowTrn["BALANCE"];
                $trnno = $rowTrn["STK_NO"] . "_" . $rowTrn["ID"];
                
                $transHtml .= "<tr>";
                $transHtml .= "<td>$date</td>";
                $transHtml .= "<td>$refno</td>";
                $transHtml .= "<td>$ledindi</td>";
                $transHtml .= "<td>$qty</td>";
                $transHtml .= "<td>$cost</td>";
                $transHtml .= "<td>$selling</td>";
                $transHtml .= "<td>$balance</td>";
                $transHtml .= "<td><a href='javascript:void(0)' onclick='viewTrnDetails(\"$trnno\")'>View</a></td>";
                $transHtml .= "</tr>";
            }
            $transHtml .= "</table>";
        }
        $response["transHtml"] = $transHtml;
        
        // Additional details for the right panel
        $detailsHtml = "<table class='table table-bordered'>";
        $detailsHtml .= "<tr class='info'><th colspan='2'>Item Details</th></tr>";
        $detailsHtml .= "<tr><td>Item No</td><td>" . $response["item"]["STK_NO"] . "</td></tr>";
        $detailsHtml .= "<tr><td>Description</td><td>" . $response["item"]["DESCRIPT"] . "</td></tr>";
        $detailsHtml .= "<tr><td>Part No</td><td>" . $response["item"]["PART_NO"] . "</td></tr>";
        $detailsHtml .= "<tr><td>Category</td><td>" . $response["item"]["BRAND_NAME"] . "</td></tr>";
        $detailsHtml .= "<tr><td>Cost</td><td>" . number_format($response["item"]["COST"], 2) . "</td></tr>";
        $detailsHtml .= "<tr><td>Selling</td><td>" . number_format($response["item"]["SELLING"], 2) . "</td></tr>";
        $detailsHtml .= "<tr><td>Stock in Hand</td><td>" . $response["item"]["QTYINHAND"] . "</td></tr>";
        $detailsHtml .= "</table>";
        $response["detailsHtml"] = $detailsHtml;
        
    } else {
        $response["status"] = "error";
        $response["message"] = "Item not found!";
    }
    
    echo json_encode($response);
}

function getTrnDetails() {
    $trnno = mysqli_real_escape_string($GLOBALS['dbinv'], $_POST["trnno"]);
    $parts = explode("_", $trnno);
    $itemno = $parts[0];
    $id = $parts[1];
    
    $sql = "SELECT t.*, m.DESCRIPT 
            FROM s_trn t 
            INNER JOIN s_mas m ON t.STK_NO = m.STK_NO 
            WHERE t.ID = '$id' AND t.STK_NO = '$itemno'";
    $result = mysqli_query($GLOBALS['dbinv'], $sql);
    
    $response = array();
    
    if (mysqli_num_rows($result) > 0) {
        $row = mysqli_fetch_assoc($result);
        
        $detailsHtml = "<div class='panel panel-primary'>";
        $detailsHtml .= "<div class='panel-heading'>Transaction Details</div>";
        $detailsHtml .= "<div class='panel-body'>";
        $detailsHtml .= "<table class='table table-bordered'>";
        $detailsHtml .= "<tr><td>Date</td><td>" . $row["SDATE"] . "</td></tr>";
        $detailsHtml .= "<tr><td>Reference No</td><td>" . $row["REFNO"] . "</td></tr>";
        $detailsHtml .= "<tr><td>Transaction Type</td><td>" . $row["LEDINDI"] . "</td></tr>";
        $detailsHtml .= "<tr><td>Item No</td><td>" . $row["STK_NO"] . "</td></tr>";
        $detailsHtml .= "<tr><td>Description</td><td>" . $row["DESCRIPT"] . "</td></tr>";
        $detailsHtml .= "<tr><td>Quantity</td><td>" . $row["QTY"] . "</td></tr>";
        $detailsHtml .= "<tr><td>Cost</td><td>" . number_format($row["COST"], 2) . "</td></tr>";
        $detailsHtml .= "<tr><td>Selling</td><td>" . number_format($row["SELLING"], 2) . "</td></tr>";
        $detailsHtml .= "<tr><td>Department</td><td>" . $row["DEPARTMENT"] . "</td></tr>";
        
        // Get related details based on transaction type
        if ($row["LEDINDI"] == "GRN") {
            // Get GRN details
            $sqlGrn = "SELECT * FROM s_purmas WHERE REFNO = '" . $row["REFNO"] . "'";
            $resultGrn = mysqli_query($GLOBALS['dbinv'], $sqlGrn);
            if (mysqli_num_rows($resultGrn) > 0) {
                $rowGrn = mysqli_fetch_assoc($resultGrn);
                $detailsHtml .= "<tr><td>Supplier</td><td>" . $rowGrn["SUP_CODE"] . "</td></tr>";
                $detailsHtml .= "<tr><td>Invoice No</td><td>" . $rowGrn["INVOICENO"] . "</td></tr>";
                $detailsHtml .= "<tr><td>Invoice Date</td><td>" . $rowGrn["SDATE"] . "</td></tr>";
            }
        } else if ($row["LEDINDI"] == "INV") {
            // Get Invoice details
            $sqlInv = "SELECT i.*, c.NAME FROM s_salma i LEFT JOIN vendor c ON i.CUSCODE = c.CODE WHERE i.REF_NO = '" . $row["REFNO"] . "'";
            $resultInv = mysqli_query($GLOBALS['dbinv'], $sqlInv);
            if (mysqli_num_rows($resultInv) > 0) {
                $rowInv = mysqli_fetch_assoc($resultInv);
                $detailsHtml .= "<tr><td>Customer</td><td>" . $rowInv["CUSCODE"] . " - " . $rowInv["NAME"] . "</td></tr>";
                $detailsHtml .= "<tr><td>Invoice No</td><td>" . $rowInv["REF_NO"] . "</td></tr>";
                $detailsHtml .= "<tr><td>Invoice Date</td><td>" . $rowInv["SDATE"] . "</td></tr>";
            }
        }
        
        $detailsHtml .= "</table>";
        $detailsHtml .= "</div></div>";
        
        $response["status"] = "success";
        $response["detailsHtml"] = $detailsHtml;
    } else {
        $response["status"] = "error";
        $response["message"] = "Transaction not found!";
    }
    
    echo json_encode($response);
}
?>
