<?php
include './connection_sql.php';

$itemno = mysqli_real_escape_string($GLOBALS['dbinv'], $_GET["itemno"]);
$dep = mysqli_real_escape_string($GLOBALS['dbinv'], $_GET["dep"]);
$dtfrom = mysqli_real_escape_string($GLOBALS['dbinv'], $_GET["dtfrom"]);

// Get item details
$sql = "SELECT * FROM s_mas WHERE STK_NO = '$itemno'";
$result = mysqli_query($GLOBALS['dbinv'], $sql);
$row = mysqli_fetch_assoc($result);

// Get yearly consumption data
$years = array();
$sqlYears = "SELECT DISTINCT YEAR(SDATE) as year FROM s_trn WHERE STK_NO = '$itemno' ORDER BY year DESC LIMIT 3";
$resultYears = mysqli_query($GLOBALS['dbinv'], $sqlYears);
while ($rowYear = mysqli_fetch_assoc($resultYears)) {
    $years[] = $rowYear["year"];
}

$monthlyConsumption = array();
foreach ($years as $year) {
    for ($month = 1; $month <= 12; $month++) {
        $sqlCons = "SELECT SUM(QTY) as qty 
                   FROM s_trn 
                   WHERE STK_NO = '$itemno' 
                   AND YEAR(SDATE) = '$year' 
                   AND MONTH(SDATE) = '$month'
                   AND LEDINDI = 'INV'";
        $resultCons = mysqli_query($GLOBALS['dbinv'], $sqlCons);
        $rowCons = mysqli_fetch_assoc($resultCons);
        
        $monthlyConsumption[$year][$month] = $rowCons["qty"] ? $rowCons["qty"] : 0;
    }
}

?>

<!DOCTYPE html>
<html>
<head>
    <title>Supplementary Card - <?php echo $row["STK_NO"]; ?></title>
    <style>
        body {
            font-family: Arial, sans-serif;
            margin: 20px;
        }
        .header {
            text-align: center;
            margin-bottom: 20px;
        }
        .item-details {
            margin-bottom: 20px;
        }
        table {
            width: 100%;
            border-collapse: collapse;
            margin-bottom: 20px;
        }
        th, td {
            border: 1px solid #ddd;
            padding: 8px;
            text-align: left;
        }
        th {
            background-color: #f2f2f2;
        }
        .print-btn {
            margin: 20px 0;
        }
        @media print {
            .print-btn {
                display: none;
            }
        }
    </style>
</head>
<body>
    <div class="header">
        <h2>Supplementary Card</h2>
        <h3>Item: <?php echo $row["STK_NO"] . " - " . $row["DESCRIPT"]; ?></h3>
    </div>
    
    <div class="item-details">
        <p><strong>Part No:</strong> <?php echo $row["PART_NO"]; ?></p>
        <p><strong>Category:</strong> <?php echo $row["BRAND_NAME"]; ?></p>
        <p><strong>Current Stock:</strong> <?php echo $row["QTYINHAND"]; ?></p>
        <p><strong>Cost Price:</strong> <?php echo number_format($row["COST"], 2); ?></p>
        <p><strong>Selling Price:</strong> <?php echo number_format($row["SELLING"], 2); ?></p>
    </div>
    
    <h3>Monthly Consumption</h3>
    
    <table>
        <thead>
            <tr>
                <th>Month</th>
                <?php
                foreach ($years as $year) {
                    echo "<th>$year</th>";
                }
                ?>
            </tr>
        </thead>
        <tbody>
            <?php
            $months = array("January", "February", "March", "April", "May", "June", "July", "August", "September", "October", "November", "December");
            
            for ($i = 0; $i < 12; $i++) {
                echo "<tr>";
                echo "<td>" . $months[$i] . "</td>";
                
                foreach ($years as $year) {
                    echo "<td>" . $monthlyConsumption[$year][$i + 1] . "</td>";
                }
                
                echo "</tr>";
            }
            
            // Add total row
            echo "<tr style='font-weight: bold;'>";
            echo "<td>Total</td>";
            
            foreach ($years as $year) {
                $total = array_sum($monthlyConsumption[$year]);
                echo "<td>$total</td>";
            }
            
            echo "</tr>";
            ?>
        </tbody>
    </table>
    
    <h3>Suppliers Information</h3>
    
    <table>
        <thead>
            <tr>
                <th>Supplier</th>
                <th>Last GRN Date</th>
                <th>Last Cost</th>
                <th>Quantity</th>
            </tr>
        </thead>
        <tbody>
            <?php
            $sqlSup = "SELECT t.*, p.SUP_CODE, s.NAME
                      FROM s_trn t
                      INNER JOIN s_purmas p ON t.REFNO = p.REFNO
                      INNER JOIN vendor s ON p.SUP_CODE = s.CODE
                      WHERE t.STK_NO = '$itemno' AND t.LEDINDI = 'GRN'
                      ORDER BY t.SDATE DESC
                      LIMIT 5";
            $resultSup = mysqli_query($GLOBALS['dbinv'], $sqlSup);
            
            while ($rowSup = mysqli_fetch_assoc($resultSup)) {
                echo "<tr>";
                echo "<td>" . $rowSup["SUP_CODE"] . " - " . $rowSup["NAME"] . "</td>";
                echo "<td>" . $rowSup["SDATE"] . "</td>";
                echo "<td>" . number_format($rowSup["COST"], 2) . "</td>";
                echo "<td>" . $rowSup["QTY"] . "</td>";
                echo "</tr>";
            }
            ?>
        </tbody>
    </table>
    
    <div class="print-btn">
        <button onclick="window.print();">Print Supplementary Card</button>
        <button onclick="window.close();">Close</button>
    </div>
</body>
</html>
