<?php
include './connection_sql.php';

$itemno = mysqli_real_escape_string($GLOBALS['dbinv'], $_GET["itemno"]);
$dep = mysqli_real_escape_string($GLOBALS['dbinv'], $_GET["dep"]);
$dtfrom = mysqli_real_escape_string($GLOBALS['dbinv'], $_GET["dtfrom"]);

// Get item details
$sql = "SELECT * FROM s_mas WHERE STK_NO = '$itemno'";
$result = mysqli_query($GLOBALS['dbinv'], $sql);
$row = mysqli_fetch_assoc($result);

$depCondition = "";
if ($dep != "All") {
    $depCondition = "AND DEPARTMENT = '$dep'";
}

// Get transactions
$sqlTrn = "SELECT *, 
          @balance := @balance + IF(QTY_B > 0, QTY, -QTY) as BALANCE
          FROM s_trn, (SELECT @balance := 0) as b
          WHERE STK_NO = '$itemno' $depCondition
          AND SDATE >= '$dtfrom'
          ORDER BY SDATE, LEDINDI";
$resultTrn = mysqli_query($GLOBALS['dbinv'], $sqlTrn);

?>

<!DOCTYPE html>
<html>
<head>
    <title>Bin Card - <?php echo $row["STK_NO"]; ?></title>
    <style>
        body {
            font-family: Arial, sans-serif;
            margin: 20px;
        }
        .header {
            text-align: center;
            margin-bottom: 20px;
        }
        .item-details {
            margin-bottom: 20px;
        }
        table {
            width: 100%;
            border-collapse: collapse;
        }
        th, td {
            border: 1px solid #ddd;
            padding: 8px;
            text-align: left;
        }
        th {
            background-color: #f2f2f2;
        }
        .print-btn {
            margin: 20px 0;
        }
        @media print {
            .print-btn {
                display: none;
            }
        }
    </style>
</head>
<body>
    <div class="header">
        <h2>Bin Card</h2>
        <h3>Item: <?php echo $row["STK_NO"] . " - " . $row["DESCRIPT"]; ?></h3>
    </div>
    
    <div class="item-details">
        <p><strong>Part No:</strong> <?php echo $row["PART_NO"]; ?></p>
        <p><strong>Category:</strong> <?php echo $row["BRAND_NAME"]; ?></p>
        <p><strong>Current Stock:</strong> <?php echo $row["QTYINHAND"]; ?></p>
        <p><strong>Cost Price:</strong> <?php echo number_format($row["COST"], 2); ?></p>
        <p><strong>Selling Price:</strong> <?php echo number_format($row["SELLING"], 2); ?></p>
        <p><strong>From Date:</strong> <?php echo $dtfrom; ?></p>
        <p><strong>Department:</strong> <?php echo $dep; ?></p>
    </div>
    
    <table>
        <thead>
            <tr>
                <th>Date</th>
                <th>Ref No</th>
                <th>Type</th>
                <th>Qty In</th>
                <th>Qty Out</th>
                <th>Cost</th>
                <th>Balance</th>
            </tr>
        </thead>
        <tbody>
            <?php
            while ($rowTrn = mysqli_fetch_assoc($resultTrn)) {
                echo "<tr>";
                echo "<td>" . $rowTrn["SDATE"] . "</td>";
                echo "<td>" . $rowTrn["REFNO"] . "</td>";
                echo "<td>" . $rowTrn["LEDINDI"] . "</td>";
                
                if ($rowTrn["QTY_B"] > 0) {
                    echo "<td>" . $rowTrn["QTY"] . "</td>";
                    echo "<td></td>";
                } else {
                    echo "<td></td>";
                    echo "<td>" . $rowTrn["QTY"] . "</td>";
                }
                
                echo "<td>" . number_format($rowTrn["COST"], 2) . "</td>";
                echo "<td>" . $rowTrn["BALANCE"] . "</td>";
                echo "</tr>";
            }
            ?>
        </tbody>
    </table>
    
    <div class="print-btn">
        <button onclick="window.print();">Print Bin Card</button>
        <button onclick="window.close();">Close</button>
    </div>
</body>
</html>
