<?php
// MySQL connection
$servername = "localhost";
$username = "root"; 
$password = ""; 
$dbname = "SWijesooriya_tht"; 
$conn = new mysqli($servername, $username, $password, $dbname);

// Check connection
if ($conn->connect_error) {
    die("Connection failed: " . $conn->connect_error);
}

// Get filter values
$user = isset($_GET['user_name']) ? $_GET['user_name'] : '';
$from_date = isset($_GET['from_date']) ? $_GET['from_date'] : '';
$to_date = isset($_GET['to_date']) ? $_GET['to_date'] : '';

// Build query
$query = "SELECT id, user_name, latitude, longitude, created_at, ip FROM s_locations WHERE 1=1";
if ($user != '') {
    $query .= " AND user_name = '" . $conn->real_escape_string($user) . "'";
}
if ($from_date != '' && $to_date != '') {
    $query .= " AND created_at >= '" . $conn->real_escape_string($from_date) . "' 
                AND created_at < DATE_ADD('" . $conn->real_escape_string($to_date) . "', INTERVAL 1 DAY)";
}

$result = $conn->query($query);
$locations = [];
while ($row = $result->fetch_assoc()) {
    $locations[] = [
        'id' => $row['id'],
        'user_name' => $row['user_name'],
        'latitude' => $row['latitude'],
        'longitude' => $row['longitude'],
        'created_at' => $row['created_at'],
        'ip' => $row['ip']
    ];
}
?>
<!DOCTYPE html>
<html>
<head>
    <title>Leaflet Map with Arrows and Start/End Labels</title>
    <link rel="stylesheet" href="https://unpkg.com/leaflet/dist/leaflet.css" />
    <style>
        #map { height: 600px; width: 100%; margin-top: 20px; }
        form { margin-bottom: 10px; }
        .text-label { font-size: 14px; font-weight: bold; }
    </style>
</head>
<body>
    <h2>Control Map</h2>
    <!-- Filter Form -->
    <form method="get" action="">
        <label>User:</label>
        <select name="user_name">
            <option value="">All</option>
            <?php
            $user_query = "SELECT DISTINCT user_name FROM s_locations";
            $user_result = $conn->query($user_query);
            while ($u = $user_result->fetch_assoc()) {
                $selected = ($u['user_name'] == $user) ? "selected" : "";
                echo "<option value='{$u['user_name']}' $selected>{$u['user_name']}</option>";
            }
            ?>
        </select>
        <label>From:</label>
        <input type="date" name="from_date" value="<?= htmlspecialchars($from_date) ?>">
        <label>To:</label>
        <input type="date" name="to_date" value="<?= htmlspecialchars($to_date) ?>">
        <button type="submit">Filter</button>
    </form>

    <div id="map"></div>

    <script src="https://unpkg.com/leaflet/dist/leaflet.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/leaflet-polylinedecorator/1.7.0/leaflet.polylineDecorator.min.js"></script>
    <script>
    var locations = <?php echo json_encode($locations); ?>;

    if (locations.length > 0) {
        var map = L.map('map').setView([parseFloat(locations[0].latitude), parseFloat(locations[0].longitude)], 7);

        L.tileLayer('https://{s}.tile.openstreetmap.org/{z}/{x}/{y}.png', {
            attribution: '&copy; OpenStreetMap contributors'
        }).addTo(map);

        var latlngs = [];

        locations.forEach(function(loc, index) {
            var lat = parseFloat(loc.latitude);
            var lng = parseFloat(loc.longitude);
            latlngs.push([lat, lng]);

            var label = '';
            var iconUrl = "https://maps.google.com/mapfiles/ms/icons/blue-dot.png"; // default blue pin

            if (index === 0) {
                iconUrl = "https://maps.google.com/mapfiles/ms/icons/green-dot.png"; // Start
                label = 'Start';
            }
            if (index === locations.length - 1) {
                iconUrl = "https://maps.google.com/mapfiles/ms/icons/red-dot.png"; // End
                label = 'End';
            }

            var marker = L.marker([lat, lng], {
                icon: L.icon({
                    iconUrl: iconUrl,
                    iconSize: [32, 32],
                    iconAnchor: [16, 32],
                    popupAnchor: [0, -32]
                })
            }).addTo(map);

            marker.bindPopup(
                "<b>User:</b> " + loc.user_name + "<br>" +
                "<b>Created At:</b> " + loc.created_at + "<br>" +
                "<b>IP:</b> " + loc.ip
            );

            // Add Start/End labels
            if (label !== '') {
                L.marker([lat, lng], {
                    icon: L.divIcon({
                        className: 'text-label',
                        html: "<b style='color:" + (index === 0 ? "green" : "red") + ";'>" + label + "</b>",
                        iconSize: [30, 20],
                        iconAnchor: [15, -10]
                    })
                }).addTo(map);
            }
        });

        // Draw polyline
        var polyline = L.polyline(latlngs, {color: 'blue', weight: 3, opacity: 0.7}).addTo(map);

        // Add arrows to the polyline
        L.polylineDecorator(polyline, {
            patterns: [
                {
                    offset: '5%',
                    repeat: '10%',
                    symbol: L.Symbol.arrowHead({
                        pixelSize: 10,
                        polygon: true,
                        pathOptions: {fillOpacity: 1, color: 'blue', weight: 0}
                    })
                }
            ]
        }).addTo(map);

        map.fitBounds(polyline.getBounds());
    } else {
        document.getElementById('map').innerHTML = "No locations to display.";
    }
    </script>
</body>
</html>
