 

function save_inv(event) {
  // Prevent form submission
  event.preventDefault();

  var ref_no = [];
  var collect = [];
  var remark = [];

  // Collect data from the inputs
  $("input[name='ref_no[]']").each(function() {
    ref_no.push($(this).val());
  });

  $("input[name='collect[]']").each(function() {
    collect.push($(this).val());
  });

  $("input[name='remark[]']").each(function() {
    remark.push($(this).val());
  });

  // Collect other form data
  var data = {
    action: 'save',
    ref_no: ref_no,
    collect: collect,
    remark: remark,
    sdate1: $('#s_date').val(),
    c_code: $('#firstname_hidden').val(),
    cus_name: $('#firstname').val(), 
  };

  // AJAX request for the first part (save)
  $.ajax({
    type: 'POST',
    url: 'ref-remark-summary-save.php',
    data: data,
    success: function(response) {
      alert(response);  // Show success message
      
      // Now call the second AJAX request for 'summary_save'
      var ref_no_summary = [];
      var collect_summary = [];
      var remark_summary = [];

      // Collect data from the inputs for the summary
      $("input[name='ref_no_summary[]']").each(function() {
        ref_no_summary.push($(this).val());
      });

      $("input[name='collect_summary[]']").each(function() {
        collect_summary.push($(this).val());
      });

      $("input[name='remark_summary[]']").each(function() {
        remark_summary.push($(this).val());
      });

      // Collect other form data for summary
      var summary_data = {
        action: 'summary_save',
        ref_no: ref_no_summary,
        collect: collect_summary,
        remark: remark_summary,
        sdate1: $('#s_date').val(),
        c_code: $('#firstname_hidden').val(),
        cus_name: $('#firstname').val(),
      };

      // AJAX request for the second part (summary_save)
      $.ajax({
        type: 'POST',
        url: 'ref-remark-summary-save.php',
        data: summary_data,
        success: function(response) {
          window.location.reload()
        },
        error: function(xhr, status, error) {
          console.log("Error: " + error);
          alert("There was an error saving the data. Please try again.");
        }
      });
    },
    error: function(xhr, status, error) {
      console.log("Error: " + error);
      alert("There was an error saving the data. Please try again.");
    }
  });
}



$(".date_picker").datepicker({
  dateFormat: "yy-mm-dd",
  defaultDate: new Date(),
}).datepicker("setDate", new Date());

$('.example').DataTable({
  responsive: true,
  lengthChange: true,
  fixedHeader: true,
  deferRender: true,
  order: [[0, 'desc']],
  lengthMenu: [[15, 25, 50, 100, -1], ['15 rows', '25 rows', '50 rows', '100 rows', 'Show all']]
});



      // Initialize DataTable for Invoice Table
$('#invoiceTable').DataTable({
  responsive: true,
  lengthChange: true,
  fixedHeader: true,
        order: [[0, 'desc']], // Default sorting by the first column
        lengthMenu: [[15, 25, 50, 100, -1], ['15 rows', '25 rows', '50 rows', '100 rows', 'Show all']]
      });

      // Initialize DataTable for Summary Table
$('#summaryTable').DataTable({
  responsive: true,
  lengthChange: true,
  fixedHeader: true,
        order: [[0, 'desc']], // Default sorting by the first column
        lengthMenu: [[15, 25, 50, 100, -1], ['15 rows', '25 rows', '50 rows', '100 rows', 'Show all']]
      });





    //click customer data show
function custno(cuscode, stname) {

  var row = event.target.closest('tr');
  var customerCode = row.cells[0].innerText;
  var customerName = row.cells[1].innerText;
  var customerAddress = row.cells[2].innerText;
  var customerPhone = row.cells[3].innerText;
  var subCustomerCode = row.cells[4].innerText;

  document.getElementById('firstname_hidden').value = customerCode;
  document.getElementById('firstname').value = customerName;


  custno_ind(customerCode);
  custno_ind_salmas(customerCode);

  setTimeout(function () {
    $('#dataModalCustomer').modal('hide');
  }, 500);
}

function custno_ind(customerCode) {
  var customer_id = customerCode;

  if (customer_id != '') {
    $.ajax({
      type: "POST",
          url: "ref-remark-summary-data.php",  // PHP file to process the data
          data: {
            action: 'cheq',  // Pass the action as 'cheq'
            firstname_hidden: customer_id
          },
          success: function (response) {
            $("#invoiceTable tbody").html(response);  // Update table body with response
          },
          error: function () {
            alert('Error fetching data.');
          }
        });
  } else {
    alert('Please enter a customer code.');
  }
}

function custno_ind_salmas(customerCode) {
  var customer_id = customerCode;

  if (customer_id != '') {
    $.ajax({
      type: "POST",
          url: "ref-remark-summary-data.php",  // PHP file to process the data
          data: {
            action: 'salmas',  // Pass the action as 'salmas'
            firstname_hidden: customer_id
          },
          success: function (response) {
            $("#summaryTable tbody").html(response);  // Update table body with response
          },
          error: function () {
            alert('Error fetching data.');
          }
        });
  } else {
    alert('Please enter a customer code.');
  }
}

