let pieChart = null; // Store the chart instance globally

document.addEventListener("DOMContentLoaded", function () {
    const currentDate = new Date();
    const currentMonth = currentDate.getMonth() + 1;
    const currentYear = currentDate.getFullYear();

    document.getElementById('month-select').value = currentMonth;
    document.getElementById('year-select').value = currentYear;

    filterChart();
});

function filterChart() {
    const month = document.getElementById('month-select').value;
    const year = document.getElementById('year-select').value;

    if (month && year) {
        fetch(`piechart_data.php?month=${month}&year=${year}`)
            .then(response => response.json())
            .then(data => {
                const pieChartData = data.pieChartData || [];

                // Correct handling of userType === 0
                const userType = ('userType' in data) ? data.userType : null;

                const chartContainer = document.getElementById('chart-container');
                const noDataMessage = document.getElementById('no-data-message');
                const pieChartElement = document.querySelector('#pie-chart');

                if (pieChartData.length === 0) {
                    chartContainer.style.display = 'none';
                    noDataMessage.style.display = 'block';
                    return;
                }

                noDataMessage.style.display = 'none';
                chartContainer.style.display = 'block';

                const pieChartOptions = {
                    series: pieChartData.map(item => item.value),
                    chart: { type: 'pie', height: 350 },
                    labels: pieChartData.map(item => item.label),
                    colors: ['#008FFB', '#00E396', '#FEB019', '#FF4560', '#775DD0'],
                    legend: { position: 'right' },
                    plotOptions: {
                        pie: {
                            dataLabels: {
                                offset: 0,
                                minAngleToShowLabel: 10
                            }
                        }
                    },
                    dataLabels: {
                        enabled: true,
                        formatter: function (val, opts) {
                            return opts.w.config.series[opts.seriesIndex];
                        }
                    }
                };

                if (pieChart) {
                    pieChart.destroy();
                }

                pieChart = new ApexCharts(pieChartElement, pieChartOptions);
                pieChart.render();
            })
            .catch(error => console.error('Error fetching pie chart data:', error));
    } else {
        alert('Please select both month and year.');
    }
}
