

let currentPage = 1;
const rowsPerPage = 3;


function showPage(page) {
	const table = document.getElementById('dataTable');
	const rows = table.getElementsByTagName('tr');
	const startIndex = (page - 1) * rowsPerPage;
	const endIndex = page * rowsPerPage;

	let visibleRows = 0;

	for (let i = 1; i < rows.length; i++) {
		if (rows[i].style.display !== "none") {
			visibleRows++;
		}
	}

	let rowCount = 0;
	for (let i = 1; i < rows.length; i++) {
		if (rows[i].style.display !== "none") {
			rowCount++;
		}
	}

	for (let i = 1; i < rows.length; i++) {
		const row = rows[i];
		if (rowCount === 0 || i > startIndex && i <= endIndex) {
			row.style.display = "";
		} else {
			row.style.display = "none";
		}
	}
}


function sortTable(n) {
	const table = document.getElementById("dataTable");
	let switching = true;
	let shouldSwitch, i, x, y;

	while (switching) {
		switching = false;
		const rows = table.rows;
		for (i = 1; i < rows.length - 1; i++) {
			shouldSwitch = false;
			x = rows[i].getElementsByTagName("TD")[n];
			y = rows[i + 1].getElementsByTagName("TD")[n];

			if (x.innerHTML.toLowerCase() > y.innerHTML.toLowerCase()) {
				shouldSwitch = true;
				break;
			}
		}

		if (shouldSwitch) {
			rows[i].parentNode.insertBefore(rows[i + 1], rows[i]);
			switching = true;
		}
	}
}


function searchTable() {
	let input = document.getElementById("searchInput");
	let filter = input.value.toLowerCase();
	let table = document.getElementById("dataTable");
	let tr = table.getElementsByTagName("tr");

	for (let i = 1; i < tr.length; i++) {
		let td = tr[i].getElementsByTagName("td");
		let found = false;
		for (let j = 0; j < td.length; j++) {
			if (td[j].textContent.toLowerCase().indexOf(filter) > -1) {
				found = true;
				break;
			}
		}

		tr[i].style.display = found ? "" : "none";
	}

	
	showPage(1);
}


function createPagination() {
	const table = document.getElementById('dataTable');
	const rows = table.getElementsByTagName('tr');
	const rowCount = rows.length - 1;
	const pageCount = Math.ceil(rowCount / rowsPerPage);

	let paginationHtml = '';

	for (let i = 1; i <= pageCount; i++) {
		paginationHtml += `<button class="pagination-button" onclick="goToPage(${i})">${i}</button>`;
	}

	document.getElementById('pagination').innerHTML = paginationHtml;
}


function goToPage(page) {
	currentPage = page;
	showPage(currentPage);
	updateActivePageButton();
}


function updateActivePageButton() {
	const buttons = document.getElementsByClassName('pagination-button');
	for (let i = 0; i < buttons.length; i++) {
		if (parseInt(buttons[i].textContent) === currentPage) {
			buttons[i].classList.add('active');
		} else {
			buttons[i].classList.remove('active');
		}
	}
}


function initializeTable() {
	createPagination();
	showPage(currentPage);
}


window.onload = function() {
	initializeTable();
};