// collection_assign.js
// JavaScript for Collection Assign page

$(document).ready(function () {
  // Fetch the next entry ref no on page load (if needed in future)
  /*
  $.ajax({
    url: 'collection_assign_data_save.php',
    type: 'POST',
    data: { action: 'get_next_entry_ref_no' },
    success: function(refNo) {
      if (refNo) {
        $('#entry_ref_no').val(refNo);
      }
    }
  });
  */

  $(".date_picker").datepicker({
    dateFormat: "yy-mm-dd",
    defaultDate: new Date(),
  }).datepicker("setDate", new Date());

  $('.example').DataTable({
    responsive: true,
    lengthChange: true,
    fixedHeader: true,
    deferRender: true,
    order: [[0, 'desc']],
    lengthMenu: [[15, 25, 50, 100, -1], ['15 rows', '25 rows', '50 rows', '100 rows', 'Show all']]
  });

  // Initialize DataTable for Invoice Table
  $('#invoiceTable').DataTable({
    responsive: true,
    lengthChange: true,
    fixedHeader: true,
    order: [[0, 'desc']],
    lengthMenu: [[15, 25, 50, 100, -1], ['15 rows', '25 rows', '50 rows', '100 rows', 'Show all']]
  });

  // Initialize DataTable for Summary Table
  $('#summaryTable').DataTable({
    responsive: true,
    lengthChange: true,
    fixedHeader: true,
    order: [[0, 'desc']],
    lengthMenu: [[15, 25, 50, 100, -1], ['15 rows', '25 rows', '50 rows', '100 rows', 'Show all']]
  });

  // Filter table rows based on search input
  $('#searchInput').on('keyup', function () {
    var value = $(this).val().toLowerCase();
    $('#customModal table tbody tr').filter(function () {
      $(this).toggle($(this).text().toLowerCase().indexOf(value) > -1);
    });
  });
});

// Timer for displaying the current time
var myVar = setInterval(myTimer, 1000);
function myTimer() {
  var d = new Date();
  var tt = d.toLocaleTimeString();
  document.getElementById("time").innerHTML = tt;
}

// Modal open/close
$(document).on('click', '#findButton', function() {
  $("#customModal").show();
});
$(document).on('click', '#closeModal', function() {
  $("#customModal").hide();
});
$(window).on('click', function(event) {
  if (event.target == document.getElementById("customModal")) {
    $("#customModal").hide();
  }
});

// Save function
function save_inv(event) {
  event.preventDefault();
  
  var ref_no = [], collect = [], remark = [];
  $("input[name='ref_no[]']").each(function() { ref_no.push($(this).val()); });
  $("input[name='collect[]']").each(function() { collect.push($(this).val()); });
  $("input[name='remark[]']").each(function() { remark.push($(this).val()); });
  var data = {
    action: 'save',
    ref_no: ref_no,
    collect: collect,
    remark: remark,
    sdate1: $('#s_date').val(),
    c_code: $('#firstname_hidden').val(),
    cus_name: $('#firstname').val(),
    sal_ex: $('#sal_ex').val(),
  };
  $.ajax({
    type: 'POST',
    url: 'collection_assign_data_save.php',
    data: data,
    success: function(response) {
      alert(response);
      var ref_no_summary = [], collect_summary = [], remark_summary = [];
      $("input[name='ref_no_summary[]']").each(function() { ref_no_summary.push($(this).val()); });
      $("input[name='collect_summary[]']").each(function() { collect_summary.push($(this).val()); });
      $("input[name='remark_summary[]']").each(function() { remark_summary.push($(this).val()); });
      var summary_data = {
        action: 'summary_save',
        ref_no: ref_no_summary,
        collect: collect_summary,
        remark: remark_summary,
        sdate1: $('#s_date').val(),
        c_code: $('#firstname_hidden').val(),
        cus_name: $('#firstname').val(),
        sal_ex: $('#sal_ex').val(),
      };
      $.ajax({
        type: 'POST',
        url: 'collection_assign_data_save.php',
        data: summary_data,
        success: function(response) {
          window.location.reload();
        },
        error: function(xhr, status, error) {
          console.log("Error: " + error);
          alert("There was an error saving the data. Please try again.");
        }
      });
    },
    error: function(xhr, status, error) {
      console.log("Error: " + error);
      alert("There was an error saving the data. Please try again.");
    }
  });
}

// Customer modal row click
function custno(cuscode, stname) {
  var row = event.target.closest('tr');
  var customerCode = row.cells[0].innerText;
  var customerName = row.cells[1].innerText;
  var customerAddress = row.cells[2].innerText;
  var customerPhone = row.cells[3].innerText;
  var subCustomerCode = row.cells[4].innerText;
  document.getElementById('firstname_hidden').value = customerCode;
  document.getElementById('firstname').value = customerName;
  custno_ind(customerCode);
  custno_ind_salmas(customerCode);
  setTimeout(function () {
    document.getElementById('customModal').style.display = "none";
  }, 500);
}

function custno_ind(customerCode) {
  var customer_id = customerCode;
  if (customer_id != '') {
    $.ajax({
      type: "POST",
      url: "collection_assign_data.php",
      data: {
        action: 'cheq',
        firstname_hidden: customer_id,
        sal_ex: $('#sal_ex').val()
      },
      success: function (response) {
        $("#invoiceTable tbody").html(response);
      },
      error: function () {
        alert('Error fetching data.');
      }
    });
  } else {
    alert('Please enter a customer code.');
  }
}

function custno_ind_salmas(customerCode) {
  var customer_id = customerCode;
  if (customer_id != '') {
    $.ajax({
      type: "POST",
      url: "collection_assign_data.php",
      data: {
        action: 'salmas',
        firstname_hidden: customer_id,
        sal_ex: $('#sal_ex').val()
      },
      success: function (response) {
        $("#summaryTable tbody").html(response);
      },
      error: function () {
        alert('Error fetching data.');
      }
    });
  } else {
    alert('Please enter a customer code.');
  }
}
