function GetXmlHttpObject() {
    var xmlHttp = null;
    try {
        // Firefox, Opera 8.0+, Safari
        xmlHttp = new XMLHttpRequest();
    } catch (e) {
// Internet Explorer
try {
    xmlHttp = new ActiveXObject("Msxml2.XMLHTTP");
} catch (e) {
    xmlHttp = new ActiveXObject("Microsoft.XMLHTTP");
}
}
return xmlHttp;
}

// Wait for DOM to be ready before adding event listener
document.addEventListener("DOMContentLoaded", function() {
    var wage = document.getElementById("stk_no");
    if (wage) {
        wage.addEventListener("keydown", function (e) {
            if (e.keyCode === 13) {  //checks whether the pressed key is "Enter"
                load_item();
            }
        });
    }
});



function search() {
    console.log("Search button clicked"); // Debug
    console.log("jQuery available:", typeof $ !== 'undefined'); // Debug
    console.log("Modal function available:", typeof $.fn !== 'undefined' && typeof $.fn.modal !== 'undefined'); // Debug
    
    if (typeof $ !== 'undefined' && $.fn.modal) {
        $('#myModal_search').modal('show');
        console.log("Modal show called"); // Debug
        
        setTimeout(function() {
            var searchInput = document.getElementById('sstk_no');
            console.log("Search input element:", searchInput); // Debug
            
            if (searchInput) {
                searchInput.focus();
                console.log("Focus set on search input"); // Debug
            }
            
            // Load initial results when modal opens
            console.log("Calling search_itm"); // Debug
            search_itm('');
        }, 500);
    } else {
        console.error('jQuery or Bootstrap modal not loaded');
        alert('Error: Required libraries not loaded. Please refresh the page.');
    }
}



function search_itm(cdata) {

    xmlHttp = GetXmlHttpObject();
    if (xmlHttp == null) {
        alert("Browser does not support HTTP Request");
        return;
    }

    // Show loading message
    var searchResElement = document.getElementById('search_res');
    if (searchResElement) {
        searchResElement.innerHTML = '<div class="text-center"><i class="fa fa-spinner fa-spin"></i> Loading items...</div>';
    }

    var url = "search_item_data.php";
    url = url + "?Command=" + "search_itm";

    // Get values with fallback to empty string
    var stkNo = document.getElementById('sstk_no') ? document.getElementById('sstk_no').value : '';
    var descript = document.getElementById('sdescript') ? document.getElementById('sdescript').value : '';
    var brand = document.getElementById('sbrand') ? document.getElementById('sbrand').value : '';
    var cmbbrand = document.getElementById('cmbbrand') ? document.getElementById('cmbbrand').value : 'All';
    
    url = url + "&stk_no=" + encodeURIComponent(stkNo);
    url = url + "&descript=" + encodeURIComponent(descript);
    url = url + "&mtype=" + encodeURIComponent(cdata);
    url = url + "&brand=" + encodeURIComponent(brand);
    url = url + "&cmbbrand=" + encodeURIComponent(cmbbrand);

    if (document.getElementById('chk_stockall') && document.getElementById('chk_stockall').checked == true) {
        url = url + "&chk_stockall=1";
    } else {
        url = url + "&chk_stockall=0";
    }
    if (document.getElementById('chk_stock') && document.getElementById('chk_stock').checked == true) {
        url = url + "&chk_stock=1";
    } else {
        url = url + "&chk_stock=0";
    }
    
    console.log("Search URL:", url); // Debug log
    console.log("Full URL:", window.location.origin + "/" + url); // Debug log
    
    xmlHttp.onreadystatechange = showresultsearch;
    xmlHttp.onerror = function() {
        console.error("Network error occurred");
        if (searchResElement) {
            searchResElement.innerHTML = '<div class="alert alert-danger">Network error. Check console for details.</div>';
        }
    };
    xmlHttp.open("GET", url, true);
    xmlHttp.send(null);

}


function showresultsearch() {
    console.log("ReadyState:", xmlHttp.readyState); // Debug log
    
    if (xmlHttp.readyState == 4 || xmlHttp.readyState == "complete") {
        console.log("Search response status:", xmlHttp.status); // Debug log
        console.log("Search response text length:", xmlHttp.responseText.length); // Debug log
        console.log("Search response (first 500 chars):", xmlHttp.responseText.substring(0, 500)); // Debug log
        
        var searchResElement = document.getElementById('search_res');
        if (searchResElement) {
            if (xmlHttp.status == 200) {
                if (xmlHttp.responseText && xmlHttp.responseText.trim() != '') {
                    searchResElement.innerHTML = xmlHttp.responseText;
                    console.log("Results displayed successfully");
                } else {
                    searchResElement.innerHTML = '<div class="alert alert-warning">No items found</div>';
                    console.log("Empty response received");
                }
            } else {
                searchResElement.innerHTML = '<div class="alert alert-danger">Error loading items. Status: ' + xmlHttp.status + '</div>';
                console.error("HTTP Error:", xmlHttp.status, xmlHttp.statusText);
            }
        } else {
            console.error("Element 'search_res' not found");
        }
    }
}



function get_itm(cdata) {
    if (typeof $ !== 'undefined' && $.fn.modal) {
        $('#myModal_search').modal('hide');
    }

    document.getElementById('stk_no').value = cdata;

    load_item();
}


function load_item() {

    document.getElementById('descript').value = "";
    document.getElementById('selling').value = "";
    document.getElementById('part_no').value = "";
    document.getElementById('itemdetails1').innerHTML = "";
    document.getElementById('itemdetails2').innerHTML = "";
    document.getElementById('itemdetails').innerHTML = "Please Wait...";
    document.getElementById('day90').innerHTML = "";
    document.getElementById('unsold').innerHTML = "";
    document.getElementById('stk').innerHTML = "";
    document.getElementById('stkinhand').innerHTML = "";
    document.getElementById('active').innerHTML = "";


    if (document.getElementById('stk_no').value == "") {
        document.getElementById('itemdetails').innerHTML = "";
        return false;
    }

    xmlHttp = GetXmlHttpObject();
    if (xmlHttp == null) {
        alert("Browser does not support HTTP Request");
        return;
    }

    var url = "search_item_data.php";
    url = url + "?Command=" + "get_itm";

    url = url + "&stk_no=" + document.getElementById('stk_no').value;

    if (document.getElementById('chk_trns').checked == true) {
        url = url + "&chk_trns=1";
    } else {
        url = url + "&chk_trns=0";
    }
    url = url + "&dte_from=" + document.getElementById('dtfrom').value;
    url = url + "&yer=" + document.getElementById('yer').value;

    url = url + "&department=" + document.getElementById('to_dep').value;


    xmlHttp.onreadystatechange = showresultsearch_itm;
    xmlHttp.open("GET", url, true);
    xmlHttp.send(null);






}


function showresultsearch_itm() {


    var XMLAddress1;
    if (xmlHttp.readyState == 4 || xmlHttp.readyState == "complete") {

        document.getElementById('msg_box').innerHTML = "";

        XMLAddress1 = xmlHttp.responseXML.getElementsByTagName("stat");
        if (XMLAddress1[0].childNodes[0].nodeValue == "1") {

            XMLAddress1 = xmlHttp.responseXML.getElementsByTagName("STK_NO");
            document.getElementById('stk_no').value = XMLAddress1[0].childNodes[0].nodeValue;


            XMLAddress1 = xmlHttp.responseXML.getElementsByTagName("DESCRIPT");
            document.getElementById('descript').value = XMLAddress1[0].childNodes[0].nodeValue;

            XMLAddress1 = xmlHttp.responseXML.getElementsByTagName("SELLING");
            document.getElementById('selling').value = XMLAddress1[0].childNodes[0].nodeValue;

            XMLAddress1 = xmlHttp.responseXML.getElementsByTagName("PART_NO");
            document.getElementById('part_no').value = XMLAddress1[0].childNodes[0].nodeValue;

            XMLAddress1 = xmlHttp.responseXML.getElementsByTagName("sales_table");
            document.getElementById('itemdetails1').innerHTML = XMLAddress1[0].childNodes[0].nodeValue;

            XMLAddress1 = xmlHttp.responseXML.getElementsByTagName("ord_table");
            document.getElementById('itemdetails2').innerHTML = XMLAddress1[0].childNodes[0].nodeValue;


            XMLAddress1 = xmlHttp.responseXML.getElementsByTagName("bin_table");
            document.getElementById('itemdetails').innerHTML = XMLAddress1[0].childNodes[0].nodeValue;

            XMLAddress1 = xmlHttp.responseXML.getElementsByTagName("consum");
            document.getElementById('consum').innerHTML = XMLAddress1[0].childNodes[0].nodeValue;


            document.getElementById('pending').innerHTML = "";

            XMLAddress1 = xmlHttp.responseXML.getElementsByTagName("pending");
            if (XMLAddress1[0].childNodes[0].nodeValue != 0) {
                document.getElementById('pending').innerHTML = "<span class='label labels125 label-danger'>Pending AR Qty = " + XMLAddress1[0].childNodes[0].nodeValue + "</span>";
            }


            XMLAddress1 = xmlHttp.responseXML.getElementsByTagName("unsold");
            if (XMLAddress1[0].childNodes[0].nodeValue != "0") {
                document.getElementById('day90').innerHTML = "<span class='label labels125 label-danger'>Over 90 Stock</span>";
                document.getElementById('unsold').innerHTML = "<span class='label labels125 label-danger'>" + XMLAddress1[0].childNodes[0].nodeValue + "</span>";
            } else {
                document.getElementById('day90').innerHTML = "";
                document.getElementById('unsold').innerHTML = "";
            }



            XMLAddress1 = xmlHttp.responseXML.getElementsByTagName("qtyinhand");
            if (XMLAddress1[0].childNodes[0].nodeValue != "0") {
                document.getElementById('stk').innerHTML = "<span class='label labels125 label-primary'>Stock in Hand</span>";
                document.getElementById('stkinhand').innerHTML = "<span class='label labels125 label-primary'>" + XMLAddress1[0].childNodes[0].nodeValue + "</span>";
            } else {
                document.getElementById('stk').innerHTML = "";
                document.getElementById('stkinhand').innerHTML = "";
            }



            XMLAddress1 = xmlHttp.responseXML.getElementsByTagName("active_t");
            if (XMLAddress1[0].childNodes[0].nodeValue != "0") {
                document.getElementById('active').innerHTML = "<span class='label labels125 label-danger'>Item Locked</span>";

            } else {
                document.getElementById('active').innerHTML = "";

            }
        } else {
            document.getElementById('msg_box').innerHTML = "<div class='alert alert-warning' role='alert'><span class='center-block'>Please Check Item Code</span></div>";
            document.getElementById('itemdetails').innerHTML = "";

        }

    }






}

function print_inv() {


    var url = "bincard" + document.getElementById('stk_no').value;
    window.open(url, '_blank');




}


function print_inv1() {


    var url = "report_sup_card_print.php?invno=" + document.getElementById('stk_no').value;
    window.open(url, '_blank');




}


function cal() {

    xmlHttp = GetXmlHttpObject();
    if (xmlHttp == null) {
        alert("Browser does not support HTTP Request");
        return;
    }


    var url = "search_item_data.php";
    url = url + "?Command=" + "calcu";

    url = url + "&dis1=" + document.getElementById('dis1').value;

    url = url + "&dis2=" + document.getElementById('dis2').value;

    url = url + "&sal=" + document.getElementById('selling').value;


    xmlHttp.onreadystatechange = calq;
    xmlHttp.open("GET", url, true);
    xmlHttp.send(null);
}

function calq() {


    var XMLAddress1;

    XMLAddress1 = xmlHttp.responseXML.getElementsByTagName("toot");
    document.getElementById('tot').value = XMLAddress1[0].childNodes[0].nodeValue;

}