let barChart = null; // Store the chart instance globally

document.addEventListener("DOMContentLoaded", function () {
    const currentDate = new Date();
    const currentMonth = currentDate.getMonth() + 1;
    const currentYear = currentDate.getFullYear();

    document.getElementById('bar-month-select').value = currentMonth;
    document.getElementById('bar-year-select').value = currentYear;

    filterBarChart();
});

function filterBarChart() {
    const month = document.getElementById('bar-month-select').value;
    const year = document.getElementById('bar-year-select').value;

    if (month && year) {
        fetch(`barchart_data.php?month=${month}&year=${year}`)
            .then(response => response.json())
            .then(data => {
                const barChartData = data.barChartData || [];
                const userType = ('userType' in data) ? data.userType : null;

                const chartContainer = document.getElementById('bar-chart-container');
                const noDataMessage = document.getElementById('bar-no-data-message');
                const barChartElement = document.querySelector('#bar-chart');

                if (barChartData.length === 0) {
                    chartContainer.style.display = 'none';
                    noDataMessage.style.display = 'block';
                    return;
                }

                noDataMessage.style.display = 'none';
                chartContainer.style.display = 'block';

                // --- DASH3 STYLE BAR CHART ---
                const barChartOptions = {
                    series: [{ name: 'Total Sales', data: barChartData.map(item => item.value) }],
                    chart: { type: 'bar', height: 350, toolbar: { show: false } },
                    colors: ['#246dec', '#cc3c43', '#367952', '#f5b74f', '#4f35a1', '#ff5733', '#33ff57', '#3357ff', '#ff33a1', '#a133ff'],
                    plotOptions: {
                        bar: {
                            distributed: true,
                            borderRadius: 4,
                            horizontal: false,
                            columnWidth: '40%'
                        }
                    },
                    dataLabels: { enabled: false },
                    legend: { show: false },
                    xaxis: {
                        categories: barChartData.map(item => item.label),
                        labels: { rotate: -45 }
                    },
                    yaxis: { title: { text: 'Total Sales' } },
                };
                // --- END DASH3 STYLE ---

                if (barChart) {
                    barChart.destroy();
                }

                barChart = new ApexCharts(barChartElement, barChartOptions);
                barChart.render();
            })
            .catch(error => console.error('Error fetching bar chart data:', error));
    } else {
        alert('Please select both month and year.');
    }
}
