document.addEventListener("DOMContentLoaded", function () {
    fetch('areachart_data.php')
        .then(response => response.json())
        .then(data => {
            const salesData = data.salesData || {};
            const totalTargetValue = data.totalTargetValue || 0;
            const userType = typeof data.userType === 'number' ? data.userType : 0; // 👈 FIXED

            function getDaysInMonth(month, year) {
                return new Date(year, month, 0).getDate();
            }

            function getDaysArray(daysInMonth, isCurrentMonth = false) {
                const today = new Date().getDate();
                const limit = isCurrentMonth ? today : daysInMonth;
                return Array.from({ length: limit }, (_, i) => i + 1);
            }

            function getAreaChartDataForMonth(month, year, data) {
                const daysInMonth = getDaysInMonth(month, year);
                const isCurrentMonth = month === new Date().getMonth() + 1 && year === new Date().getFullYear();
                let cumulativeValue = 0;
                let maxSales = 0;

                const salesArray = getDaysArray(daysInMonth, isCurrentMonth).map(day => {
                    const dateString = `${year}-${String(month).padStart(2, '0')}-${String(day).padStart(2, '0')}`;
                    if (data[dateString]) {
                        cumulativeValue = data[dateString];
                    }
                    maxSales = Math.max(maxSales, cumulativeValue);
                    return cumulativeValue;
                });

                const hasSales = salesArray.some(value => value > 0);
                if (!hasSales) {
                    return { salesArray: Array(daysInMonth).fill(0), maxSales: 10 };
                }

                return { salesArray, maxSales };
            }

            function getMaxYValue(maxSales, targetValue) {
                const maxVal = Math.max(maxSales, targetValue, 10);
                return Math.ceil(maxVal / 10) * 10;
            }

            const defaultMonth = parseInt(document.getElementById('month-dropdown').value);
            const defaultYear = parseInt(document.getElementById('year-dropdown').value);
            const isCurrentMonth = defaultMonth === new Date().getMonth() + 1 && defaultYear === new Date().getFullYear();
            const daysInMonth = getDaysInMonth(defaultMonth, defaultYear);
            const xAxisCategories = getDaysArray(daysInMonth, isCurrentMonth);

            const { salesArray, maxSales } = getAreaChartDataForMonth(defaultMonth, defaultYear, salesData);
            const maxYValue = getMaxYValue(maxSales, totalTargetValue);

            const areaChartOptions = {
                series: [
                    { name: 'Total Sales', data: salesArray },
                    ...(userType !== 1
                        ? [{ name: 'Target', data: Array(xAxisCategories.length).fill(totalTargetValue) }]
                        : [])
                ],
                chart: { type: 'area', height: 350 },
                xaxis: {
                    categories: xAxisCategories,
                    labels: {
                        formatter: function (value) {
                            return value;
                        }
                    }
                },
                yaxis: {
                    min: 0,
                    max: maxYValue,
                    labels: {
                        formatter: function (value) {
                            return Math.round(value);
                        }
                    }
                },
                colors: ['#246dec', '#ff4560'],
                dataLabels: { enabled: false },
                stroke: { curve: 'smooth' }
            };

            const areaChart = new ApexCharts(document.querySelector('#area-chart'), areaChartOptions);
            areaChart.render();

            function updateAreaChart() {
                const month = parseInt(document.getElementById('month-dropdown').value);
                const year = parseInt(document.getElementById('year-dropdown').value);

                fetch(`areachart_data.php?month=${month}&year=${year}`)
                    .then(response => response.json())
                    .then(data => {
                        const salesData = data.salesData || {};
                        const totalTargetValue = data.totalTargetValue || 0;
                        const userType = typeof data.userType === 'number' ? data.userType : 0; // 👈 FIXED

                        const daysInMonth = getDaysInMonth(month, year);
                        const isCurrentMonth = month === new Date().getMonth() + 1 && year === new Date().getFullYear();
                        const xAxisCategories = getDaysArray(daysInMonth, isCurrentMonth);
                        const { salesArray, maxSales } = getAreaChartDataForMonth(month, year, salesData);
                        const maxYValue = getMaxYValue(maxSales, totalTargetValue);

                        areaChart.updateSeries([
                            {
                                name: 'Total Sales',
                                data: salesArray.slice(0, xAxisCategories.length)
                            },
                            ...(userType !== 1
                                ? [{
                                    name: 'Target',
                                    data: Array(xAxisCategories.length).fill(totalTargetValue)
                                }]
                                : [])
                        ]);

                        areaChart.updateOptions({
                            xaxis: {
                                categories: xAxisCategories,
                                labels: {
                                    formatter: function (value) {
                                        return value;
                                    }
                                }
                            },
                            yaxis: {
                                min: 0,
                                max: maxYValue,
                                labels: {
                                    formatter: function (value) {
                                        return Math.round(value);
                                    }
                                }
                            }
                        });
                    })
                    .catch(error => console.error("Error fetching updated data:", error));
            }

            document.getElementById('month-dropdown').addEventListener('change', updateAreaChart);
            document.getElementById('year-dropdown').addEventListener('change', updateAreaChart);
        })
        .catch(error => console.error('Error fetching data:', error));
});


// ========== Second Area Chart ==========

// document.addEventListener("DOMContentLoaded", function () {
//     fetch('areachart_data.php')
//         .then(response => response.json())
//         .then(data => {
//             const salesData = data.salesData || {};
//             const totalTargetValue = data.totalTargetValue || 0;
//             const userType = typeof data.userType === 'number' ? data.userType : 0; // 👈 FIXED

//             function getDaysInMonth(month, year) {
//                 return new Date(year, month, 0).getDate();
//             }

//             function getDaysArray(daysInMonth, isCurrentMonth = false) {
//                 const today = new Date().getDate();
//                 const limit = isCurrentMonth ? today : daysInMonth;
//                 return Array.from({ length: limit }, (_, i) => i + 1);
//             }

//             function getAreaChartDataForMonth(month, year, data) {
//                 const daysInMonth = getDaysInMonth(month, year);
//                 const isCurrentMonth = month === new Date().getMonth() + 1 && year === new Date().getFullYear();
//                 let cumulativeValue = 0;
//                 let maxSales = 0;

//                 const salesArray = getDaysArray(daysInMonth, isCurrentMonth).map(day => {
//                     const dateString = `${year}-${String(month).padStart(2, '0')}-${String(day).padStart(2, '0')}`;
//                     if (data[dateString]) {
//                         cumulativeValue = data[dateString];
//                     }
//                     maxSales = Math.max(maxSales, cumulativeValue);
//                     return cumulativeValue;
//                 });

//                 const hasSales = salesArray.some(value => value > 0);
//                 if (!hasSales) {
//                     return { salesArray: Array(daysInMonth).fill(0), maxSales: 10 };
//                 }

//                 return { salesArray, maxSales };
//             }

//             function getMaxYValue(maxSales, targetValue) {
//                 const maxVal = Math.max(maxSales, targetValue, 10);
//                 return Math.ceil(maxVal / 10) * 10;
//             }

//             const defaultMonth = parseInt(document.getElementById('month-dropdown').value);
//             const defaultYear = parseInt(document.getElementById('year-dropdown').value);

//             const { salesArray, maxSales } = getAreaChartDataForMonth(defaultMonth, defaultYear, salesData);
//             const maxYValue = getMaxYValue(maxSales, totalTargetValue);

//             const areaChartOptions = {
//                 series: [
//                     { name: 'Total Sales', data: salesArray },
//                     ...(userType !== 1
//                         ? [{ name: 'Target', data: Array(getDaysArray(getDaysInMonth(defaultMonth, defaultYear)).length).fill(totalTargetValue) }]
//                         : [])
//                 ],
//                 chart: { type: 'area', height: 350 },
//                 xaxis: { categories: getDaysArray(getDaysInMonth(defaultMonth, defaultYear)) },
//                 yaxis: {
//                     min: 0,
//                     max: maxYValue,
//                     labels: {
//                         formatter: function (value) {
//                             return Math.round(value);
//                         }
//                     }
//                 },
//                 colors: ['#246dec', '#ff4560'],
//                 dataLabels: { enabled: false },
//                 stroke: { curve: 'smooth' }
//             };

//             const areaChart = new ApexCharts(document.querySelector('#area-chart'), areaChartOptions);
//             areaChart.render();

//             function updateAreaChart() {
//                 const month = parseInt(document.getElementById('month-dropdown').value);
//                 const year = parseInt(document.getElementById('year-dropdown').value);

//                 fetch(`areachart_data.php?month=${month}&year=${year}`)
//                     .then(response => response.json())
//                     .then(data => {
//                         const salesData = data.salesData || {};
//                         const totalTargetValue = data.totalTargetValue || 0;
//                         const userType = typeof data.userType === 'number' ? data.userType : 0; // 👈 FIXED

//                         const daysInMonth = getDaysInMonth(month, year);
//                         const isCurrentMonth = month === new Date().getMonth() + 1 && year === new Date().getFullYear();
//                         const { salesArray, maxSales } = getAreaChartDataForMonth(month, year, salesData);
//                         const maxYValue = getMaxYValue(maxSales, totalTargetValue);
//                         const xAxisCategories = getDaysArray(daysInMonth, isCurrentMonth);

//                         areaChart.updateSeries([
//                             {
//                                 name: 'Total Sales',
//                                 data: salesArray.slice(0, xAxisCategories.length)
//                             },
//                             ...(userType !== 1
//                                 ? [{
//                                     name: 'Target',
//                                     data: Array(xAxisCategories.length).fill(totalTargetValue)
//                                 }]
//                                 : [])
//                         ]);

//                         areaChart.updateOptions({
//                             xaxis: {
//                                 categories: xAxisCategories,
//                                 labels: {
//                                     formatter: function (value) {
//                                         return value;
//                                     }
//                                 }
//                             },
//                             yaxis: {
//                                 min: 0,
//                                 max: maxYValue,
//                                 labels: {
//                                     formatter: function (value) {
//                                         return Math.round(value);
//                                     }
//                                 }
//                             }
//                         });
//                     })
//                     .catch(error => console.error("Error fetching updated data:", error));
//             }

//             document.getElementById('month-dropdown').addEventListener('change', updateAreaChart);
//             document.getElementById('year-dropdown').addEventListener('change', updateAreaChart);
//         })
//         .catch(error => console.error('Error fetching data:', error));
// });
