<?php
session_start();
date_default_timezone_set('Asia/Colombo');

// Check if user is logged in
if (!isset($_SESSION["CURRENT_USER"]) || $_SESSION["CURRENT_USER"] == "") {
    echo "Please Login Again !!!";
    exit();
}

require_once("connectioni.php");
$conn = $GLOBALS['dbinv'];

// Fetch sales reps based on user role
$reps = [];
if (isset($_SESSION["MANAGER"]) && $_SESSION["MANAGER"] != "") {
    // Manager: Show only their team members
    $sql = "SELECT * FROM s_salrep WHERE (company='T' OR company='C') AND cancel='1' AND manager='" . mysqli_real_escape_string($conn, $_SESSION["MANAGER"]) . "' ORDER BY REPCODE";
} else if (!isset($_SESSION["CURRENT_REP"]) || $_SESSION["CURRENT_REP"] == "") {
    // Admin: Show all sales reps
    $sql = "SELECT * FROM s_salrep WHERE (company='T' OR company='C') AND cancel='1' ORDER BY REPCODE";
} else {
    // Regular user: Show only their own code
    $sql = "SELECT * FROM s_salrep WHERE (company='T' OR company='C') AND cancel='1' AND repcode = '" . mysqli_real_escape_string($conn, $_SESSION["CURRENT_REP"]) . "' ORDER BY REPCODE";
}

$result = mysqli_query($conn, $sql);
if ($result && mysqli_num_rows($result) > 0) {
    while($row = mysqli_fetch_assoc($result)) {
        $reps[] = $row;
    }
}

// Handle filters
$filters = [
    'sal_ex' => isset($_POST['sal_ex']) ? trim($_POST['sal_ex']) : '',
    'start_date' => isset($_POST['start_date']) ? $_POST['start_date'] : '',
    'end_date' => isset($_POST['end_date']) ? $_POST['end_date'] : '',
    'town' => isset($_POST['town']) ? trim($_POST['town']) : '',
    'area' => isset($_POST['area']) ? trim($_POST['area']) : '',
    'enable' => isset($_POST['enable']) ? $_POST['enable'] : 'all'
];

$data = [];
$total_rows = 0;

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    // Build query
    $sql = "SELECT i.*, s.Name as rep_name 
            FROM s_itinery i
            LEFT JOIN s_salrep s ON i.sal_ex = s.REPCODE
            WHERE 1=1";

    // Apply role-based filtering
    if (isset($_SESSION["MANAGER"]) && $_SESSION["MANAGER"] != "") {
        // Manager: Filter by their team
        $sql .= " AND s.manager = '" . mysqli_real_escape_string($conn, $_SESSION["MANAGER"]) . "'";
    } else if (isset($_SESSION["CURRENT_REP"]) && $_SESSION["CURRENT_REP"] != "") {
        // Regular user: Filter by their own code
        $sql .= " AND i.sal_ex = '" . mysqli_real_escape_string($conn, $_SESSION["CURRENT_REP"]) . "'";
    }

    // Date range filter
    if (!empty($filters['start_date']) && !empty($filters['end_date'])) {
        $sql .= " AND ((i.sdate BETWEEN '" . mysqli_real_escape_string($conn, $filters['start_date']) . "' 
                      AND '" . mysqli_real_escape_string($conn, $filters['end_date']) . "')
                   OR (i.entdate BETWEEN '" . mysqli_real_escape_string($conn, $filters['start_date']) . "' 
                      AND '" . mysqli_real_escape_string($conn, $filters['end_date']) . "')
                   OR (i.sdate <= '" . mysqli_real_escape_string($conn, $filters['start_date']) . "' 
                      AND i.entdate >= '" . mysqli_real_escape_string($conn, $filters['end_date']) . "'))";
    }

    // Sales executive filter
    if (!empty($filters['sal_ex'])) {
        $sql .= " AND i.sal_ex = '" . mysqli_real_escape_string($conn, $filters['sal_ex']) . "'";
    }

    // Town filter
    if (!empty($filters['town'])) {
        $sql .= " AND i.Town = '" . mysqli_real_escape_string($conn, $filters['town']) . "'";
    }

    // Area filter
    if (!empty($filters['area'])) {
        $sql .= " AND i.Area = '" . mysqli_real_escape_string($conn, $filters['area']) . "'";
    }

    // Enable filter
    if ($filters['enable'] === '1' || $filters['enable'] === '0') {
        $sql .= " AND i.Enable = " . intval($filters['enable']);
    }

    $sql .= " ORDER BY i.sdate DESC, i.sal_ex, i.Town";

    $result = mysqli_query($conn, $sql);
    if ($result) {
        while($row = mysqli_fetch_assoc($result)) {
            $data[] = $row;
        }
        $total_rows = count($data);
    }
}

// Calculate unique counts for summary (PHP 5.x compatible)
$unique_reps = array();
$unique_towns = array();
foreach ($data as $row) {
    if (!empty($row['sal_ex'])) {
        $unique_reps[$row['sal_ex']] = true;
    }
    if (!empty($row['Town'])) {
        $unique_towns[$row['Town']] = true;
    }
}
$unique_reps_count = count($unique_reps);
$unique_towns_count = count($unique_towns);

// Get distinct towns for filter
$towns = [];
$town_result = mysqli_query($conn, "SELECT DISTINCT Town FROM s_itinery WHERE Town IS NOT NULL AND Town != '' ORDER BY Town");
if ($town_result) {
    while($row = mysqli_fetch_assoc($town_result)) {
        $towns[] = $row['Town'];
    }
}

// Get distinct areas for filter
$areas = [];
$area_result = mysqli_query($conn, "SELECT DISTINCT Area FROM s_itinery WHERE Area IS NOT NULL AND Area != '' ORDER BY Area");
if ($area_result) {
    while($row = mysqli_fetch_assoc($area_result)) {
        $areas[] = $row['Area'];
    }
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
<title>Daily Itinerary Report</title>
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/css/bootstrap.min.css" rel="stylesheet">
<link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css" rel="stylesheet">
<style>
    body { 
        background-color: #f8f9fa; 
        font-family: Arial, sans-serif;
    }
    .report-header {
        background: linear-gradient(135deg, #2c3e50 0%, #3498db 100%);
        color: white;
        padding: 2rem 0;
        margin-bottom: 2rem;
    }
    .summary-card { 
        border: none; 
        border-radius: 12px; 
        box-shadow: 0 3px 10px rgba(0,0,0,0.08); 
        transition: transform 0.2s;
    }
    .summary-card:hover {
        transform: translateY(-5px);
    }
    .report-table { 
        box-shadow: 0 0 20px rgba(0,0,0,0.06); 
        background: white;
    }
    .table thead th {
        background: #2c3e50;
        color: white;
        border: none;
        padding: 12px;
    }
    .badge-active {
        background-color: #27ae60;
    }
    .badge-inactive {
        background-color: #e74c3c;
    }
    @media print { 
        .no-print { display: none; } 
        body { background-color: #fff; }
        .table { font-size: 11px; }
    }
</style>
</head>
<body>
<div class="report-header">
  <div class="container">
    <div class="row align-items-center">
      <div class="col-md-8">
        <h1><i class="fas fa-map-marked-alt me-2"></i>Daily Itinerary Report</h1>
        <p class="lead mb-0">Sales Representative Itinerary Overview</p>
      </div>
      <div class="col-md-4 text-end">
        <a href="in.php" class="btn btn-info btn-sm me-2 no-print">
          <i class="fas fa-arrow-left me-1"></i>Back to Itinerary
        </a>
        <button onclick="window.print()" class="btn btn-light btn-sm no-print">
          <i class="fas fa-print me-1"></i>Print Report
        </button>
      </div>
    </div>
  </div>
</div>

<div class="container">
  <!-- Filters -->
  <div class="card mb-4 no-print">
    <div class="card-header bg-primary text-white">
      <h5 class="mb-0"><i class="fas fa-filter me-2"></i>Filter Report</h5>
    </div>
    <div class="card-body">
      <form method="POST" class="row g-3">
        <div class="col-md-3">
          <label for="sal_ex" class="form-label">Sales Representative</label>
          <select class="form-select" id="sal_ex" name="sal_ex">
            <option value="">All</option>
            <?php foreach ($reps as $rep): ?>
              <option value="<?= htmlspecialchars($rep['REPCODE']) ?>" <?= (!empty($filters['sal_ex']) && $filters['sal_ex'] === $rep['REPCODE']) ? 'selected' : '' ?>>
                <?= htmlspecialchars($rep['REPCODE']) ?> - <?= htmlspecialchars($rep['Name']) ?>
              </option>
            <?php endforeach; ?>
          </select>
        </div>
        <div class="col-md-2">
          <label for="start_date" class="form-label">Start Date</label>
          <input type="date" class="form-control" id="start_date" name="start_date" value="<?= htmlspecialchars($filters['start_date']) ?>" required>
        </div>
        <div class="col-md-2">
          <label for="end_date" class="form-label">End Date</label>
          <input type="date" class="form-control" id="end_date" name="end_date" value="<?= htmlspecialchars($filters['end_date']) ?>" required>
        </div>
        <!--<div class="col-md-2">
          <label for="town" class="form-label">Town</label>
          <select class="form-select" id="town" name="town">
            <option value="">All</option>
            <?php foreach ($towns as $town): ?>
              <option value="<?= htmlspecialchars($town) ?>" <?= (!empty($filters['town']) && $filters['town'] === $town) ? 'selected' : '' ?>>
                <?= htmlspecialchars($town) ?>
              </option>
            <?php endforeach; ?>
          </select>
        </div>
        <div class="col-md-2">
          <label for="area" class="form-label">Area</label>
          <select class="form-select" id="area" name="area">
            <option value="">All</option>
            <?php foreach ($areas as $area): ?>
              <option value="<?= htmlspecialchars($area) ?>" <?= (!empty($filters['area']) && $filters['area'] === $area) ? 'selected' : '' ?>>
                <?= htmlspecialchars($area) ?>
              </option>
            <?php endforeach; ?>
          </select>
        </div>-->
        
        <div class="col-md-12 d-flex justify-content-end">
          <button type="submit" class="btn btn-success"><i class="fas fa-chart-bar me-1"></i>Generate Report</button>
        </div>
      </form>
    </div>
  </div>

  <?php if ($_SERVER['REQUEST_METHOD'] === 'POST'): ?>
    <?php if (!empty($data)): ?>
      <!-- Summary -->
      <div class="row mb-4">
        <div class="col-md-4 mb-3">
          <div class="card summary-card text-center bg-light">
            <div class="card-body">
              <i class="fas fa-list-ol fa-2x text-primary mb-2"></i>
              <h4 class="card-title"><?= number_format($total_rows) ?></h4>
              <p class="card-text text-muted">Total Records</p>
            </div>
          </div>
        </div>
        <div class="col-md-4 mb-3">
          <div class="card summary-card text-center bg-light">
            <div class="card-body">
              <i class="fas fa-user-tie fa-2x text-success mb-2"></i>
              <h4 class="card-title"><?= number_format($unique_reps_count) ?></h4>
              <p class="card-text text-muted">Sales Representatives</p>
            </div>
          </div>
        </div>
        <div class="col-md-4 mb-3">
          <div class="card summary-card text-center bg-light">
            <div class="card-body">
              <i class="fas fa-map-marker-alt fa-2x text-warning mb-2"></i>
              <h4 class="card-title"><?= number_format($unique_towns_count) ?></h4>
              <p class="card-text text-muted">Towns Covered</p>
            </div>
          </div>
        </div>
      </div>

      <!-- Report Details -->
      <div class="card report-table mb-4">
        <div class="card-header bg-dark text-white">
          <h5 class="mb-0"><i class="fas fa-table me-2"></i>Itinerary Details</h5>
        </div>
        <div class="card-body p-0">
          <div class="table-responsive">
            <table class="table table-striped table-hover mb-0">
              <thead>
                <tr>
                  <th>#</th>
                  <th>Reference No</th>
                  <th>Sales Rep</th>
                  <th>Start Date</th>
                  <th>End Date</th>
                  <th>Town</th>
                  <th>Area</th>
                  
                </tr>
              </thead>
              <tbody>
                <?php 
                $counter = 1;
                foreach ($data as $row): 
                ?>
                <tr>
                  <td><?= $counter++ ?></td>
                  <td><strong><?= htmlspecialchars($row['refno']) ?></strong></td>
                  <td><?= htmlspecialchars($row['sal_ex']) ?> - <?= htmlspecialchars($row['rep_name']) ?></td>
                  <td><?= date('Y-m-d', strtotime($row['sdate'])) ?></td>
                  <td><?= date('Y-m-d', strtotime($row['entdate'])) ?></td>
                  <td><?= htmlspecialchars($row['Town']) ?></td>
                  <td><?= htmlspecialchars(!empty($row['Area']) ? $row['Area'] : 'N/A') ?></td>
                  
                </tr>
                <?php endforeach; ?>
              </tbody>
            </table>
          </div>
        </div>
      </div>

      <!-- Export Options -->
      <div class="text-center mb-4 no-print">
        <button onclick="exportToCSV()" class="btn btn-success me-2">
          <i class="fas fa-file-csv me-1"></i>Export to CSV
        </button>
        <button onclick="window.print()" class="btn btn-primary">
          <i class="fas fa-file-pdf me-1"></i>Save as PDF
        </button>
      </div>

    <?php else: ?>
      <div class="alert alert-info text-center">
        <i class="fas fa-info-circle me-2"></i>No records found for the selected criteria.
      </div>
    <?php endif; ?>
  <?php else: ?>
    <div class="alert alert-secondary text-center">
      <i class="fas fa-hand-pointer me-2"></i>Please select filters and click "Generate Report" to view data.
    </div>
  <?php endif; ?>
</div>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/js/bootstrap.bundle.min.js"></script>
<script>
function exportToCSV() {
    let csv = 'Reference No,Sales Rep,Start Date,End Date,Town,Area,Status\n';
    
    <?php if (!empty($data)): ?>
    const data = <?= json_encode($data) ?>;
    
    data.forEach(row => {
        const area = row.Area ? row.Area : 'N/A';
        csv += `"${row.refno}","${row.sal_ex} - ${row.rep_name}","${row.sdate}","${row.entdate}","${row.Town}","${area}","${row.Enable == 1 ? 'Active' : 'Inactive'}"\n`;
    });
    <?php endif; ?>
    
    const blob = new Blob([csv], { type: 'text/csv' });
    const url = window.URL.createObjectURL(blob);
    const a = document.createElement('a');
    a.href = url;
    a.download = 'itinerary_report_' + new Date().toISOString().split('T')[0] + '.csv';
    a.click();
}
</script>
</body>
</html>
