<link rel="stylesheet" href="css/bootstrap/css/bootstrap.min.css">
<link rel="stylesheet" href="css/bootstrap_custom.css">
<script src="https://cdnjs.cloudflare.com/ajax/libs/apexcharts/3.35.3/apexcharts.min.js"></script>

<style type="text/css">
    #nav-pills > li > a,
    .nav-pills > li > a:focus,
    .nav-pills > li > a:hover {
        background-color: #7eaad6;
    }

    .card {
        margin: 10px auto;
        border: 1px solid #ddd;
        border-radius: 10px;
        box-shadow: 0 2px 5px rgba(0, 0, 0, 0.1);
        background-color: #f9f9f9;
    }

    .card-body {
        padding: 15px;
    }

    .card-title a {
        color: #333;
        font-size: 18px;
        text-decoration: none;
        font-family: 'Verdana', sans-serif;
    }

    .card-title a:hover {
        color: #007bff;
    }

    .card-icon {
        text-align: center;
        font-size: 40px;
        margin-top: 10px;
        color: #007bff;
    }

    .btn {
        display: block;
        width: 100%;
        margin-top: 10px;
        background-color: #007bff;
        color: white;
        border: none;
        padding: 8px 0;
        font-size: 14px;
        text-align: center;
        text-decoration: none;
        border-radius: 5px;
    }

    .btn:hover {
        background-color: #0056b3;
    }

    .show-toggle-container {
        display: flex;
        justify-content: flex-end;
        margin-top: 10px;
        margin-right: 15px;
    }

    #showMoreBtn,
    #showLessBtn {
        background: none;
        color: black;
        border: none;
        font-size: 12px;
        padding: 3px 8px;
        cursor: pointer;
    }

    #showMoreBtn:hover,
    #showLessBtn:hover {
        text-decoration: underline;
    }

    @media (max-width: 767px) {
        .show-toggle-container {
            flex-direction: column;
            align-items: flex-end;
        }
    }
</style>


<?php
ini_set('session.gc_maxlifetime', 30 * 60 * 60 * 60);
session_start(); 
include("security/connection_sql.php");
date_default_timezone_set('Asia/Colombo');

if (empty($_SESSION["CURRENT_USER"])) {
  header("Location: login.php");
  exit;
}

$currentMonthStart = date('Y-m-01');
$currentMonthEnd = date('Y-m-t');
$currentUser = $_SESSION['CURRENT_REP'];
$userType = $_SESSION['User_Type'];
$sal_ex = $_SESSION['CURRENT_REP'];

// For admin users, add ability to view specific sales executive data
$selected_sal_ex = '';
if ($userType == 1 && isset($_POST['view_sal_ex'])) {
    $selected_sal_ex = $_POST['view_sal_ex'];
    $sal_ex = $selected_sal_ex; // Use selected sales executive for data
}

// Fetch all sales executives for admin selection
$all_sales_execs = array();
if ($userType == 1) {
    try {
        $stmt = $conn->prepare("SELECT DISTINCT REPCODE, Name FROM s_salrep WHERE (company='T' or company ='C') and cancel='1' ORDER BY REPCODE");
        $stmt->execute();
        $all_sales_execs = $stmt->fetchAll(PDO::FETCH_ASSOC);
    } catch (Throwable $e) {
        // Silently handle error
    }
}

/* This Function implified to get Vat Rate value from db column */

function fetch_sales_data($conn, $userType, $currentUser, $currentMonthStart, $currentMonthEnd) {
    global $selected_sal_ex; // Access the selected sales executive

    // Fetch sales amount for the current month
    $salesQuery = "
        SELECT SUM(GRAND_TOT) AS sales
        FROM s_salma
        WHERE CANCELL = '0'
        AND SDATE BETWEEN :startDate AND :endDate
    ";

    if ($userType == 1 && !empty($selected_sal_ex)) {
        // Admin looking at specific sales executive
        $salesQuery .= " AND SAL_EX = :user";
    } elseif ($userType != 1) {
        // Regular user - restrict to their sales code
        $salesQuery .= " AND SAL_EX = :user";
    }

    $salesStmt = $conn->prepare($salesQuery);
    $salesStmt->bindParam(':startDate', $currentMonthStart);
    $salesStmt->bindParam(':endDate', $currentMonthEnd);

    if ($userType == 1 && !empty($selected_sal_ex)) {
        $salesStmt->bindParam(':user', $selected_sal_ex);
    } elseif ($userType != 1) {
        $salesStmt->bindParam(':user', $currentUser);
    }
    
    $salesStmt->execute();
    $salesResult = $salesStmt->fetch(PDO::FETCH_ASSOC);
    $sales = isset($salesResult['sales']) ? (float)$salesResult['sales'] : 0;
    
    // Fetch returns amount for the current month
    $rtnQuery = "
        SELECT SUM(AMOUNT) AS rtn
        FROM c_bal
        WHERE FLAG1 = '0' 
        AND (TRN_TYPE = 'GRN' OR TRN_TYPE = 'CNT')
        AND CANCELL = '0'
        AND SDATE BETWEEN :startDate AND :endDate
    ";

    if ($userType == 1 && !empty($selected_sal_ex)) {
        $rtnQuery .= " AND SAL_EX = :user";
    } elseif ($userType != 1) {
        $rtnQuery .= " AND SAL_EX = :user";
    }

    $rtnStmt = $conn->prepare($rtnQuery);
    $rtnStmt->bindParam(':startDate', $currentMonthStart);
    $rtnStmt->bindParam(':endDate', $currentMonthEnd);

    if ($userType == 1 && !empty($selected_sal_ex)) {
        $rtnStmt->bindParam(':user', $selected_sal_ex);
    } elseif ($userType != 1) {
        $rtnStmt->bindParam(':user', $currentUser);
    }
    
    $rtnStmt->execute();
    $rtnResult = $rtnStmt->fetch(PDO::FETCH_ASSOC);
    $rtn = isset($rtnResult['rtn']) ? (float)$rtnResult['rtn'] : 0;
    
    // Calculate as per requirement - Using the exact formula provided
    $grossSale = $sales - $rtn;
    $net = ($grossSale / 118) * 100;
    $vat = $grossSale - $net;
    
    return [
        'total' => $sales,
        'net' => $net,
        'vat' => $vat,
        'final' => $grossSale
    ];
}


function fetch_return_check_data($conn, $userType, $currentUser, $currentMonthStart, $currentMonthEnd) {
    global $selected_sal_ex;
    
    if ($userType == 1 && !empty($selected_sal_ex)) {
        // Admin looking at specific sales executive
        $query = "SELECT SUM((CR_CHEVAL + CR_REPAY) - PAID) 
        FROM s_cheq 
        WHERE S_REF = :user AND CR_DATE BETWEEN :startDate AND :endDate";
        $stmt = $conn->prepare($query);
        $stmt->bindParam(':user', $selected_sal_ex);
    } else if ($userType == 1) {
        // Admin looking at all data
        $query = "SELECT SUM((CR_CHEVAL + CR_REPAY) - PAID) 
        FROM s_cheq 
        WHERE CR_DATE BETWEEN :startDate AND :endDate";
        $stmt = $conn->prepare($query);
    } else {
        // Regular user
        $query = "SELECT SUM((CR_CHEVAL + CR_REPAY) - PAID) 
        FROM s_cheq 
        WHERE S_REF = :user AND CR_DATE BETWEEN :startDate AND :endDate";
        $stmt = $conn->prepare($query);
        $stmt->bindParam(':user', $currentUser);
    }

    $stmt->bindParam(':startDate', $currentMonthStart);
    $stmt->bindParam(':endDate', $currentMonthEnd);
    $stmt->execute();
    $sum = $stmt->fetchColumn();
    return $sum !== false ? $sum : 0;
}

function fetch_outstanding_over_days($conn, $sal_ex, $overDays, $userType) {
    $tmpdate = date('Y-m-d', strtotime("-$overDays days"));

    $query = "SELECT GRAND_TOT, TOTPAY FROM s_salma 
    WHERE CANCELL='0' 
    AND GRAND_TOT - TOTPAY > 1 
    AND TYPE <> 'CA' 
    AND SDATE <= :tmpdate";

    if ($userType != 1 || ($userType == 1 && $sal_ex != 'ALL' && !empty($sal_ex))) {
        $query .= " AND SAL_EX = :sal_ex";
    }

    $stmt = $conn->prepare($query);
    $stmt->bindParam(':tmpdate', $tmpdate);

    if ($userType != 1 || ($userType == 1 && $sal_ex != 'ALL' && !empty($sal_ex))) {
        $stmt->bindParam(':sal_ex', $sal_ex);
    }

    $stmt->execute();
    $totbal = 0;

    while ($row = $stmt->fetch(PDO::FETCH_ASSOC)) {
        $balance = $row['GRAND_TOT'] - $row['TOTPAY'];
        $totbal += $balance;
    }

    return $totbal;
}


$returnCheckAmount = fetch_return_check_data($conn, $userType, $currentUser, $currentMonthStart, $currentMonthEnd);

$salesAmount = fetch_sales_data($conn, $userType, $currentUser, $currentMonthStart, $currentMonthEnd);

$out60 = fetch_outstanding_over_days($conn, $sal_ex, 60, $userType);
$out90 = fetch_outstanding_over_days($conn, $sal_ex, 90, $userType);
$out120 = fetch_outstanding_over_days($conn, $sal_ex, 120, $userType); 


// Format the sales amount
$formattedNetAmount = number_format($salesAmount['net'], 2);

$formattedReturnCheckAmount = number_format($returnCheckAmount, 2);

$formattedOut60 = number_format($out60, 2);
$formattedOut90 = number_format($out90, 2);
$formattedOut120 = number_format($out120, 2);

?>


<section class="content-header">
    <div class="container-fluid">
        <h4>
            Dashboard 
            <small> / Home Page</small>
        </h4>
    </div>
</section>



<section class="content">
    <div class="container-fluid">
        <div class="row">

            <!-- Sales -->
            <div class="col-12 col-sm-6 col-lg-3 mb-3">
                <div class="card">
                    <div class="card-body">
                        <div class="d-flex justify-content-between align-items-center">
                            <div>
                                <h4 class="mb-1 mt-1">Rs: <?php echo $formattedNetAmount; ?></h4>
                                <p class="text-muted mb-0"><?php echo date('F Y'); ?> Net Sales</p>
                            </div>
                            <div class="float-end mt-2">
                                <i class="fas fa-chart-line fs-2 text-primary"></i>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Return Check -->
            <div class="col-12 col-sm-6 col-lg-3 mb-3">
                <div class="card">
                    <div class="card-body">
                        <div class="d-flex justify-content-between align-items-center">
                            <div>
                                <h4 class="mb-1 mt-1">Rs: <?php echo $formattedReturnCheckAmount; ?></h4>
                                <p class="text-muted mb-0">Return Check Amount</p>
                            </div>
                            <div class="float-end mt-2">
                                <i class="fas fa-chart-pie fs-2 text-primary"></i>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Outstanding Over 60 Days -->
            <div class="col-12 col-sm-6 col-lg-3 mb-3">

                <div class="card">
                    <div class="card-body">
                        <div class="d-flex justify-content-between align-items-center">
                            <div>
                                <h4 class="mb-1 mt-1">Rs: <?php echo $formattedOut60; ?></h4>
                                <p class="text-muted mb-0">Over 60 Days Outstanding</p>
                            </div>
                            <div class="float-end mt-2">
                                <i class="fas fa-clock fs-2 text-primary"></i>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Outstanding Over 90 Days -->
            <div class="col-12 col-sm-6 col-lg-3 mb-3">
                <div class="card">
                    <div class="card-body">
                        <div class="d-flex justify-content-between align-items-center">
                            <div>
                                <h4 class="mb-1 mt-1">Rs: <?php echo $formattedOut90; ?></h4>
                                <p class="text-muted mb-0">Over 90 Days Outstanding</p>
                            </div>
                            <div class="float-end mt-2">
                                <i class="fas fa-hourglass-half fs-2 text-primary"></i>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

        </div>

        <div class="row" id="secondRow" style="display: none;">
            <!-- Outstanding Over 120 Days -->
            <div class="col-12 col-sm-6 col-lg-3 mb-3">

                <div class="card">
                    <div class="card-body">
                        <div class="d-flex justify-content-between align-items-center">
                            <div>
                                <h4 class="mb-1 mt-1">Rs: <?php echo $formattedOut120; ?></h4>
                                <p class="text-muted mb-0">Over 120 Days Outstanding</p>
                            </div>
                            <div class="float-end mt-2">
                                <i class="fas fa-calendar-times fs-2 text-primary"></i>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="show-toggle-container">
            <button id="showMoreBtn" onclick="toggleSecondRow()">
                Show More <i class="fas fa-angle-down"></i>
            </button>
            <button id="showLessBtn" onclick="toggleSecondRow()" style="display: none;">
                Show Less <i class="fas fa-angle-up"></i>
            </button>
        </div>
    </div>
</section>

<section class="content-header">
    <div class="container-fluid">
        <h4>Quick Links</h4>
    </div>
</section>

<section class="content">
    <div class="container-fluid">
        <div class="row">

            <!-- Sales Order -->
            <div class="col-12 col-sm-6 col-lg-3 mb-3">
                <div class="card">
                    <div class="card-body">
                        <h5 class="card-title">
                            <a href="home.php?url=sales_ord">Sales Order</a>
                        </h5>
                        <a href="home.php?url=sales_ord" class="btn">Go to Sales Order</a>
                    </div>
                </div>
            </div>

            <!-- Collection Assign -->
            <div class="col-12 col-sm-6 col-lg-3 mb-3">
                <div class="card">
                    <div class="card-body">
                        <h5 class="card-title">
                            <a href="home.php?url=collection_assign">Daily Call Sheet</a>
                        </h5>
                        <a href="home.php?url=collection_assign" class="btn">Go to Daily Call Sheet Assign</a>
                    </div>
                </div>
            </div>

            <!-- Collection Summary -->
            <div class="col-12 col-sm-6 col-lg-3 mb-3">
                <div class="card">
                    <div class="card-body">
                        <h5 class="card-title">
                            <a href="home.php?url=collection_report">Collection Summary</a>
                        </h5>
                        <a href="home.php?url=collection_report" class="btn">Go to Collection Summary</a>
                    </div>
                </div>
            </div>

            <!-- Outstanding -->
            <div class="col-12 col-sm-6 col-lg-3 mb-3">
                <div class="card">
                    <div class="card-body">
                        <h5 class="card-title">
                            <a href="home.php?url=ref_out_standing">OutStanding</a>
                        </h5>
                        <a href="home.php?url=ref_out_standing" class="btn">Go to OutStanding</a>
                    </div>
                </div>
            </div>

        </div>
    </div>
</section>

<section class="content">

    <div class="row">
         <?php include_once 'final.php'; ?>
    </div>

</section>

<script>
    function toggleSecondRow() {
        const secondRow = document.getElementById('secondRow');
        const showMoreBtn = document.getElementById('showMoreBtn');
        const showLessBtn = document.getElementById('showLessBtn');

        if (secondRow.style.display === "none") {
            secondRow.style.display = "flex";
            showMoreBtn.style.display = "none";
            showLessBtn.style.display = "inline-block";
        } else {
            secondRow.style.display = "none";
            showMoreBtn.style.display = "inline-block";
            showLessBtn.style.display = "none";
        }
    }
</script>
