<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Sales Dashboard</title>
    <link href="https://fonts.googleapis.com/css2?family=Montserrat:wght@100;200;300;400;500;600;700;800;900&display=swap" rel="stylesheet">
    <link href="https://fonts.googleapis.com/icon?family=Material+Icons+Outlined" rel="stylesheet">
    <script src="https://cdnjs.cloudflare.com/ajax/libs/apexcharts/3.35.3/apexcharts.min.js"></script>
    <style>
        body {
            font-family: "Montserrat", sans-serif;
            background-color: #f4f4f4;
            margin: 0;
            padding: 0;
        }
        .dashboard-container {
            display: flex;
            flex-wrap: wrap;
            padding: 20px;
            gap: 20px;
        }
        .chart-card {
            flex: 1;
            min-width: 48%;
            background-color: #fff;
            border-radius: 5px;
            box-shadow: 0 6px 7px -4px rgba(0, 0, 0, 0.2);
            padding: 20px;
            margin-bottom: 20px;
        }
        .chart {
            width: 100%;
        }
        .no-data {
            display: none;
            text-align: center;
            font-size: 18px;
            color: #666;
            margin-top: 20px;
        }
        select {
            padding: 10px;
            margin: 5px;
            border-radius: 5px;
            border: 1px solid #ccc;
            font-size: 14px;
            cursor: pointer;
        }
        .dropdown-container {
            display: flex;
            justify-content: center;
            margin-bottom: 20px;
        }
        .dropdown-container select {
            margin: 0 10px;
        }
        h3 {
            text-align: center;
            color: #333;
            margin-bottom: 20px;
        }
    </style>
</head>
<body>  
    <div>
        <div class="col-md-12 col-xl-6">
            <div class="card">
                <div class="card-body">
                    <?php include 'areachart.php'; ?>
                </div>
            </div>
        </div>
        
        <div class="col-md-6 col-xl-6">
            <div class="card">
                <div class="card-body">
                    <?php include 'piechart.php'; ?>
                </div>
            </div>
        </div>

        <?php
        session_start();
        $username = $_SESSION['UserName'];

        if ($username === 'Gayan'): ?>
            <div class="col-md-12 col-xl-12">
                <div class="card">
                    <div class="card-body">
                        <?php include 'barchart.php'; ?>
                    </div>
                </div>
            </div>
        <?php endif; ?>
    </div>

    <!-- Load scripts at the end of the body -->
    <script src="js/areachart.js"></script>
    <script src="js/piechart.js"></script>
    
    <?php if ($username === 'Gayan'): ?>
        <script src="js/barchart.js"></script>
    <?php endif; ?>
</body>

</html>