let currentRecord = null;

function showMessage(message, isSuccess) {
    const messageDiv = document.getElementById('message');
    messageDiv.textContent = message;
    messageDiv.className = 'message ' + (isSuccess ? 'success' : 'error');
    messageDiv.style.display = 'block';
    
    setTimeout(() => {
        messageDiv.style.display = 'none';
    }, 5000);
}

function clearForm() {
    document.getElementById('refno').value = '';
    document.getElementById('sdate').value = '';
    document.getElementById('entdate').value = '';
    document.getElementById('sal_ex').value = '';
    document.getElementById('town').value = '';
    document.getElementById('townSelect').value = '';
    document.getElementById('enable').value = '1';
    currentRecord = null;
}

function loadRecords() {
    fetch('backend.php', {
        method: 'POST',
        headers: {
            'Content-Type': 'application/x-www-form-urlencoded',
        },
        body: 'action=list'
    })
    .then(response => response.json())
    .then(data => {
        if (data.success) {
            displayRecords(data.records);
        } else {
            showMessage(data.message, false);
        }
    })
    .catch(error => {
        showMessage('Error loading records: ' + error, false);
    });
}

function displayRecords(records) {
    const container = document.getElementById('recordsContainer');
    container.innerHTML = '';
    
    records.forEach(record => {
        const recordDiv = document.createElement('div');
        recordDiv.className = 'record-item';
        recordDiv.innerHTML = `
            <strong>${record.refno}</strong> - ${record.Town} - ${record.sdate}
            <br><small>Sales: ${record.sal_ex} | Enable: ${record.Enable ? 'Yes' : 'No'}</small>
        `;
        
        recordDiv.onclick = function() {
            // Remove selected class from all items
            document.querySelectorAll('.record-item').forEach(item => {
                item.classList.remove('selected');
            });
            // Add selected class to clicked item
            this.classList.add('selected');
            loadRecord(record.refno);
        };
        
        container.appendChild(recordDiv);
    });
}

function loadRecord(refno) {
    fetch('backend.php', {
        method: 'POST',
        headers: {
            'Content-Type': 'application/x-www-form-urlencoded',
        },
        body: `action=load&refno=${encodeURIComponent(refno)}`
    })
    .then(response => response.json())
    .then(data => {
        if (data.success) {
            const record = data.data;
            document.getElementById('refno').value = record.refno;
            document.getElementById('sdate').value = record.sdate;
            document.getElementById('entdate').value = record.entdate;
            document.getElementById('sal_ex').value = record.sal_ex;
            document.getElementById('town').value = record.Town;
            document.getElementById('townSelect').value = record.Town;
            document.getElementById('enable').value = record.Enable;
            currentRecord = record.refno;
        } else {
            showMessage(data.message, false);
        }
    })
    .catch(error => {
        showMessage('Error loading record: ' + error, false);
    });
}

function newRecord() {
    fetch('backend.php', {
        method: 'POST',
        headers: {
            'Content-Type': 'application/x-www-form-urlencoded',
        },
        body: 'action=new'
    })
    .then(response => response.json())
    .then(data => {
        if (data.success) {
            clearForm();
            document.getElementById('refno').value = data.refno;
            showMessage(data.message, true);
        } else {
            showMessage(data.message, false);
        }
    })
    .catch(error => {
        showMessage('Error generating new reference: ' + error, false);
    });
}

function saveRecord() {
    const formData = new FormData();
    formData.append('action', 'save');
    formData.append('refno', document.getElementById('refno').value);
    formData.append('sdate', document.getElementById('sdate').value);
    formData.append('entdate', document.getElementById('entdate').value);
    formData.append('sal_ex', document.getElementById('sal_ex').value);
    formData.append('town', document.getElementById('town').value);
    formData.append('enable', document.getElementById('enable').value);

    fetch('backend.php', {
        method: 'POST',
        body: formData
    })
    .then(response => response.json())
    .then(data => {
        showMessage(data.message, data.success);
        if (data.success) {
            loadRecords();
            clearForm();
        }
    })
    .catch(error => {
        showMessage('Error saving record: ' + error, false);
    });
}

function updateRecord() {
    if (!currentRecord) {
        showMessage('Please select a record to update', false);
        return;
    }

    const formData = new FormData();
    formData.append('action', 'update');
    formData.append('refno', document.getElementById('refno').value);
    formData.append('sdate', document.getElementById('sdate').value);
    formData.append('entdate', document.getElementById('entdate').value);
    formData.append('sal_ex', document.getElementById('sal_ex').value);
    formData.append('town', document.getElementById('town').value);
    formData.append('enable', document.getElementById('enable').value);

    fetch('backend.php', {
        method: 'POST',
        body: formData
    })
    .then(response => response.json())
    .then(data => {
        showMessage(data.message, data.success);
        if (data.success) {
            loadRecords();
        }
    })
    .catch(error => {
        showMessage('Error updating record: ' + error, false);
    });
}

function deleteRecord() {
    if (!currentRecord) {
        showMessage('Please select a record to delete', false);
        return;
    }

    if (!confirm('Are you sure you want to delete this record?')) {
        return;
    }

    fetch('backend.php', {
        method: 'POST',
        headers: {
            'Content-Type': 'application/x-www-form-urlencoded',
        },
        body: `action=delete&refno=${encodeURIComponent(currentRecord)}`
    })
    .then(response => response.json())
    .then(data => {
        showMessage(data.message, data.success);
        if (data.success) {
            loadRecords();
            clearForm();
        }
    })
    .catch(error => {
        showMessage('Error deleting record: ' + error, false);
    });
}

// Initialize when page loads
document.addEventListener('DOMContentLoaded', function() {
    loadRecords();
    
    // Set today's date as default for date fields
    const today = new Date().toISOString().split('T')[0];
    document.getElementById('sdate').value = today;
    document.getElementById('entdate').value = today;
});