<?php include 'config.php'; ?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Daily Itinerary Management</title>
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }
        
        body {
            font-family: Arial, sans-serif;
            line-height: 1.6;
            background: #f4f4f4;
            padding: 10px;
        }
        
        .container {
            max-width: 100%;
            margin: 0 auto;
        }
        
        .header {
            background: #2c3e50;
            color: white;
            padding: 15px;
            text-align: center;
            border-radius: 5px;
            margin-bottom: 15px;
        }
        
        .button-group {
            display: flex;
            gap: 5px;
            margin-bottom: 15px;
            flex-wrap: wrap;
        }
        
        .btn {
            padding: 12px 15px;
            border: none;
            border-radius: 5px;
            cursor: pointer;
            font-size: 14px;
            flex: 1;
            min-width: 70px;
        }
        
        .btn-new { background: #3498db; color: white; }
        .btn-save { background: #27ae60; color: white; }
        .btn-update { background: #f39c12; color: white; }
        .btn-delete { background: #e74c3c; color: white; }
        
        .form-group {
            background: white;
            padding: 15px;
            border-radius: 5px;
            margin-bottom: 15px;
            box-shadow: 0 2px 5px rgba(0,0,0,0.1);
        }
        
        .form-row {
            margin-bottom: 12px;
        }
        
        label {
            display: block;
            margin-bottom: 5px;
            font-weight: bold;
            color: #333;
        }
        
        input, select {
            width: 100%;
            padding: 12px;
            border: 1px solid #ddd;
            border-radius: 5px;
            font-size: 16px;
        }
        
        .combo-container {
            position: relative;
            display: flex;
        }
        
        .combo-container input {
            flex: 1;
            border-right: none;
            border-top-right-radius: 0;
            border-bottom-right-radius: 0;
        }
        
        .combo-container select {
            width: 50px;
            border-top-left-radius: 0;
            border-bottom-left-radius: 0;
        }
        
        .message {
            padding: 10px;
            margin: 10px 0;
            border-radius: 5px;
            text-align: center;
            display: none;
        }
        
        .success { background: #d4edda; color: #155724; border: 1px solid #c3e6cb; }
        .error { background: #f8d7da; color: #721c24; border: 1px solid #f5c6cb; }
        
        .records-list {
            background: white;
            border-radius: 5px;
            padding: 15px;
            box-shadow: 0 2px 5px rgba(0,0,0,0.1);
        }
        
        .record-item {
            padding: 12px;
            border-bottom: 1px solid #eee;
            cursor: pointer;
        }
        
        .record-item:hover {
            background: #f8f9fa;
        }
        
        .record-item.selected {
            background: #e3f2fd;
            border-left: 4px solid #3498db;
        }
        
        @media (max-width: 768px) {
            .button-group {
                flex-direction: column;
            }
            
            .btn {
                width: 100%;
            }
        }
    </style>
</head>
<body>
    <div class="container">
        <div class="header">
            <h1>Daily Itinerary Management</h1>
        </div>
        
        <div class="button-group">
            <button class="btn btn-new" onclick="newRecord()">New</button>
            <button class="btn btn-save" onclick="saveRecord()">Save</button>
            <button class="btn btn-update" onclick="updateRecord()">Update</button>
            <button class="btn btn-delete" onclick="deleteRecord()">Delete</button>
        </div>
        
        <div id="message" class="message"></div>
        
        <div class="form-group">
            <div class="form-row">
                <label for="refno">Reference Number</label>
                <input type="text" id="refno" placeholder="Reference Number">
            </div>
            
            <div class="form-row">
                <label for="sdate">Start Date</label>
                <input type="date" id="sdate">
            </div>
            
            <div class="form-row">
                <label for="entdate">End Date</label>
                <input type="date" id="entdate">
            </div>
            
            <div class="form-row">
                <label for="sal_ex">Sales Person</label>
                <select id="sal_ex">
                    <option value="">Select Sales Person</option>
                    <?php
                    $sql = "SELECT REPCODE, Name FROM s_salrep ORDER BY REPCODE";
                    $result = $conn->query($sql);
                    if ($result->num_rows > 0) {
                        while($row = $result->fetch_assoc()) {
                            echo "<option value='".$row['REPCODE']."'>".$row['REPCODE']." - ".$row['Name']."</option>";
                        }
                    }
                    ?>
                </select>
            </div>
            
            <div class="form-row">
                <label for="town">Town</label>
                <div class="combo-container">
                    <input type="text" id="town" list="towns" placeholder="Select or enter town">
                    <select id="townSelect" onchange="document.getElementById('town').value = this.value">
                        <option value="">Select</option>
                        <?php
                        $sql = "SELECT Town FROM s_itinery GROUP BY Town";
                        $result = $conn->query($sql);
                        if ($result->num_rows > 0) {
                            while($row = $result->fetch_assoc()) {
                                echo "<option value='".$row['Town']."'>".$row['Town']."</option>";
                            }
                        }
                        ?>
                    </select>
                </div>
            </div>
            
            <div class="form-row">
                <label for="enable">Enable</label>
                <select id="enable">
                    <option value="1">Yes</option>
                    <option value="0">No</option>
                </select>
            </div>
        </div>
        
        <div class="records-list">
            <h3>Existing Records</h3>
            <div id="recordsContainer"></div>
        </div>
    </div>

    <script src="script.js"></script>
</body>
</html>