<?php
include 'config.php';

header('Content-Type: application/json');

$action = $_POST['action'] ?? '';
$response = ['success' => false, 'message' => ''];

try {
    switch($action) {
        case 'new':
            // Generate new reference number
            $result = $conn->query("SELECT MAX(CAST(SUBSTRING(refno, 2) AS UNSIGNED)) as max_ref FROM s_itinery WHERE refno LIKE 'R%'");
            $row = $result->fetch_assoc();
            $next_num = ($row['max_ref'] ?? 0) + 1;
            $new_refno = 'R' . str_pad($next_num, 4, '0', STR_PAD_LEFT);
            
            $response = [
                'success' => true,
                'refno' => $new_refno,
                'message' => 'New reference number generated'
            ];
            break;

        case 'save':
            $refno = $conn->real_escape_string($_POST['refno']);
            $sdate = $conn->real_escape_string($_POST['sdate']);
            $entdate = $conn->real_escape_string($_POST['entdate']);
            $sal_ex = $conn->real_escape_string($_POST['sal_ex']);
            $town = $conn->real_escape_string($_POST['town']);
            $enable = intval($_POST['enable']);

            // Validate required fields
            if (empty($refno) || empty($sdate) || empty($sal_ex) || empty($town)) {
                throw new Exception('All fields are required');
            }

            // Check if refno already exists
            $check = $conn->query("SELECT refno FROM s_itinery WHERE refno = '$refno'");
            if ($check->num_rows > 0) {
                throw new Exception('Reference number already exists');
            }

            $sql = "INSERT INTO s_itinery (refno, sdate, entdate, sal_ex, Town, Enable) 
                    VALUES ('$refno', '$sdate', '$entdate', '$sal_ex', '$town', $enable)";
            
            if ($conn->query($sql)) {
                $response = ['success' => true, 'message' => 'Record saved successfully'];
            } else {
                throw new Exception('Error saving record: ' . $conn->error);
            }
            break;

        case 'update':
            $refno = $conn->real_escape_string($_POST['refno']);
            $sdate = $conn->real_escape_string($_POST['sdate']);
            $entdate = $conn->real_escape_string($_POST['entdate']);
            $sal_ex = $conn->real_escape_string($_POST['sal_ex']);
            $town = $conn->real_escape_string($_POST['town']);
            $enable = intval($_POST['enable']);

            if (empty($refno)) {
                throw new Exception('Reference number is required for update');
            }

            $sql = "UPDATE s_itinery SET 
                    sdate = '$sdate', 
                    entdate = '$entdate', 
                    sal_ex = '$sal_ex', 
                    Town = '$town', 
                    Enable = $enable 
                    WHERE refno = '$refno'";
            
            if ($conn->query($sql)) {
                $response = ['success' => true, 'message' => 'Record updated successfully'];
            } else {
                throw new Exception('Error updating record: ' . $conn->error);
            }
            break;

        case 'delete':
            $refno = $conn->real_escape_string($_POST['refno']);

            if (empty($refno)) {
                throw new Exception('Reference number is required for deletion');
            }

            $sql = "DELETE FROM s_itinery WHERE refno = '$refno'";
            
            if ($conn->query($sql)) {
                $response = ['success' => true, 'message' => 'Record deleted successfully'];
            } else {
                throw new Exception('Error deleting record: ' . $conn->error);
            }
            break;

        case 'load':
            $refno = $conn->real_escape_string($_POST['refno']);
            $sql = "SELECT * FROM s_itinery WHERE refno = '$refno'";
            $result = $conn->query($sql);
            
            if ($result->num_rows > 0) {
                $row = $result->fetch_assoc();
                $response = [
                    'success' => true,
                    'data' => $row
                ];
            } else {
                throw new Exception('Record not found');
            }
            break;

        case 'list':
            $sql = "SELECT * FROM s_itinery ORDER BY sdate DESC, refno DESC";
            $result = $conn->query($sql);
            $records = [];
            
            while($row = $result->fetch_assoc()) {
                $records[] = $row;
            }
            
            $response = [
                'success' => true,
                'records' => $records
            ];
            break;

        default:
            throw new Exception('Invalid action');
    }
} catch (Exception $e) {
    $response = ['success' => false, 'message' => $e->getMessage()];
}

echo json_encode($response);
$conn->close();
?>