<?php
require_once("security/connection_sql.php");

if (isset($_POST['year'])) {
    $year = $_POST['year'];
    $c_code = $_POST['c_code'];



    $query = "SELECT MONTH(sdate1) AS month, SUM(collect) AS sales
    FROM vendor_visit
    WHERE YEAR(sdate1) = :year AND c_code = :c_code
    GROUP BY MONTH(sdate1)
    ORDER BY MONTH(sdate1)";

    try {

        $stmt = $conn->prepare($query);
        $stmt->bindParam(':year', $year);
        $stmt->bindParam(':c_code', $c_code);
        $stmt->execute();

        $result = $stmt->fetchAll(PDO::FETCH_ASSOC);

        $months = [];
        $sales = [];

        $monthNames = [
            1 => 'January', 2 => 'February', 3 => 'March', 4 => 'April',
            5 => 'May', 6 => 'June', 7 => 'July', 8 => 'August',
            9 => 'September', 10 => 'October', 11 => 'November', 12 => 'December'
        ];

        for ($i = 1; $i <= 12; $i++) {
            $months[] = $monthNames[$i];
            $sales[] = 0;  
        }

        foreach ($result as $row) {
            $months[$row['month'] - 1] = $monthNames[$row['month']];
            $sales[$row['month'] - 1] = $row['sales'];
        }

        echo json_encode([
            'labels' => $months,
            'values' => $sales
        ]);
    } catch (Exception $e) {
        echo json_encode(['error' => 'Database query failed', 'message' => $e->getMessage()]);
    }
} else {
    echo json_encode(['error' => 'Year is required']);
}
?>
