<?php
$currentYear = date("Y"); 
$id = '';
$id = $_GET['c_code']
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>Sales Chart</title>
    <script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <style>
        /* Make the container responsive */
        .chart-container {
            position: relative;
            width: 100%;
            height: 500px;  /* Adjust this to set the desired height */
            margin-top: 40px;
        }

        /* Ensure canvas fills the container */
        #salesChart {
            width: 100%;
            height: 100%;
        }
    </style>
</head>
<body>

    <section class="content" style="padding: 50px;">
        <div class="box box-primary">
            <div class="box-header with-border" style="margin-top:20px">
                <h3 class="box-title">Collection Summary Chart - " <?php echo $currentYear ?> " Years - <?php echo $id ?></h3>
                <b style="margin-top: -10px;">
                    <p style="float: right; color: black" id="time"></p>
                </b> 
                
                <!-- Chart container -->
                <div class="chart-container">
                    <canvas id="salesChart"></canvas>
                </div>
            </div>
        </div>
    </section>

<script>
    function fetchChartData(year, c_code) {
        $.ajax({
            url: 'collection_chart_data.php',
            type: 'POST',
            data: {
                year: year,
                c_code: c_code  
            },
            success: function(response) {
                try {
                    var data = JSON.parse(response);
                    var months = data.labels;  
                    var sales = data.values;   

                    var ctx = document.getElementById('salesChart').getContext('2d');
                    var chart = new Chart(ctx, {
                        type: 'bar',
                        data: {
                            labels: months,
                            datasets: [{
                                label: 'Collection Amount',
                                data: sales,
                                backgroundColor: 'rgba(75, 192, 192, 0.2)',  
                                borderColor: 'rgba(75, 192, 192, 1)',  
                                borderWidth: 1,
                                barThickness: 10, 
                            }]
                        },
                        options: {
                            responsive: true,  // Ensures the chart is responsive
                            maintainAspectRatio: true, // Ensures aspect ratio is maintained
                            plugins: {
                                legend: {
                                    position: 'top',
                                },
                                tooltip: {
                                    mode: 'index',
                                    intersect: false,
                                },
                            },
                            scales: {
                                x: {
                                    beginAtZero: true
                                },
                                y: {
                                    beginAtZero: true  
                                }
                            }
                        }
                    });
                } catch (e) {
                    console.error('Error parsing JSON:', e);
                }
            },
            error: function(xhr, status, error) {
                console.error("Error fetching data:", error);
            }
        });
    }

    var currentYear = '<?php echo $currentYear; ?>';
    var c_code = '<?php echo $id; ?>';
    fetchChartData(currentYear, c_code);

    $('#yearSelect').change(function() {
        var selectedYear = $(this).val();
        fetchChartData(selectedYear, c_code);
    });
</script>

</body>
</html>
