+<?php
session_start();
date_default_timezone_set('Asia/Colombo');

// Basic session check (optional; remove if not needed)
if (!isset($_SESSION["CURRENT_USER"]) || $_SESSION["CURRENT_USER"] == "") {
    echo "Please Loging Again !!!";
    exit();
}

// Use PDO connection (same as collection_assign_data_save.php)
require_once("security/connection_sql.php");

// Ensure PDO throws exceptions
if (isset($conn) && $conn instanceof PDO) {
    $conn->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
} else {
    die("Database connection not available.");
}

// Fetch distinct Sales Executives from vendor_visit (ref_no1 column holds sales rep)
$reps = [];
try {
    $stmt = $conn->query("SELECT DISTINCT ref_no1 FROM vendor_visit WHERE ref_no1 IS NOT NULL AND TRIM(ref_no1) <> '' ORDER BY ref_no1");
    $reps = $stmt->fetchAll(PDO::FETCH_COLUMN);
} catch (Throwable $e) {
    $reps = [];
}

// Handle filters
$filters = [
    'sal_ex' => isset($_POST['sal_ex']) ? trim($_POST['sal_ex']) : '',
    'start_date' => isset($_POST['start_date']) ? $_POST['start_date'] : '',
    'end_date' => isset($_POST['end_date']) ? $_POST['end_date'] : '',
    'type' => isset($_POST['type']) ? $_POST['type'] : 'all' // all | checq | inv
];

$data = [];
$total_amount = 0;
$total_rows = 0;

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    // Build query
    $sql = "SELECT 
                v.sdate1 AS v_date,
                v.cus_name,
                v.ref_no,
                v.collect,
                v.flag,
                v.ref_no1 AS sal_ex,
                v.collection_time,
                COALESCE(sc.CR_CHDATE, ss.SDATE) AS cheq_date
            FROM vendor_visit v
            LEFT JOIN s_cheq sc 
                ON v.flag = 'checq' AND sc.CR_REFNO = v.ref_no
            LEFT JOIN s_salma ss 
                ON v.flag = 'inv' AND ss.REF_NO = v.ref_no
            WHERE 1=1";

    $params = [];

    // Date range
    if (!empty($filters['start_date']) && !empty($filters['end_date'])) {
        $sql .= " AND DATE(v.sdate1) BETWEEN :start_date AND :end_date";
        $params[':start_date'] = $filters['start_date'];
        $params[':end_date'] = $filters['end_date'];
    }

    // Sales executive
    if (!empty($filters['sal_ex'])) {
        $sql .= " AND v.ref_no1 = :sal_ex";
        $params[':sal_ex'] = $filters['sal_ex'];
    }

    // Type filter
    if ($filters['type'] === 'checq' || $filters['type'] === 'inv') {
        $sql .= " AND v.flag = :flag";
        $params[':flag'] = $filters['type'];
    }

    $sql .= " ORDER BY COALESCE(v.collection_time, v.sdate1) DESC, v.sdate1 DESC, v.cus_name ASC";

    try {
        $stmt = $conn->prepare($sql);
        $stmt->execute($params);
        $data = $stmt->fetchAll(PDO::FETCH_ASSOC);

        foreach ($data as $row) {
            $amt = floatval($row['collect']);
            $total_amount += $amt;
        }
        $total_rows = count($data);
    } catch (Throwable $e) {
        $err = $e->getMessage();
    }
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
<title>Daily Call Sheet Report</title>
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/css/bootstrap.min.css" rel="stylesheet">
<link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css" rel="stylesheet">
<style>
    body { background-color: #f8f9fa; }
    .report-header {
        background: linear-gradient(135deg, #0d6efd 0%, #20c997 100%);
        color: white;
        padding: 2rem 0;
        margin-bottom: 2rem;
    }
    .summary-card { border: none; border-radius: 12px; box-shadow: 0 3px 10px rgba(0,0,0,0.08); }
    .report-table { box-shadow: 0 0 20px rgba(0,0,0,0.06); }
    @media print { .no-print { display: none; } body { background-color: #fff; } }
</style>
</head>
<body>
<div class="report-header">
  <div class="container">
    <div class="row align-items-center">
      <div class="col-md-8">
        <a href="home.php?url=collection_assign" class="btn btn-light" id="backButton">
               <i class="fas fa-arrow-left me-1"></i> Back 
        </a>
        <h1><i class="fas fa-clipboard-list me-2"></i>Daily Call Sheet Report</h1>
        <p class="lead mb-0">Summary of assigned collections</p>
      </div>
      <div class="col-md-4 text-end">
         

        <button onclick="window.print()" class="btn btn-light btn-sm no-print">
          <i class="fas fa-print me-1"></i>Print Report
        </button>
      </div> 
    </div>
  </div>
</div>

<div class="container">
  <!-- Filters -->
  <div class="card mb-4 no-print">
    <div class="card-header bg-primary text-white">
      <h5 class="mb-0"><i class="fas fa-filter me-2"></i>Filter Report</h5>
    </div>
    <div class="card-body">
      <form method="POST" class="row g-3">
        <div class="col-md-3">
          <label for="sal_ex" class="form-label">Sales Executive</label>
          <select class="form-select" id="sal_ex" name="sal_ex">
            <option value="">All</option>
            <?php foreach ($reps as $rep): ?>
              <option value="<?= htmlspecialchars($rep) ?>" <?= (!empty($filters['sal_ex']) && $filters['sal_ex'] === $rep) ? 'selected' : '' ?>>
                <?= htmlspecialchars($rep) ?>
              </option>
            <?php endforeach; ?>
          </select>
        </div>
        <div class="col-md-2">
          <label for="type" class="form-label">Type</label>
          <select class="form-select" id="type" name="type">
            <option value="all" <?= ($filters['type']==='all'?'selected':'') ?>>All</option>
            <option value="checq" <?= ($filters['type']==='checq'?'selected':'') ?>>Cheque</option>
            <option value="inv" <?= ($filters['type']==='inv'?'selected':'') ?>>Invoice</option>
          </select>
        </div>
        <div class="col-md-3">
          <label for="start_date" class="form-label">Start Date</label>
          <input type="date" class="form-control" id="start_date" name="start_date" value="<?= htmlspecialchars($filters['start_date']) ?>" required>
        </div>
        <div class="col-md-3">
          <label for="end_date" class="form-label">End Date</label>
          <input type="date" class="form-control" id="end_date" name="end_date" value="<?= htmlspecialchars($filters['end_date']) ?>" required>
        </div>
        <div class="col-md-1 d-flex align-items-end">
          <button type="submit" class="btn btn-success w-100"><i class="fas fa-chart-bar me-1"></i>Go</button>
        </div>
      </form>
    </div>
  </div>

  <?php if (isset($err)): ?>
    <div class="alert alert-danger"><?= htmlspecialchars($err) ?></div>
  <?php endif; ?>

  <?php if ($_SERVER['REQUEST_METHOD'] === 'POST' && empty($err)): ?>
    <?php if (!empty($data)): ?>
      <!-- Summary -->
      <div class="row mb-4">
        <div class="col-md-6 mb-3">
          <div class="card summary-card text-center bg-light">
            <div class="card-body">
              <i class="fas fa-sack-dollar fa-2x text-success mb-2"></i>
              <h4 class="card-title">LKR <?= number_format($total_amount, 2) ?></h4>
              <p class="card-text text-muted">Total Collect Amount</p>
            </div>
          </div>
        </div>
        <div class="col-md-6 mb-3">
          <div class="card summary-card text-center bg-light">
            <div class="card-body">
              <i class="fas fa-list-ol fa-2x text-info mb-2"></i>
              <h4 class="card-title"><?= $total_rows ?></h4>
              <p class="card-text text-muted">Total Records</p>
            </div>
          </div>
        </div>
      </div>

    
      <div class="row mb-4">
        <div class="col-12">
          <div class="card">
            <div class="card-header bg-info text-white">
              <h5 class="mb-0"><i class="fas fa-chart-line me-2"></i>Route Analysis</h5>
            </div>
            <div class="card-body">
              <p>Analyze the routes taken by Mobile Executives to optimize collection efficiency.</p>
              <div class="row">
                <div class="col-md-6">
                  <a href="route_tracking.php?date=<?= $filters['start_date'] ?>&sal_ex=<?= urlencode($filters['sal_ex']) ?>" class="btn btn-primary mb-2">
                    <i class="fas fa-map-marked-alt me-2"></i>View Route Map
                  </a>
                </div>
                  <div class="col-md-6">
                  <a href="route_analysis.php?start_date=<?= $filters['start_date'] ?>&end_date=<?= $filters['end_date'] ?>&sal_ex=<?= urlencode($filters['sal_ex']) ?>" class="btn btn-success mb-2">
                    <i class="fas fa-chart-bar me-2"></i>Detailed Analysis
                  </a>
                </div>
                
              </div>
            </div>
          </div>
        </div>
      </div>

      <!-- Details -->
      <div class="card">
        <div class="card-header bg-success text-white">
          <h5 class="mb-0"><i class="fas fa-table me-2"></i>Details</h5>
        </div>
        <div class="card-body p-0">
          <div class="table-responsive">
            <table class="table table-striped table-hover report-table mb-0">
              <thead class="table-dark">
                <tr>
                  <th>Date</th>
                  <th>Customer</th>
                  <th>Invoice/Cheque No</th>
                  <th>Cheque Date</th>
                  <th class="text-end">Collect Amount</th>
                </tr>
              </thead>
              <tbody>
                <?php foreach ($data as $row): ?>
                  <tr>
                    <td><?= htmlspecialchars(date('Y-m-d', strtotime($row['v_date']))) ?></td>
                    <td><?= htmlspecialchars($row['cus_name']) ?></td>
                    <td><?= htmlspecialchars($row['ref_no']) ?></td>
                    <td>
                      <?php
                        $cd = $row['cheq_date'];
                        echo $cd ? htmlspecialchars(date('Y-m-d', strtotime($cd))) : ($row['flag'] === 'inv' ? '-' : '');
                      ?>
                    </td>
                    <td class="text-end"><?= number_format((float)$row['collect'], 2) ?></td>
                  </tr>
                <?php endforeach; ?>
              </tbody>
              <tfoot class="table-light">
                <tr>
                  <th colspan="4" class="text-end">Total:</th>
                  <th class="text-end">LKR <?= number_format($total_amount, 2) ?></th>
                </tr>
              </tfoot>
            </table>
          </div>
        </div>
      </div>
    <?php else: ?>
      <div class="alert alert-info text-center">
        <i class="fas fa-info-circle me-2"></i>No records found for the selected criteria.
      </div>
    <?php endif; ?>
  <?php endif; ?>
</div>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/js/bootstrap.bundle.min.js"></script>
<script>
// Default dates to current month
document.addEventListener('DOMContentLoaded', function() {
  const s = document.getElementById('start_date');
  const e = document.getElementById('end_date');
  if (!s.value || !e.value) {
    const today = new Date();
    const first = new Date(today.getFullYear(), today.getMonth(), 1);
    s.value = first.toISOString().split('T')[0];
    e.value = today.toISOString().split('T')[0];
  }
});
</script>
</body>
</html>
