<?php
session_start();
date_default_timezone_set('Asia/Colombo');
require_once("security/connection_sql.php");

// Basic session check
if (!isset($_SESSION["CURRENT_USER"]) || $_SESSION["CURRENT_USER"] == "") {
    echo json_encode(['success' => false, 'message' => 'Authentication required']);
    exit();
}

// Ensure PDO throws exceptions
if (isset($conn) && $conn instanceof PDO) {
    $conn->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
} else {
    echo json_encode(['success' => false, 'message' => 'Database connection not available']);
    exit();
}

// Check if this is an AJAX request
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['action'])) {
    $action = $_POST['action'];

    if ($action === 'get_details' && isset($_POST['ref_no'])) {
        try {
            $ref_no = $_POST['ref_no'];
            
            $sql = "SELECT 
                    v.collection_note_refno,
                    v.sdate1,
                    v.ref_no,
                    v.flag,
                    v.collect,
                    v.cus_name,
                    v.latitude,
                    v.longitude,
                    v.remark,
                    v.ref_no1 AS sales_executive
                FROM vendor_visit v
                WHERE v.collection_note_refno = :ref_no
                ORDER BY v.sdate1";
                
            $stmt = $conn->prepare($sql);
            $stmt->execute([':ref_no' => $ref_no]);
            $data = $stmt->fetchAll(PDO::FETCH_ASSOC);
            
            if (empty($data)) {
                echo json_encode(['success' => false, 'message' => 'No records found for this reference']);
            } else {
                echo json_encode(['success' => true, 'data' => $data]);
            }
        } catch (Throwable $e) {
            echo json_encode(['success' => false, 'message' => $e->getMessage()]);
        }
    } else {
        echo json_encode(['success' => false, 'message' => 'Invalid action or missing parameters']);
    }
} else {
    echo json_encode(['success' => false, 'message' => 'Invalid request method']);
}
?>
