<?php
require_once ("security/connection_sql.php");

// Ensure PDO throws exceptions
if (isset($conn) && $conn instanceof PDO) {
    $conn->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
    $conn->exec("SET time_zone = '+05:30'");
}

// Always use Sri Lanka time in PHP
date_default_timezone_set('Asia/Colombo');

function sanitize_number($v) {
    if ($v === null) return '';
    $v = trim($v);
    // keep digits, minus and dot
    $v = preg_replace('/[^\d\.\-]/', '', $v);
    return $v;
}

function sanitize_text($v) {
    if ($v === null) return '';
    return trim($v);
}

try {

        if (isset($_POST['action']) && $_POST['action'] === 'non_outstanding_save') {
        // Handle non-outstanding visit save
        // Always use server-side Sri Lanka time
        $sdate1 = (new DateTime('now', new DateTimeZone('Asia/Colombo')))->format('Y-m-d H:i:s');
        $collection_time = $sdate1;

        $c_code = isset($_POST['c_code']) ? $_POST['c_code'] : '';
        $cus_name = isset($_POST['cus_name']) ? $_POST['cus_name'] : '';
        $sal_ex = isset($_POST['sal_ex']) ? $_POST['sal_ex'] : '';
        $collection_note_refno = isset($_POST['collection_note_refno']) ? $_POST['collection_note_refno'] : '';
        $non_outstanding_remark = isset($_POST['non_outstanding_remark']) ? $_POST['non_outstanding_remark'] : '';
        $latitude = isset($_POST['latitude']) ? $_POST['latitude'] : null;
        $longitude = isset($_POST['longitude']) ? $_POST['longitude'] : null;

        // Validate required fields
        if (empty($c_code) || empty($non_outstanding_remark)) {
            echo "Customer code and remark are required for non-outstanding visit.";
            exit;
        }

        $query = "INSERT INTO vendor_visit 
          (sdate1, ref_no1, c_code, cus_name, ref_no, collect, remark, flag, collection_note_refno, latitude, longitude, collection_time) 
          VALUES 
          (:sdate1, :sal_ex, :c_code, :cus_name, :ref_no, :collect, :remark, :flag, :collection_note_refno, :latitude, :longitude, :collection_time)";
        $stmt = $conn->prepare($query);

        $stmt->bindParam(':sdate1', $sdate1);
        $stmt->bindParam(':sal_ex', $sal_ex);
        $stmt->bindParam(':c_code', $c_code);
        $stmt->bindParam(':cus_name', $cus_name);
        $stmt->bindParam(':ref_no', $ref_no_null = 'NON-OUT');
        $stmt->bindParam(':collect', $collect_null = 'No Collection');
        $stmt->bindParam(':remark', $non_outstanding_remark);
        $stmt->bindParam(':collection_note_refno', $collection_note_refno);
        $stmt->bindParam(':flag', $flag = 'non-outstanding');
        $stmt->bindParam(':latitude', $latitude);
        $stmt->bindParam(':longitude', $longitude);
        $stmt->bindParam(':collection_time', $collection_time);
        $stmt->execute();

        echo "Non-outstanding visit saved successfully!";
        exit;
    }
    
    if (isset($_POST['action']) && $_POST['action'] === 'save') {
        $ref_no = isset($_POST['ref_no']) ? (array)$_POST['ref_no'] : [];
        $collect = isset($_POST['collect']) ? (array)$_POST['collect'] : [];

        // Always use server-side Sri Lanka time
        $sdate1 = (new DateTime('now', new DateTimeZone('Asia/Colombo')))->format('Y-m-d H:i:s');
        // Use the same timestamp for collection_time
        $collection_time = $sdate1;

        $c_code = isset($_POST['c_code']) ? $_POST['c_code'] : '';
        $cus_name = isset($_POST['cus_name']) ? $_POST['cus_name'] : '';
        $sal_ex = isset($_POST['sal_ex']) ? $_POST['sal_ex'] : '';
        $collection_note_refno = isset($_POST['collection_note_refno']) ? $_POST['collection_note_refno'] : '';
        $collection_remarks = isset($_POST['collection_remarks']) ? $_POST['collection_remarks'] : '';
        $latitude = isset($_POST['latitude']) ? $_POST['latitude'] : null;
        $longitude = isset($_POST['longitude']) ? $_POST['longitude'] : null;

        $query = "INSERT INTO vendor_visit 
          (sdate1, ref_no1, c_code, cus_name, ref_no, collect, remark, flag, collection_note_refno, latitude, longitude, collection_time) 
          VALUES 
          (:sdate1, :sal_ex, :c_code, :cus_name, :ref_no, :collect, :remark, :flag, :collection_note_refno, :latitude, :longitude, :collection_time)";
        $stmt = $conn->prepare($query);

        $inserted = 0;
        foreach ($ref_no as $index => $ref_no_val) {
            //$collect_val = isset($collect[$index]) ? sanitize_number($collect[$index]) : '';
            //if ($collect_val === '' || floatval($collect_val) == 0) {
            $collect_val = isset($collect[$index]) ? sanitize_text($collect[$index]) : '';
            if ($collect_val === '') {
                continue;
            }
            $stmt->bindParam(':sdate1', $sdate1);
            $stmt->bindParam(':sal_ex', $sal_ex);
            $stmt->bindParam(':c_code', $c_code);
            $stmt->bindParam(':cus_name', $cus_name);
            $stmt->bindParam(':ref_no', $ref_no_val);
            $stmt->bindParam(':collect', $collect_val);
            $stmt->bindParam(':remark', $collection_remarks);
            $stmt->bindParam(':collection_note_refno', $collection_note_refno);
            $stmt->bindParam(':flag', $flag = 'checq');
            $stmt->bindParam(':latitude', $latitude);
            $stmt->bindParam(':longitude', $longitude);
            $stmt->bindParam(':collection_time', $collection_time);
            $stmt->execute();
            $inserted++;
        }

        echo $inserted > 0 ? "Data saved successfully!" : "No rows to save.";
        exit;
    }

    if (isset($_POST['action']) && $_POST['action'] === 'summary_save') {

        $sql = "update invpara set collection_note_refno=collection_note_refno+1  ";
        $result = $conn->query($sql);
        
        $ref_no = isset($_POST['ref_no']) ? (array)$_POST['ref_no'] : [];
        $collect = isset($_POST['collect']) ? (array)$_POST['collect'] : [];

        // Always use server-side Sri Lanka time
        $sdate1 = (new DateTime('now', new DateTimeZone('Asia/Colombo')))->format('Y-m-d H:i:s');
        // Use the same timestamp for collection_time
        $collection_time = $sdate1;

        $c_code = isset($_POST['c_code']) ? $_POST['c_code'] : '';
        $cus_name = isset($_POST['cus_name']) ? $_POST['cus_name'] : '';
        $sal_ex = isset($_POST['sal_ex']) ? $_POST['sal_ex'] : '';
        $collection_note_refno = isset($_POST['collection_note_refno']) ? $_POST['collection_note_refno'] : '';
        $collection_remarks = isset($_POST['collection_remarks']) ? $_POST['collection_remarks'] : '';
        $latitude = isset($_POST['latitude']) ? $_POST['latitude'] : null;
        $longitude = isset($_POST['longitude']) ? $_POST['longitude'] : null;

        $query = "INSERT INTO vendor_visit (sdate1, ref_no1, c_code, cus_name, ref_no, collect, remark, flag, collection_note_refno, latitude, longitude, collection_time) 
          VALUES 
          (:sdate1, :sal_ex, :c_code, :cus_name, :ref_no, :collect, :remark, :flag, :collection_note_refno, :latitude, :longitude, :collection_time)";
        $stmt = $conn->prepare($query);

        $inserted = 0;
        foreach ($ref_no as $index => $ref_no_val) {
            //$collect_val = isset($collect[$index]) ? sanitize_number($collect[$index]) : '';
            //if ($collect_val === '' || floatval($collect_val) == 0) {
            $collect_val = isset($collect[$index]) ? sanitize_text($collect[$index]) : '';
            if ($collect_val === '') {
                continue;
            }
            $stmt->bindParam(':sdate1', $sdate1);
            $stmt->bindParam(':sal_ex', $sal_ex);
            $stmt->bindParam(':c_code', $c_code);
            $stmt->bindParam(':cus_name', $cus_name);
            $stmt->bindParam(':ref_no', $ref_no_val);
            $stmt->bindParam(':collect', $collect_val);
            $stmt->bindParam(':remark', $collection_remarks);
            $stmt->bindParam(':collection_note_refno', $collection_note_refno);
            $stmt->bindParam(':flag', $flag = 'inv');
            $stmt->bindParam(':latitude', $latitude);
            $stmt->bindParam(':longitude', $longitude);
            $stmt->bindParam(':collection_time', $collection_time);
            $stmt->execute();
            $inserted++;
        }

        echo $inserted > 0 ? "Data saved successfully!" : "No rows to save.";
        exit;
    }

    http_response_code(400);
    echo "Invalid action.";
} catch (Throwable $e) {
    http_response_code(500);
    echo "Error saving data: " . $e->getMessage();
}
?>
