<?php
date_default_timezone_set('Asia/Colombo');
session_start();
require_once("connectioni.php");
// ini_set('session.gc_maxlifetime', 30 * 60 * 60 * 60); 
$_SESSION["brand"] = "";

if ($_SESSION["CURRENT_USER"] == "") {
  echo "Please Loging Again !!!";
  exit();
}


// Fetch the collection note ref no from invpara
$ref_result = mysqli_query($GLOBALS['dbinv'], "SELECT collection_note_refno FROM invpara");
$ref_row = mysqli_fetch_array($ref_result);
$ref_no = isset($ref_row['collection_note_refno']) ? intval($ref_row['collection_note_refno']) : 1;

// Format it as COLL/ 0001
$collection_note_refno = "COLL/ " . str_pad($ref_no, 4, "0", STR_PAD_LEFT);
$sql = "update invpara set collection_note_refno=collection_note_refno+1  ";
        $result = $conn->query($sql);

?>



<style>
  body {
    margin: 0px !important;
  }
  .talign {
    text-align: left !important;
  }
  .text {
    font-weight: 600; 
    color: black;
  }
  .form-horizontal .form-group {
    margin-top: -10px !important;
  }

  .logo-sm {
    margin-top: 25px;
  }

  .table-container {
    width: 100%;
    overflow-x: auto;
    border: 1px solid #ddd;
    border-radius: 5px;
    padding: 10px;
  }



  .CSSTableGenerator thead tr:first-child {
    background-color: #333;
    color: white;
    position: sticky;
    top: 0;
  }

  @media screen and (max-width: 768px) {
    .CSSTableGenerator td {
      font-size: 14px;
    }
  }

  .table-container {
    width: 100%;
    overflow-x: auto;
  }

  /* Updated modal design for a modern look */
  .custom-modal {
    display: none;
    position: fixed;
    z-index: 1050;
    left: 0;
    top: 0;
    width: 100%;
    height: 100%;
    overflow: auto;
    background-color: rgba(0, 0, 0, 0.7);
    padding-top: 60px;
  }

  .custom-modal-content {
    background-color: #ffffff;
    margin: auto;
    padding: 20px;
    border-radius: 10px;
    width: 90%;
    max-width: 800px;
    box-shadow: 0 4px 8px rgba(0, 0, 0, 0.2);
    animation: slideIn 0.3s;
  }

  .custom-modal-header {
    font-size: 22px;
    font-weight: bold;
    color: #333;
    margin-bottom: 15px;
    display: flex;
    justify-content: space-between;
    align-items: center;
    border-bottom: 1px solid #ddd;
    padding-bottom: 10px;
  }

  .custom-modal-header .close {
    color: #333;
    font-size: 24px;
    font-weight: bold;
    cursor: pointer;
  }

  .custom-modal-header .close:hover {
    color: #ff0000;
  }

  .modal-body {
    max-height: 400px;
    overflow-y: auto;
    padding: 10px;
  }

  /* Table Styling */
  .modal-body table {
    width: 100%;
    border-collapse: collapse;
    margin-top: 10px;
  }

  .modal-body table th,
  .modal-body table td {
    border: 1px solid #ddd;
    padding: 10px;
    text-align: left;
    font-size: 14px;
  }

  .modal-body table th {
    background-color: #f8f9fa;
    color: #333;
    font-weight: bold;
  }

  .modal-body table tr:nth-child(even) {
    background-color: #f9f9f9;
  }

  .modal-body table tr:hover {
    background-color: #f1f1f1;
  }

  /* Add a search bar */
  .modal-body .search-bar {
    margin-bottom: 15px;
    display: flex;
    justify-content: space-between;
    align-items: center;
  }

  .modal-body .search-bar input {
    width: 100%;
    padding: 10px;
    border: 1px solid #ddd;
    border-radius: 5px;
    font-size: 14px;
  }

  @keyframes slideIn {
    from {
      transform: translateY(-50px);
      opacity: 0;
    }
    to {
      transform: translateY(0);
      opacity: 1;
    }
  }
</style>

<!-- Main content -->

<section class="content">
  <div class="box box-primary">
    <div class="box-header with-border">
      <h3 class="box-title">Daily Call Sheet</h3>
      <b style="margin-top: -10px;">
        <p style="float: right; color: black" id="time"></p>
      </b> 

      <!-- Add View Button -->
      <a href="collection_assign_view.php" class="btn btn-info float-right no-print" style="margin-left: 10px;">
        <i class="fas fa-eye"></i> View 
      </a>

      <form onsubmit="save_inv(event)" style="margin-top:20px;">
        <div class="row">
          <div class="row align-items-center">
            <div class="col-md-2 mb-4" hidden>
              <label class="form-label">Date</label>
              <input type="hidden" size="20" name="invdate" id="invdate" value="<?php echo date('Y-m-d'); ?>" class="form-control" />
              <input id="dte_dor" name="dte_dor" type="hidden" value="" class="text_purchase3" />
            </div>
          </div>
        </div>

        <!-- Row 1 -->
        <div class="row g-3 align-items-end">

          <!-- Ref No -->
          <div class="col-md-2">
            <label class="form-label">Ref No</label>
            <input type="text" class="form-control" name="collection_note_refno" id="collection_note_refno" value="<?php echo $collection_note_refno; ?>" disabled>
          </div>


          <!-- Customer Code -->
          <div class="col-md-2">
            <label class="form-label">Customer</label>
            <input type="text" class="form-control" name="firstname_hidden" id="firstname_hidden" placeholder="Code" disabled>
          </div>

          <!-- Customer Name -->
          <div class="col-md-3">
            <label class="form-label">Customer Name</label>
            <input type="text" class="form-control" name="firstname" id="firstname" placeholder="Enter customer name" disabled>
          </div>

          <!-- Sales Executive -->
          <div class="col-md-3">
            <label class="form-label">Sales Executive</label>
            <select id="sal_ex" class="form-control">
              <?php
              require_once("connectioni.php");
              if ($_SESSION["MANAGER"] != "") {
                $sql = "select * from s_salrep where (company='T' or company ='C') and cancel='1' and manager='" . $_SESSION["MANAGER"] . "' order by REPCODE";
              } else if ($_SESSION["CURRENT_REP"] == "") {
                $sql = "select * from s_salrep where (company='T' or company ='C') and cancel='1' order by REPCODE";
              } else {
                $sql = "select * from s_salrep where (company='T' or company ='C') and cancel='1' and repcode = '" . $_SESSION["CURRENT_REP"] . "' order by REPCODE";
              }
              $result = mysqli_query($GLOBALS['dbinv'], $sql);
              while ($row = mysqli_fetch_array($result)) {
                echo "<option value='" . $row["REPCODE"] . "'>" . $row["REPCODE"] . " " . $row["Name"] . "</option>";
              }
              ?>
            </select>
          </div>

          <!-- Find Button -->
          <div class="col-md-2" style="margin-top: 25px">
            <button type="button" class="btn btn-primary w-100" id="findButton">Find</button>
          </div>
        </div>

        <!-- Row 2 -->
        <div class="row g-3 align-items-end mt-2" style="margin-top: 25px">
          <!-- Collection Date -->
          <div class="col-md-4">
            <label class="form-label">Collection Date</label>
            <input type="date" name="s_date" id="s_date" disabled value="<?php echo date('Y-m-d'); ?>" class="form-control" />
          </div>

          <!-- GPS Location Panel -->
          <div class="col-md-6">
            <div id="locationPanel" class="card border p-3">
              <div class="d-flex justify-content-between align-items-center mb-2">
                <strong>GPS Status:</strong>
                <span id="gpsStatus" class="badge bg-secondary">Optional</span>
              </div>
              <div id="locationCoords" class="small mb-2"><em class="text-muted">GPS is optional - app works without it</em></div>
              <div id="gpsError" class="text-danger small" style="display:none;"></div>
              <div class="small text-muted mb-2">
                <i class="fas fa-info-circle"></i> GPS is optional - you can save data without location
              </div>
              <button type="button" id="refreshLocation" class="btn btn-primary btn-sm">
                <i class="fas fa-map-marker-alt"></i> Enable GPS Location
              </button>
              
              <!-- Hidden fields to store location data -->
              <input type="hidden" id="latitude" name="latitude" value="">
              <input type="hidden" id="longitude" name="longitude" value="">
            </div>
          </div>

          <!-- Save Button -->
          <div class="col-md-2">
            <button class="btn btn-success w-100" type="submit" style="margin-top: 25px">
              <i class="fas fa-plus"></i> Save
            </button>
          </div>
        </div>

        <!-- Table 1: Invoice Data -->
        <div class="col-md-12" style="padding:0px;margin-top: 20px;">
          <h4>Return Cheque Outstanding</h4>
          <div class="table-container CSSTableGenerator">
            <table id="invoiceTable" class="table table-striped table-bordered table-responsive">
              <thead>
                <tr>
                  <th>Ref No</th>
                  <th>Date</th>
                  <th>Value</th> 
                  <th>Balance</th>
                  <th>Collect</th>
                  
                  
                </tr>
              </thead>
              <tbody></tbody>
            </table>
          </div>
        </div>

        <!-- Table 2: Summary Data -->
        <div class="col-md-12" style="padding:0px;margin-top: 20px;">
          <h4>Invoice Outstanding</h4>
          <div class="table-container CSSTableGenerator">
            <table id="summaryTable" class="table table-striped table-bordered table-responsive">
              <thead>
                <tr>
                  <th>Ref No</th>
                  <th>Date</th>
                  <th>Grand Total</th>  
                  <th>Balance</th>
                  <th>Collect</th>
                </tr>
              </thead>
              <tbody></tbody>
            </table>
          </div>
        </div>
        
        <!-- Table 3: Non-Outstanding Visit -->
        <div class="col-md-12" style="padding:0px;margin-top: 20px;">
          <h4>Non-Outstanding Visit (Customer Visit without Collection)</h4>
          <div class="card border p-3">
            <div class="form-group">
              <label for="non_outstanding_remark"><strong>Visit Reason/Remark</strong></label>
              <textarea class="form-control" id="non_outstanding_remark" name="non_outstanding_remark" 
                        rows="4" placeholder="Enter reason for visit (e.g., Customer not available, Shop closed, Payment promised for next week, etc.)"
                        maxlength="1000" style="resize: vertical;"></textarea>
              <small class="form-text text-muted">
                Use this section to record visits where no collection was made. Location will be saved automatically.
              </small>
            </div>
            <div class="form-check mt-2">
              <input class="form-check-input" type="checkbox" id="save_non_outstanding" name="save_non_outstanding" value="1">
              <label class="form-check-label" for="save_non_outstanding">
                <strong>Save as Non-Outstanding Visit</strong> (Check this box to save visit without collection)
              </label>
            </div>
          </div>
        </div>
        
        <!-- Remarks Section -->
        <div class="col-md-12" style="padding:0px;margin-top: 20px;">
          <h4>Additional Remarks (For Outstanding Collections)</h4>
          <div class="form-group">
            <textarea class="form-control" id="collection_remarks" name="collection_remarks" 
                      rows="4" placeholder="Enter collection remarks here (up to 500 words)"
                      maxlength="5000" style="resize: vertical;"></textarea>
            <small class="form-text text-muted">
              Please add any additional information or special instructions regarding this collection (maximum 500 words).
            </small>
          </div>
        </div>

      </form>
    </div>
  </div>
  
</div>
</div>

</section>

<!-- Custom Modal HTML -->
<div id="customModal" class="custom-modal">
  <div class="custom-modal-content">
    <div class="custom-modal-header">
      Search Customer
      <span class="close" id="closeModal">&times;</span>
    </div>
    <div class="modal-body">
      <div class="search-bar">
        <input type="text" id="searchInput" placeholder="Search customer..." />
      </div>
      <?php include 'search-customer.php'; ?>
    </div>
  </div>
</div>

<!-- Include JS files -->
<script src="https://ajax.googleapis.com/ajax/libs/jqueryui/1.12.1/jquery-ui.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0-alpha1/dist/js/bootstrap.bundle.min.js"></script>



<script type="text/javascript">
  // Global variables for location
  var userLatitude = null;
  var userLongitude = null;
  var locationStatus = "Waiting for GPS...";
  var locationAttempts = 0;
  var locationOptions = {
    enableHighAccuracy: true,
    timeout: 10000,
    maximumAge: 0
  };

  // DOM elements for GPS status
  var gpsStatusElement, locationCoordsElement, gpsErrorElement;

  // Get user's location when page loads
  document.addEventListener('DOMContentLoaded', function() {
    gpsStatusElement = document.getElementById('gpsStatus');
    locationCoordsElement = document.getElementById('locationCoords');
    gpsErrorElement = document.getElementById('gpsError');
    
    // Initialize GPS silently (won't block page if permission denied)
    // Only try to get location if geolocation is supported
    if (navigator.geolocation) {
      // Don't block - just try in background
      setTimeout(function() {
        getLocation();
      }, 500);
    } else {
      updateGPSStatus('Not Available', 'bg-secondary');
      if (locationCoordsElement) {
        locationCoordsElement.innerHTML = 'GPS not supported on this device';
      }
    }
    
    // Setup refresh button
    document.getElementById('refreshLocation').addEventListener('click', function() {
      updateGPSStatus('Refreshing location...', 'bg-warning');
      getLocation(true);
    });
  });

  // Function to get the current location
  function getLocation(forcePrompt = false) {
    if (!navigator.geolocation) {
      updateGPSStatus('Not supported', 'bg-secondary');
      showGPSError("GPS is not supported on this device. You can still save data without location.");
      return;
    }

    updateGPSStatus('Locating...', 'bg-warning');
    hideGPSError();
    
    // Use a shorter timeout to avoid blocking
    var options = {
      enableHighAccuracy: true,
      timeout: 5000, // 5 seconds max
      maximumAge: forcePrompt ? 0 : 300000 // 5 minutes cache unless forced
    };
    
    // Try to get location - if it fails, it's OK
    navigator.geolocation.getCurrentPosition(
      positionSuccess,
      function(error) {
        // Silent fail - just update status
        positionError(error);
        // Don't retry automatically to avoid blocking
      },
      options
    );
  }
  
  // Success callback for geolocation
  function positionSuccess(position) {
    locationAttempts = 0;
    userLatitude = position.coords.latitude;
    userLongitude = position.coords.longitude;
    
    // Store values in hidden fields
    document.getElementById('latitude').value = userLatitude;
    document.getElementById('longitude').value = userLongitude;
    
    updateGPSStatus('GPS Active', 'bg-success');
    
    // Update the location display
    if (locationCoordsElement) {
      locationCoordsElement.innerHTML = 
        `Latitude: ${userLatitude.toFixed(6)}<br>` +
        `Longitude: ${userLongitude.toFixed(6)}<br>` +
        `Accuracy: ${position.coords.accuracy.toFixed(1)} meters`;
    }
    
    console.log(`Location captured: ${userLatitude}, ${userLongitude}, Accuracy: ${position.coords.accuracy}m`);
    hideGPSError();
  }
  
  // Error callback for geolocation
  function positionError(error) {
    let errorMsg = "";
    let statusText = "Off";
    let badgeClass = "bg-secondary";
    
    switch(error.code) {
      case error.PERMISSION_DENIED:
        errorMsg = "Location permission denied. You can still use the app - location is optional.";
        statusText = "Permission Denied";
        badgeClass = "bg-secondary";
        break;
      case error.POSITION_UNAVAILABLE:
        errorMsg = "Location unavailable. You can still use the app - location is optional.";
        statusText = "Unavailable";
        badgeClass = "bg-secondary";
        break;
      case error.TIMEOUT:
        errorMsg = "Location timeout. You can still use the app - location is optional.";
        statusText = "Timeout";
        badgeClass = "bg-secondary";
        break;
      default:
        errorMsg = "Unable to get location. You can still use the app - location is optional.";
        statusText = "Not Available";
        badgeClass = "bg-secondary";
        break;
    }
    
    updateGPSStatus(statusText, badgeClass);
    if (locationCoordsElement) {
      locationCoordsElement.innerHTML = '<em class="text-muted">GPS disabled or unavailable</em>';
    }
    console.log("GPS: " + errorMsg);
    // Don't show error prominently - just log it
    // showGPSError(errorMsg);
  }
  
  // Update GPS status indicator
  function updateGPSStatus(text, className) {
    if (gpsStatusElement) {
      gpsStatusElement.textContent = text;
      gpsStatusElement.className = 'badge ' + className;
    }
  }
  
  // Show GPS error message
  function showGPSError(message) {
    if (gpsErrorElement) {
      gpsErrorElement.textContent = message;
      gpsErrorElement.style.display = 'block';
    }
  }
  
  // Hide GPS error message
  function hideGPSError() {
    if (gpsErrorElement) {
      gpsErrorElement.style.display = 'none';
    }
  }

  // Open the modal
  document.getElementById("findButton").onclick = function() {
    document.getElementById("customModal").style.display = "block";
  }

  // Close the modal
  document.getElementById("closeModal").onclick = function() {
    document.getElementById("customModal").style.display = "none";
  }

  // Close the modal if user clicks outside of it
  window.onclick = function(event) {
    if (event.target == document.getElementById("customModal")) {
      document.getElementById("customModal").style.display = "none";
    }
  }

  // Timer for displaying the current time
  var myVar = setInterval(myTimer, 1000);
  function myTimer() {
    var d = new Date();
    var tt = d.toLocaleTimeString();
    document.getElementById("time").innerHTML = tt;
  }

  // Save function handling with location check
  function save_inv(event) {
    event.preventDefault();
    
    // Check if we have location data
    if (!userLatitude || !userLongitude) {
      // GPS not available - inform user but allow save to continue
      console.log("GPS location data is not available. Saving without location.");
      
      // Try to get location one more time with a shorter timeout
      navigator.geolocation.getCurrentPosition(
        function(position) {
          // On success
          userLatitude = position.coords.latitude;
          userLongitude = position.coords.longitude;
          
          // Store values in hidden fields
          document.getElementById('latitude').value = userLatitude;
          document.getElementById('longitude').value = userLongitude;
          
          updateGPSStatus('GPS Active', 'bg-success');
          
          if (locationCoordsElement) {
            locationCoordsElement.innerHTML = 
              `Latitude: ${userLatitude.toFixed(6)}<br>` +
              `Longitude: ${userLongitude.toFixed(6)}<br>` +
              `Accuracy: ${position.coords.accuracy.toFixed(1)} meters`;
          }
          
          // Now proceed with save
          proceedWithSave();
        },
        function(error) {
          // On error, continue without location - no blocking
          console.log("Could not get location: " + error.message);
          // Proceed with save anyway - don't block the user
          proceedWithSave();
        },
        { enableHighAccuracy: true, timeout: 3000, maximumAge: 0 }
      );
    } else {
      // We have location data, proceed
      proceedWithSave();
    }
  }
  
  function proceedWithSave() {
    var ref_no = [];
    var collect = [];

    // Get location data - use null if not available
    var currentLatitude = document.getElementById('latitude').value || userLatitude || null;
    var currentLongitude = document.getElementById('longitude').value || userLongitude || null;

    // Check if this is a non-outstanding visit
    var isNonOutstanding = document.getElementById('save_non_outstanding').checked;
    var nonOutstandingRemark = document.getElementById('non_outstanding_remark').value.trim();

    // If non-outstanding visit is checked, validate and save
    if (isNonOutstanding) {
      if (!nonOutstandingRemark) {
        alert("Please enter a remark for non-outstanding visit.");
        return;
      }

      // Save non-outstanding visit
      var nonOutstandingData = {
        action: 'non_outstanding_save',
        c_code: $('#firstname_hidden').val(),
        cus_name: $('#firstname').val(),
        sal_ex: $('#sal_ex').val(),
        collection_note_refno: $('#collection_note_refno').val(),
        non_outstanding_remark: nonOutstandingRemark,
        latitude: currentLatitude,
        longitude: currentLongitude,
        sdate1: $('#s_date').val()
      };

      $.ajax({
        type: 'POST',
        url: 'collection_assign_data_save.php',
        data: nonOutstandingData,
        success: function(response) {
          var locationMsg = (currentLatitude && currentLongitude) ? 
                           (" with location: " + parseFloat(currentLatitude).toFixed(6) + ", " + parseFloat(currentLongitude).toFixed(6)) : 
                           " (location not available)";
          alert("Non-outstanding visit saved successfully" + locationMsg);
          window.location.reload();
        },
        error: function(xhr, status, error) {
          console.log("Error: " + error);
          alert("There was an error saving the non-outstanding visit. Please try again.");
        }
      });
      return; // Exit early for non-outstanding
    }

    // Continue with regular outstanding collection save
    $("input[name='ref_no[]']").each(function() {
      ref_no.push($(this).val());
    });

    $("input[name='collect[]']").each(function() {
      collect.push($(this).val());
    });

    var data = {
      action: 'save',
      ref_no: ref_no,
      collect: collect,
      sdate1: $('#s_date').val(),
      c_code: $('#firstname_hidden').val(),
      cus_name: $('#firstname').val(),
      sal_ex: $('#sal_ex').val(),
      collection_note_refno: $('#collection_note_refno').val(),
      collection_remarks: $('#collection_remarks').val(),
      latitude: currentLatitude,
      longitude: currentLongitude
    };

    $.ajax({
      type: 'POST',
      url: 'collection_assign_data_save.php',
      data: data,
      success: function(response) {
        var ref_no_summary = [];
        var collect_summary = [];

        $("input[name='ref_no_summary[]']").each(function() {
          ref_no_summary.push($(this).val());
        });

        $("input[name='collect_summary[]']").each(function() {
          collect_summary.push($(this).val());
        });

        var summary_data = {
          action: 'summary_save',
          ref_no: ref_no_summary,
          collect: collect_summary,
          sdate1: $('#s_date').val(),
          c_code: $('#firstname_hidden').val(),
          cus_name: $('#firstname').val(),
          sal_ex: $('#sal_ex').val(),
          collection_note_refno: $('#collection_note_refno').val(),
          collection_remarks: $('#collection_remarks').val(),
          latitude: currentLatitude,
          longitude: currentLongitude
        };

        $.ajax({
          type: 'POST',
          url: 'collection_assign_data_save.php',
          data: summary_data,
          success: function(response) {
            var locationMsg = (currentLatitude && currentLongitude) ? 
                             (" with location: " + parseFloat(currentLatitude).toFixed(6) + ", " + parseFloat(currentLongitude).toFixed(6)) : 
                             " (location not available)";
            alert("Data saved successfully" + locationMsg);
            window.location.reload();
          },
          error: function(xhr, status, error) {
            console.log("Error: " + error);
            alert("There was an error saving the data. Please try again.");
          }
        });
      },
      error: function(xhr, status, error) {
        console.log("Error: " + error);
        alert("There was an error saving the data. Please try again.");
      }
    });
  }



  $(document).ready(function () {
    $(".date_picker").datepicker({
      dateFormat: "yy-mm-dd",
      defaultDate: new Date(),
    }).datepicker("setDate", new Date());
  });

  $(document).ready(function () {
    $('.example').DataTable({
      responsive: true,
      lengthChange: true,
      fixedHeader: true,
      deferRender: true,
      order: [[0, 'desc']],
      lengthMenu: [[15, 25, 50, 100, -1], ['15 rows', '25 rows', '50 rows', '100 rows', 'Show all']]
    });
  });

  $(document).ready(function () {
      // Initialize DataTable for Invoice Table
    $('#invoiceTable').DataTable({
      responsive: true,
      lengthChange: true,
      fixedHeader: true,
        order: [[0, 'desc']], // Default sorting by the first column
        lengthMenu: [[15, 25, 50, 100, -1], ['15 rows', '25 rows', '50 rows', '100 rows', 'Show all']]
      });

      // Initialize DataTable for Summary Table
    $('#summaryTable').DataTable({
      responsive: true,
      lengthChange: true,
      fixedHeader: true,
        order: [[0, 'desc']], // Default sorting by the first column
        lengthMenu: [[15, 25, 50, 100, -1], ['15 rows', '25 rows', '50 rows', '100 rows', 'Show all']]
      });
  });

// Add JavaScript for dynamic search functionality
// Filter table rows based on search input
  $(document).ready(function () {
    $('#searchInput').on('keyup', function () {
      var value = $(this).val().toLowerCase();
      $('#customModal table tbody tr').filter(function () {
        $(this).toggle($(this).text().toLowerCase().indexOf(value) > -1);
      });
    });
  });

    //click customer data show
  function custno(cuscode, stname) {
    var row = event.target.closest('tr');  // Get the closest row to the clicked element
    var customerCode = row.cells[0].innerText;
    var customerName = row.cells[1].innerText;
    var customerAddress = row.cells[2].innerText;
    var customerPhone = row.cells[3].innerText;
    var subCustomerCode = row.cells[4].innerText;

    // Populate hidden and visible input fields with customer data
    document.getElementById('firstname_hidden').value = customerCode;
    document.getElementById('firstname').value = customerName;

    // Trigger additional functions
    custno_ind(customerCode);
    custno_ind_salmas(customerCode);

    // Explicitly hide the modal
    setTimeout(function () {
        document.getElementById('customModal').style.display = "none"; // Ensure modal is hidden
      }, 500);
  }

// Close modal when close button is clicked
  document.getElementById('closeModal').addEventListener('click', function () {
    $('#customModal').modal('hide');  // Hides the modal when close button is clicked
  });

  function custno_ind(customerCode) {
    var customer_id = customerCode;

    if (customer_id != '') {
      $.ajax({
        type: "POST",
          url: "collection_assign_data.php",  // PHP file to process the data
          data: {
            action: 'cheq',  // Pass the action as 'cheq'
            firstname_hidden: customer_id, 
            sal_ex: $('#sal_ex').val()
          },
          success: function (response) {
            $("#invoiceTable tbody").html(response);  // Update table body with response
          },
          error: function () {
            alert('Error fetching data.');
          }
        });
    } else {
      alert('Please enter a customer code.');
    }
  }

  function custno_ind_salmas(customerCode) {
    var customer_id = customerCode;

    if (customer_id != '') {
      $.ajax({
        type: "POST",
          url: "collection_assign_data.php",  // PHP file to process the data
          data: {
            action: 'salmas',  
            firstname_hidden: customer_id,
            sal_ex: $('#sal_ex').val()
          },
          success: function (response) {
            $("#summaryTable tbody").html(response);  // Update table body with response
          },
          error: function () {
            alert('Error fetching data.');
          }
        });
    } else {
      alert('Please enter a customer code.');
    }
  }

</script>

<!-- defult enter key click not save the data  -->
<script>
  // Prevent form submission when Enter key is pressed
  document.addEventListener('DOMContentLoaded', function() {
    const form = document.querySelector('form');
    
    form.addEventListener('keypress', function(e) {
      // Check if Enter key was pressed
      if (e.keyCode === 13 || e.which === 13) {
        e.preventDefault();
        return false;
      }
    });
  });
</script>


</body>
</html>
