<?php
session_start();
date_default_timezone_set('Asia/Colombo');
header('Content-Type: application/json; charset=utf-8');

// Prevent previously buffered output from breaking JSON
if (ob_get_length()) { ob_clean(); }

// Optional: limit notices/warnings
error_reporting(E_ALL & ~E_NOTICE & ~E_WARNING);

// Check login
if (!isset($_SESSION["CURRENT_USER"]) || $_SESSION["CURRENT_USER"] == "") {
    echo json_encode(["status" => "error", "message" => "Please log in again"]);
    exit;
}

require_once "connectioni.php";

$user  = $_SESSION["CURRENT_USER"];
$today = date("Y-m-d H:i:s");

try {
    if (empty($_POST['cuscode']) || empty($_POST['cheqnum'])) {
        echo json_encode(["status" => "error", "message" => "Customer code and cheque number are required"]);
        exit;
    }

    $cuscode = mysqli_real_escape_string($GLOBALS['dbinv'], $_POST['cuscode']);
    $cheqnum = mysqli_real_escape_string($GLOBALS['dbinv'], $_POST['cheqnum']);

    $where = "cus_code='$cuscode' AND cheque_no='$cheqnum'";
    if (!empty($_POST['invnum'])) {
        $invnum = mysqli_real_escape_string($GLOBALS['dbinv'], $_POST['invnum']);
        $where .= " AND inv_no='$invnum'";
    }
    if (!empty($_POST['refno'])) {
        $refno = mysqli_real_escape_string($GLOBALS['dbinv'], $_POST['refno']);
        $where .= " AND ref_no='$refno'";
    }

    // Delete
    $sql = "DELETE FROM cheque_collection WHERE $where";
    if (mysqli_query($GLOBALS['dbinv'], $sql)) {
        $cnt = mysqli_affected_rows($GLOBALS['dbinv']);
        if ($cnt > 0) {
            echo json_encode([
                "status" => "success",
                "message" => "Record deleted successfully.",
                "records_affected" => $cnt
            ]);
        } else {
            echo json_encode([
                "status" => "error",
                "message" => "No matching record found."
            ]);
        }
    } else {
        echo json_encode([
            "status" => "error",
            "message" => "DB error: " . mysqli_error($GLOBALS['dbinv'])
        ]);
    }
} catch (Exception $e) {
    echo json_encode([
        "status" => "error",
        "message" => "Exception: " . $e->getMessage()
    ]);
}
exit;

?>
    
