<?php
header('Content-Type: application/json');
session_start();
require_once 'security/chart_connection.php';

$month = isset($_GET['month']) ? (int)$_GET['month'] : 0;
$year = isset($_GET['year']) ? (int)$_GET['year'] : 0;

$user_type = isset($_SESSION['User_Type']) ? (int)$_SESSION['User_Type'] : null;
$salEx = isset($_SESSION['CURRENT_REP']) ? $_SESSION['CURRENT_REP'] : null;

if ($user_type === null) {
    echo json_encode(["error" => "User Type not defined in session"]);
    exit;
}

$barChartData = [];

if ($user_type === 1) {
    // Admin: Fetch total sales grouped by SAL_EX and show name from s_salrep
    if ($month > 0 && $year > 0) {
        $barChartQuery = "SELECT r.NAME AS sales_name, SUM(s.TOTPAY) AS total_payment 
                          FROM s_salma s
                          JOIN s_salrep r ON s.SAL_EX = r.REPCODE
                          WHERE s.TOTPAY > 0 AND MONTH(s.SDATE) = ? AND YEAR(s.SDATE) = ?
                          GROUP BY s.SAL_EX";
        $stmt = $conn->prepare($barChartQuery);
        $stmt->bind_param("ii", $month, $year);
    } else {
        $barChartQuery = "SELECT r.NAME AS sales_name, SUM(s.TOTPAY) AS total_payment 
                          FROM s_salma s
                          JOIN s_salrep r ON s.SAL_EX = r.REPCODE
                          WHERE s.TOTPAY > 0
                          GROUP BY s.SAL_EX";
        $stmt = $conn->prepare($barChartQuery);
    }
} else {
    // Sales rep: Filter by their own SAL_EX
    if (!$salEx) {
        echo json_encode(["error" => "Sales executive not defined in session"]);
        exit;
    }

    if ($month > 0 && $year > 0) {
        $barChartQuery = "SELECT REF_NO, TOTPAY 
                          FROM s_salma 
                          WHERE TOTPAY > 0 AND MONTH(SDATE) = ? AND YEAR(SDATE) = ? AND SAL_EX = ?";
        $stmt = $conn->prepare($barChartQuery);
        $stmt->bind_param("iis", $month, $year, $salEx);
    } else {
        $barChartQuery = "SELECT REF_NO, TOTPAY 
                          FROM s_salma 
                          WHERE TOTPAY > 0 AND SAL_EX = ?";
        $stmt = $conn->prepare($barChartQuery);
        $stmt->bind_param("s", $salEx);
    }
}

$stmt->execute();
$result = $stmt->get_result();

while ($row = $result->fetch_assoc()) {
    if ($user_type === 1) {
        $barChartData[] = [
            "label" => $row['sales_name'],
            "value" => round($row['total_payment'])
        ];
    } else {
        $barChartData[] = [
            "label" => $row['REF_NO'],
            "value" => round($row['TOTPAY'])
        ];
    }
}

$conn->close();

echo json_encode([
    "barChartData" => $barChartData,
    "userType" => $user_type
]);
?>
