<?php
date_default_timezone_set('Asia/Colombo');
session_start();
require_once('connectioni.php');

// Check if user is logged in
if (!isset($_SESSION["CURRENT_USER"]) || $_SESSION["CURRENT_USER"] == "") {
    die(json_encode(['success' => false, 'message' => 'Please login again!']));
}

// Use the global database connection
$conn = $GLOBALS['dbinv'];

// Check connection
if (!$conn) {
    die(json_encode(['success' => false, 'message' => 'Database connection failed: ' . mysqli_connect_error()]));
}

header('Content-Type: application/json');

$action = isset($_POST['action']) ? $_POST['action'] : '';
$response = ['success' => false, 'message' => ''];

try {
    switch($action) {
        case 'new':
            // Generate new reference number
            $result = mysqli_query($conn, "SELECT MAX(CAST(SUBSTRING(refno, 2) AS UNSIGNED)) as max_ref FROM s_itinery WHERE refno LIKE 'R%'");
            
            if (!$result) {
                throw new Exception('Error querying database: ' . mysqli_error($conn));
            }
            
            $row = mysqli_fetch_assoc($result);
            $next_num = (isset($row['max_ref']) && $row['max_ref'] ? $row['max_ref'] : 0) + 1;
            $new_refno = 'R' . str_pad($next_num, 4, '0', STR_PAD_LEFT);
            
            $response = [
                'success' => true,
                'refno' => $new_refno,
                'message' => 'New reference number generated'
            ];
            break;

        case 'save':
            $refno = mysqli_real_escape_string($conn, $_POST['refno']);
            $sdate = mysqli_real_escape_string($conn, $_POST['sdate']);
            $entdate = mysqli_real_escape_string($conn, $_POST['entdate']);
            $sal_ex = mysqli_real_escape_string($conn, $_POST['sal_ex']);
            $town = mysqli_real_escape_string($conn, $_POST['town']);
            $area = mysqli_real_escape_string($conn, $_POST['area']);
            $enable = intval($_POST['enable']);

            // Validate required fields
            if (empty($refno) || empty($sdate) || empty($sal_ex) || empty($town)) {
                throw new Exception('All fields are required');
            }

            // Check if refno already exists
            $check = mysqli_query($conn, "SELECT refno FROM s_itinery WHERE refno = '$refno'");
            if (mysqli_num_rows($check) > 0) {
                throw new Exception('Reference number already exists');
            }

            $sql = "INSERT INTO s_itinery (refno, sdate, entdate, sal_ex, Town, Area, Enable) 
                    VALUES ('$refno', '$sdate', '$entdate', '$sal_ex', '$town', '$area', $enable)";
            
            if (mysqli_query($conn, $sql)) {
                $response = ['success' => true, 'message' => 'Record saved successfully'];
            } else {
                throw new Exception('Error saving record: ' . mysqli_error($conn));
            }
            break;

        case 'update':
            $refno = mysqli_real_escape_string($conn, $_POST['refno']);
            $sdate = mysqli_real_escape_string($conn, $_POST['sdate']);
            $entdate = mysqli_real_escape_string($conn, $_POST['entdate']);
            $sal_ex = mysqli_real_escape_string($conn, $_POST['sal_ex']);
            $town = mysqli_real_escape_string($conn, $_POST['town']);
            $area = mysqli_real_escape_string($conn, $_POST['area']);
            $enable = intval($_POST['enable']);

            if (empty($refno)) {
                throw new Exception('Reference number is required for update');
            }

            // Security check: Regular users can only update their own records
            if (isset($_SESSION["CURRENT_REP"]) && $_SESSION["CURRENT_REP"] != "") {
                // Check if the record belongs to the current user
                $check_sql = "SELECT sal_ex FROM s_itinery WHERE refno = '$refno'";
                $check_result = mysqli_query($conn, $check_sql);
                if ($check_result && mysqli_num_rows($check_result) > 0) {
                    $check_row = mysqli_fetch_assoc($check_result);
                    if ($check_row['sal_ex'] != $_SESSION["CURRENT_REP"]) {
                        throw new Exception('You do not have permission to update this record');
                    }
                }
                
                // Also ensure they're not changing the sal_ex to someone else
                if ($sal_ex != $_SESSION["CURRENT_REP"]) {
                    throw new Exception('You can only update records for your own sales code');
                }
            }

            $sql = "UPDATE s_itinery SET 
                    sdate = '$sdate', 
                    entdate = '$entdate', 
                    sal_ex = '$sal_ex', 
                    Town = '$town', 
                    Area = '$area', 
                    Enable = $enable 
                    WHERE refno = '$refno'";
            
            if (mysqli_query($conn, $sql)) {
                $response = ['success' => true, 'message' => 'Record updated successfully'];
            } else {
                throw new Exception('Error updating record: ' . mysqli_error($conn));
            }
            break;

        case 'delete':
            $refno = mysqli_real_escape_string($conn, $_POST['refno']);

            if (empty($refno)) {
                throw new Exception('Reference number is required for deletion');
            }

            // Security check: Regular users can only delete their own records
            if (isset($_SESSION["CURRENT_REP"]) && $_SESSION["CURRENT_REP"] != "") {
                // Check if the record belongs to the current user
                $check_sql = "SELECT sal_ex FROM s_itinery WHERE refno = '$refno'";
                $check_result = mysqli_query($conn, $check_sql);
                if ($check_result && mysqli_num_rows($check_result) > 0) {
                    $check_row = mysqli_fetch_assoc($check_result);
                    if ($check_row['sal_ex'] != $_SESSION["CURRENT_REP"]) {
                        throw new Exception('You do not have permission to delete this record');
                    }
                }
            }

            $sql = "DELETE FROM s_itinery WHERE refno = '$refno'";
            
            if (mysqli_query($conn, $sql)) {
                $response = ['success' => true, 'message' => 'Record deleted successfully'];
            } else {
                throw new Exception('Error deleting record: ' . mysqli_error($conn));
            }
            break;

        case 'load':
            $refno = mysqli_real_escape_string($conn, $_POST['refno']);
            $sql = "SELECT * FROM s_itinery WHERE refno = '$refno'";
            $result = mysqli_query($conn, $sql);
            
            if (mysqli_num_rows($result) > 0) {
                $row = mysqli_fetch_assoc($result);
                
                // Security check: Regular users can only view their own records
                if (isset($_SESSION["CURRENT_REP"]) && $_SESSION["CURRENT_REP"] != "") {
                    if ($row['sal_ex'] != $_SESSION["CURRENT_REP"]) {
                        throw new Exception('You do not have permission to view this record');
                    }
                }
                // Manager check: Can only view their team's records
                else if (isset($_SESSION["MANAGER"]) && $_SESSION["MANAGER"] != "") {
                    $check_sql = "SELECT REPCODE FROM s_salrep 
                                  WHERE REPCODE = '" . mysqli_real_escape_string($conn, $row['sal_ex']) . "' 
                                  AND manager = '" . mysqli_real_escape_string($conn, $_SESSION["MANAGER"]) . "'";
                    $check_result = mysqli_query($conn, $check_sql);
                    if (!$check_result || mysqli_num_rows($check_result) == 0) {
                        throw new Exception('You do not have permission to view this record');
                    }
                }
                
                $response = [
                    'success' => true,
                    'data' => $row
                ];
            } else {
                throw new Exception('Record not found');
            }
            break;

        case 'list':
            // Apply filtering based on user role
            if (isset($_SESSION["MANAGER"]) && $_SESSION["MANAGER"] != "") {
                // Manager: Show records for their team members
                $sql = "SELECT i.* FROM s_itinery i 
                        INNER JOIN s_salrep s ON i.sal_ex = s.REPCODE 
                        WHERE (s.company='T' OR s.company='C') 
                        AND s.cancel='1' 
                        AND s.manager='" . mysqli_real_escape_string($conn, $_SESSION["MANAGER"]) . "' 
                        ORDER BY i.sdate DESC, i.refno DESC";
            } else if (!isset($_SESSION["CURRENT_REP"]) || $_SESSION["CURRENT_REP"] == "") {
                // Admin: Show all records
                $sql = "SELECT * FROM s_itinery ORDER BY sdate DESC, refno DESC";
            } else {
                // Regular user: Show only their own records
                $sql = "SELECT * FROM s_itinery 
                        WHERE sal_ex = '" . mysqli_real_escape_string($conn, $_SESSION["CURRENT_REP"]) . "' 
                        ORDER BY sdate DESC, refno DESC";
                        
            }
            
            $result = mysqli_query($conn, $sql);
            
            if (!$result) {
                throw new Exception('Error querying database: ' . mysqli_error($conn));
            }
            
            $records = [];
            
            while($row = mysqli_fetch_assoc($result)) {
                $records[] = $row;
            }
            
            $response = [
                'success' => true,
                'records' => $records
            ];
            break;

     

        default:
            throw new Exception('Invalid action');
    }
} catch (Exception $e) {
    $response = ['success' => false, 'message' => $e->getMessage()];
}

echo json_encode($response);
// Connection is handled globally, no need to close here
?>
